/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumerationLiteral;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.EventManager;
import org.netbeans.modules.uml.integration.ide.events.LiteralInfo;
import org.netbeans.modules.uml.integration.ide.events.SymbolTransaction;

public class LiteralTransaction {
    private IEnumerationLiteral mLiteral = null;
    private IProject mProj = null;
    private boolean mIsImplLiteral = false;
    private IClassifier mSym = null;

    public LiteralTransaction(IProject iProject) {
        this.setLiteral(null);
        this.setProject(iProject);
    }

    public LiteralTransaction(SymbolTransaction symbolTransaction, LiteralInfo literalInfo) {
        this(UMLSupport.getCurrentProject());
        if (literalInfo != null) {
            if (symbolTransaction.getSymbol() != null) {
                this.setSymbol(symbolTransaction.getSymbol());
            }
            this.setLiteral(symbolTransaction, literalInfo);
        }
    }

    protected void setProject(IProject iProject) {
        this.mProj = iProject;
    }

    public IProject getProject() {
        return this.mProj;
    }

    public IEnumerationLiteral getLiteral() {
        return this.mLiteral;
    }

    public void setLiteral(IEnumerationLiteral iEnumerationLiteral) {
        this.mLiteral = iEnumerationLiteral;
    }

    public boolean isImplLiteral() {
        return this.mIsImplLiteral;
    }

    public void setIsImplLiteral(boolean bl) {
        this.mIsImplLiteral = bl;
    }

    public void setLiteral(SymbolTransaction symbolTransaction, LiteralInfo literalInfo) {
        this.setLiteral(null);
        IEnumeration iEnumeration = (IEnumeration)symbolTransaction.getSymbol();
        if (iEnumeration != null) {
            this.mLiteral = this.findLiteral(iEnumeration, literalInfo.getName());
            if (this.mLiteral == null && literalInfo.getChangeType() == 0) {
                this.mLiteral = this.createLiteral(iEnumeration, literalInfo.getName());
            }
        }
    }

    public void setSymbol(IClassifier iClassifier) {
        this.mSym = iClassifier;
    }

    public IClassifier getSymbol() {
        return this.mSym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEnumerationLiteral createLiteral(IEnumeration iEnumeration, String string) {
        IEnumerationLiteral iEnumerationLiteral = null;
        EventManager.getEventManager().getEventFilter().blockEventType(44);
        try {
            if (this.findLiteral(iEnumeration, string) == null) {
                iEnumeration.addLiteral(iEnumeration.createLiteral(string));
            }
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
        finally {
            EventManager.getEventManager().getEventFilter().unblockEventType(44);
        }
        return iEnumerationLiteral;
    }

    private IEnumerationLiteral findLiteral(IEnumeration iEnumeration, String string) {
        for (IEnumerationLiteral iEnumerationLiteral : iEnumeration.getLiterals()) {
            if (!string.equals(iEnumerationLiteral.getName())) continue;
            return iEnumerationLiteral;
        }
        return null;
    }
}

