/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import java.lang.reflect.Modifier;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.IFacilityManager;
import org.netbeans.modules.uml.core.roundtripframework.IAttributeChangeFacility;
import org.netbeans.modules.uml.core.roundtripframework.IMethodChangeFacility;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.EventFilter;
import org.netbeans.modules.uml.integration.ide.events.EventProcessor;
import org.netbeans.modules.uml.integration.ide.events.IDEProcessor;
import org.netbeans.modules.uml.integration.ide.events.MemberTransaction;
import org.netbeans.modules.uml.integration.ide.events.MethodTransaction;
import org.netbeans.modules.uml.integration.ide.events.SymbolTransaction;

public class EventManager {
    private boolean mPreventEvents = false;
    private EventProcessor mToGDPro = null;
    private static EventManager mManager = null;
    private EventFilter filter = new EventFilter();
    private static boolean roundTripActive = false;
    private static IAttributeChangeFacility attributeFacility = null;
    private static IMethodChangeFacility methodFacility = null;

    protected EventManager() {
        this.connectGDPro();
    }

    public static synchronized void setRoundTripActive(boolean bl) {
        roundTripActive = bl;
    }

    public static synchronized boolean isRoundTripActive() {
        return roundTripActive;
    }

    public static IAttributeChangeFacility getAttributeFacility() {
        if (attributeFacility == null) {
            UMLSupport.getUMLSupport();
            IFacilityManager iFacilityManager = UMLSupport.getProduct().getFacilityManager();
            attributeFacility = (IAttributeChangeFacility)iFacilityManager.retrieveFacility("RoundTrip.JavaAttributeChangeFacility");
        }
        return attributeFacility;
    }

    public static IMethodChangeFacility getMethodFacility() {
        if (methodFacility == null) {
            UMLSupport.getUMLSupport();
            IFacilityManager iFacilityManager = UMLSupport.getProduct().getFacilityManager();
            methodFacility = (IMethodChangeFacility)iFacilityManager.retrieveFacility("RoundTrip.JavaMethodChangeFacility");
        }
        return methodFacility;
    }

    protected EventProcessor getGDProProcessor() {
        return this.mToGDPro;
    }

    public static synchronized EventManager getEventManager() {
        if (mManager == null) {
            mManager = new EventManager();
        }
        return mManager;
    }

    public EventFilter getEventFilter() {
        return this.filter;
    }

    public void connectGDPro() {
        this.mToGDPro = new IDEProcessor();
    }

    public void disconnectGDPro() {
        this.mToGDPro = null;
    }

    public void deleteClass(SymbolTransaction symbolTransaction) {
        if (!this.isBlocked()) {
            EventProcessor eventProcessor = this.getGDProProcessor();
            if (this.getGDProProcessor() != null) {
                eventProcessor.deleteClass(symbolTransaction);
            }
        }
    }

    public void deleteMethod(MethodTransaction methodTransaction) {
        if (!this.isBlocked()) {
            EventProcessor eventProcessor = this.getGDProProcessor();
            if (this.getGDProProcessor() != null) {
                eventProcessor.deleteMethod(methodTransaction);
            }
        }
    }

    public void addInterface(SymbolTransaction symbolTransaction, String string, String string2) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            eventProcessor.addInterface(symbolTransaction, string, string2);
        }
    }

    public void removeInterface(SymbolTransaction symbolTransaction, String string, String string2) {
        if (!this.isBlocked()) {
            EventProcessor eventProcessor = this.getGDProProcessor();
            if (eventProcessor != null) {
                eventProcessor.removeInterface(symbolTransaction, string, string2);
            }
        } else {
            Log.out((String)"Roundtrip is blocked in removeInterface, aborting");
        }
    }

    public void setExceptions(MethodTransaction methodTransaction, String[] stringArray) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + stringArray[i];
            }
            eventProcessor.setExceptions(methodTransaction, string);
        }
    }

    public void updatePackage(SymbolTransaction symbolTransaction, String string) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            eventProcessor.setAttribute(symbolTransaction, "ClassIdentifier.PackageName", string);
        }
    }

    public void updateClassModifers(SymbolTransaction symbolTransaction, int n) {
        IClassifier iClassifier;
        if (!this.isBlocked() && (iClassifier = symbolTransaction.getSymbol()) != null) {
            if (iClassifier.getIsAbstract() != Modifier.isAbstract(n)) {
                iClassifier.setIsAbstract(Modifier.isAbstract(n));
            }
            if (iClassifier.getIsLeaf() != Modifier.isFinal(n)) {
                iClassifier.setIsLeaf(Modifier.isFinal(n));
            }
            if (iClassifier.getVisibility() != JavaClassUtils.getDescribeModifier(n)) {
                iClassifier.setVisibility(JavaClassUtils.getDescribeModifier(n));
            }
        }
    }

    public void updateMethodModifers(MethodTransaction methodTransaction, int n) {
        IOperation iOperation;
        if (!this.isBlocked() && (iOperation = methodTransaction.getOperation()) != null) {
            Log.out((String)"Setting diff modifiers for the method .................. ");
            if (iOperation.getIsAbstract() != Modifier.isAbstract(n)) {
                iOperation.setIsAbstract(Modifier.isAbstract(n));
            }
            if (iOperation.getIsFinal() != Modifier.isFinal(n)) {
                iOperation.setIsFinal(Modifier.isFinal(n));
            }
            if (iOperation.getIsStatic() != Modifier.isStatic(n)) {
                iOperation.setIsStatic(Modifier.isStatic(n));
            }
            if (iOperation.getIsNative() != Modifier.isNative(n)) {
                iOperation.setIsNative(Modifier.isNative(n));
            }
            if (iOperation.getIsStrictFP() != Modifier.isStrict(n)) {
                iOperation.setIsStrictFP(Modifier.isStrict(n));
            }
            if (Modifier.isSynchronized(n)) {
                if (iOperation.getConcurrency() != 1) {
                    iOperation.setConcurrency(1);
                }
            } else if (iOperation.getConcurrency() != 0) {
                iOperation.setConcurrency(0);
            }
            if (iOperation.getIsNative() != Modifier.isNative(n)) {
                iOperation.setIsNative(Modifier.isNative(n));
            }
            if (iOperation.getVisibility() != JavaClassUtils.getDescribeModifier(n)) {
                iOperation.setVisibility(JavaClassUtils.getDescribeModifier(n));
            }
        }
    }

    public void updateMethodType(MethodTransaction methodTransaction, String string) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            eventProcessor.setAttribute(methodTransaction, "ReturnType", string);
        }
    }

    public void updateMemberType(MemberTransaction memberTransaction, String string, String string2) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            eventProcessor.updateMemberType(memberTransaction, string, string2);
        }
    }

    public void updateMemberModifers(MemberTransaction memberTransaction, int n) {
        IStructuralFeature iStructuralFeature;
        if (!this.isBlocked() && (iStructuralFeature = memberTransaction.getAttribute()) != null) {
            iStructuralFeature.setIsFinal(Modifier.isFinal(n));
            iStructuralFeature.setIsStatic(Modifier.isStatic(n));
            iStructuralFeature.setIsVolatile(Modifier.isVolatile(n));
            iStructuralFeature.setIsTransient(Modifier.isTransient(n));
            iStructuralFeature.setVisibility(JavaClassUtils.getDescribeModifier(n));
        }
    }

    public void setAsInterface(SymbolTransaction symbolTransaction, boolean bl) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            if (bl) {
                if (symbolTransaction.getSymbol() instanceof IClass) {
                    IClassifier iClassifier = symbolTransaction.getSymbol().transform("Interface");
                    symbolTransaction.setSymbol(iClassifier);
                }
            } else if (symbolTransaction.getSymbol() instanceof IInterface) {
                IClassifier iClassifier = symbolTransaction.getSymbol().transform("Class");
                iClassifier.removeStereotype2("interface");
                symbolTransaction.setSymbol(iClassifier);
            }
        }
    }

    public void setAsEnumeration(SymbolTransaction symbolTransaction, boolean bl) {
        EventProcessor eventProcessor;
        if (!this.isBlocked() && (eventProcessor = this.getGDProProcessor()) != null) {
            if (bl) {
                if (symbolTransaction.getSymbol() instanceof IClass) {
                    IClassifier iClassifier = symbolTransaction.getSymbol().transform("Enumeration");
                    symbolTransaction.setSymbol(iClassifier);
                }
            } else if (symbolTransaction.getSymbol() instanceof IEnumeration) {
                IClassifier iClassifier = symbolTransaction.getSymbol().transform("Class");
                iClassifier.removeStereotype2("enumeration");
                symbolTransaction.setSymbol(iClassifier);
            }
        }
    }

    protected final synchronized void blockTransactions(boolean bl) {
        this.mPreventEvents = bl;
    }

    protected final synchronized boolean isBlocked() {
        return this.mPreventEvents;
    }

    public class GDProRTEvents {
        protected boolean isJavaFile(String string) {
            return string.endsWith(".java");
        }
    }
}

