/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ITaggedValue;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.integration.ide.events.InvalidIdentifierException;

public abstract class ElementInfo
implements Cloneable {
    public static final int CREATE = 0;
    public static final int MODIFY = 1;
    public static final int DELETE = 2;
    private String mName = null;
    private String mNewName = null;
    protected Integer mModifiers = null;
    private int mChangeType = 0;
    private String mComment = null;
    private boolean isCommentSet = false;
    private INamedElement element;

    public ElementInfo(int n) {
        this.setChangeType(n);
    }

    public IProject getProject() {
        return null;
    }

    public String getFilename() {
        return null;
    }

    public ElementInfo(INamedElement iNamedElement) {
        this.setChangeType(1);
        if (iNamedElement != null) {
            this.setComment(iNamedElement.getDocumentation());
        }
        this.element = iNamedElement;
    }

    public abstract void update();

    public IProject getOwningProject() {
        return null;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setNewName(String string) {
        this.mNewName = string;
    }

    public String getNewName() {
        return this.mNewName;
    }

    public void setModifiers(Integer n) {
        this.mModifiers = n;
    }

    public Integer getModifiers() {
        return this.mModifiers;
    }

    public void setChangeType(int n) {
        this.mChangeType = n;
    }

    public int getChangeType() {
        return this.mChangeType;
    }

    public String getChangeName() {
        String string = "";
        switch (this.getChangeType()) {
            case 0: {
                string = "Create";
                break;
            }
            case 1: {
                string = "Modify";
                break;
            }
            case 2: {
                string = "Delete";
            }
        }
        return string;
    }

    public void setComment(String string) {
        if (string == null) {
            return;
        }
        this.mComment = string.trim();
        this.isCommentSet = true;
    }

    public boolean isCommentSet() {
        return this.isCommentSet;
    }

    public String getMarkerID() {
        String string = null;
        ITaggedValue iTaggedValue = this.element.getTaggedValueByName("MarkerID");
        if (iTaggedValue != null) {
            string = iTaggedValue.getDataValue();
        }
        if (string == null || string.trim().equals("")) {
            string = this.element.getXMIID();
        }
        return string;
    }

    public String getComment() {
        if (this.mComment != null && this.mComment.trim().length() == 0) {
            this.mComment = null;
        }
        return this.mComment;
    }

    public static boolean isIdentifier(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void assertIsIdentifier(String string) throws InvalidIdentifierException {
        if (!ElementInfo.isIdentifier(string)) {
            throw new InvalidIdentifierException("'" + string + "' is not a valid Java identifier");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getCode();

    public void syncFields() {
        if (this.getNewName() != null) {
            this.setName(this.getNewName());
            this.setNewName(null);
        }
    }

    public boolean matches(ElementInfo elementInfo) {
        return this == elementInfo;
    }
}

