/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.dialogs;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.uml.integration.ide.UMLSupport;

public class ExceptionDialog
extends JDialog {
    protected static final String REPORT_MESSAGE = UMLSupport.getString("Errors.StdMessage");
    protected static final Dimension NO_DETAILS_SIZE = new Dimension(500, 160);
    protected static final Dimension WITH_DETAILS_SIZE = new Dimension(650, 250);
    protected static final String HIDE_DETAILS = UMLSupport.getString("Errors.HideDetails");
    protected static final String SHOW_DETAILS = UMLSupport.getString("Errors.ShowDetails");
    protected static final String DETAILS_CARD = UMLSupport.getString("Errors.WithDetails");
    protected static final String NO_DETAILS_CARD = UMLSupport.getString("Errors.NoDetails");
    private JPanel mCards;
    private JEditorPane mErrorMessage;
    private JScrollPane jScrollPane1;
    private JTextArea mDetailTxt;
    private JPanel mButtonPane;
    private JButton mShowDetailsBtn;
    private JButton mOkBtn;

    public ExceptionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setSize(NO_DETAILS_SIZE);
        this.mErrorMessage.setEditorKit(new HTMLEditorKit());
        this.setLocationRelativeTo(null);
        this.setupForNoDetails();
        this.mButtonPane.getRootPane().setDefaultButton(this.mOkBtn);
    }

    public void setMessage(String string) {
        this.mErrorMessage.setText(string + "<br>" + REPORT_MESSAGE);
    }

    public void setDetailMessage(String string) {
        this.mDetailTxt.setText(string);
    }

    public void setDetailMessage(Exception exception) {
        this.mDetailTxt.setText(this.getStackTrace(exception));
        this.mDetailTxt.setCaretPosition(0);
    }

    protected String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void initComponents() {
        this.mCards = new JPanel();
        this.mErrorMessage = new JEditorPane();
        this.jScrollPane1 = new JScrollPane();
        this.mDetailTxt = new JTextArea();
        this.mButtonPane = new JPanel();
        this.mShowDetailsBtn = new JButton();
        this.mOkBtn = new JButton();
        this.setTitle(UMLSupport.getString("Errors.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExceptionDialog.this.closeDialog(windowEvent);
            }
        });
        this.mCards.setLayout(new CardLayout());
        this.mCards.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.mErrorMessage.setPreferredSize(new Dimension(0, 0));
        this.mErrorMessage.setEditable(false);
        this.mErrorMessage.setOpaque(false);
        this.mCards.add((Component)this.mErrorMessage, NO_DETAILS_CARD);
        this.mDetailTxt.setEditable(false);
        this.mDetailTxt.setTabSize(4);
        this.mDetailTxt.setOpaque(false);
        this.jScrollPane1.setViewportView(this.mDetailTxt);
        this.mCards.add((Component)this.jScrollPane1, DETAILS_CARD);
        this.getContentPane().add((Component)this.mCards, "Center");
        this.mButtonPane.setLayout(new BoxLayout(this.mButtonPane, 0));
        this.mButtonPane.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.mShowDetailsBtn.setActionCommand(SHOW_DETAILS);
        this.mShowDetailsBtn.setText(SHOW_DETAILS);
        this.mShowDetailsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.mShowDetailsBtnActionPerformed(actionEvent);
            }
        });
        this.mButtonPane.add(this.mShowDetailsBtn);
        this.mButtonPane.add(Box.createHorizontalGlue());
        this.mOkBtn.setText(UMLSupport.getString("labels.ok"));
        this.mOkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.mOkBtnActionPerformed(actionEvent);
            }
        });
        this.mButtonPane.add(this.mOkBtn);
        this.getContentPane().add((Component)this.mButtonPane, "South");
    }

    private void mShowDetailsBtnActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SHOW_DETAILS)) {
            this.setupForWithDetails();
        } else {
            this.setupForNoDetails();
        }
        this.validate();
    }

    protected void setupForNoDetails() {
        this.setSize(NO_DETAILS_SIZE);
        this.mShowDetailsBtn.setText(SHOW_DETAILS);
        this.mShowDetailsBtn.setActionCommand(SHOW_DETAILS);
        CardLayout cardLayout = (CardLayout)this.mCards.getLayout();
        cardLayout.show(this.mCards, NO_DETAILS_CARD);
    }

    protected void setupForWithDetails() {
        this.setSize(WITH_DETAILS_SIZE);
        this.mShowDetailsBtn.setText(HIDE_DETAILS);
        this.mShowDetailsBtn.setActionCommand(HIDE_DETAILS);
        CardLayout cardLayout = (CardLayout)this.mCards.getLayout();
        cardLayout.show(this.mCards, DETAILS_CARD);
    }

    private void mOkBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void showExceptionError(String string, Exception exception) {
        ExceptionDialog exceptionDialog = new ExceptionDialog((Frame)new JFrame(), true);
        exceptionDialog.setMessage(string);
        exceptionDialog.setDetailMessage(exception);
        exceptionDialog.setVisible(true);
    }

    public static void showExceptionError(Exception exception) {
        ExceptionDialog exceptionDialog = new ExceptionDialog((Frame)new JFrame(), true);
        exceptionDialog.setMessage(exception.getLocalizedMessage());
        exceptionDialog.setDetailMessage(exception);
        exceptionDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        ExceptionDialog exceptionDialog = new ExceptionDialog((Frame)new JFrame(), true);
        exceptionDialog.setMessage("This is a <B>TEST</B> Error Message!");
        String string = "This is a very long detail message..........................VERY VERY VERY VERY VERY................................. Very long indeed\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        string = string + "I really hope that his scrollbars are working.............\n";
        exceptionDialog.setDetailMessage(string);
        exceptionDialog.setVisible(true);
    }
}

