/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.actions;

import java.util.List;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.ui.java.UMLJavaAssociationUtil;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class SelectInModel
extends CookieAction {
    protected void performAction(Node[] nodeArray) {
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject != null) {
            ProjectUtil.selectInModel((List)UMLJavaAssociationUtil.getAllAssociatedUMLProjects((DataObject)dataObject), (DataObject)dataObject);
        } else {
            IElement iElement = (IElement)nodeArray[0].getCookie(IElement.class);
            if (iElement != null) {
                ProjectUtil.findElementInProjectTree((IElement)iElement);
            }
        }
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage(SelectInModel.class, (String)"CTL_SelectInModel");
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = super.getPopupPresenter();
        jMenuItem.setText(NbBundle.getMessage(SelectInModel.class, (String)"LBL_Popup_SelectInModel"));
        return jMenuItem;
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class, IElement.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (!super.enable(nodeArray)) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            return UMLJavaAssociationUtil.getAssociatedUMLProject((Project)project) != null;
        }
        return (IElement)nodeArray[0].getCookie(IElement.class) != null;
    }

    private Project getAssociatedUMLProject(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        return UMLJavaAssociationUtil.getAssociatedUMLProject((Project)project);
    }
}

