/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.integration.ide.EventFrameworkSink;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.ElementInfo;
import org.netbeans.modules.uml.integration.ide.events.EventFilter;
import org.netbeans.modules.uml.integration.ide.events.EventManager;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;

public abstract class RoundTripSource {
    private UMLSupport umlsupport = UMLSupport.getUMLSupport();
    private EventFilter filter = EventManager.getEventManager().getEventFilter();
    private static boolean projectSwitchingEnabled = false;
    private static boolean eventsBlocked = false;

    protected void queue(Runnable runnable) {
        this.umlsupport.getRoundtripQueue().queueRunnable(runnable);
    }

    protected boolean isValidEventType(int n) {
        return this.filter.isValidEventType(n);
    }

    protected boolean isValidEvent(ElementInfo elementInfo, ClassInfo classInfo) {
        return this.filter.isValid(elementInfo, classInfo);
    }

    protected boolean isValidEvent(INamedElement iNamedElement) {
        return !eventsBlocked && this.filter.isValid(iNamedElement);
    }

    protected void scheduleForNavigation(IElement iElement) {
        try {
            EventFrameworkSink eventFrameworkSink = UMLSupport.getUMLSupport().getSinkManager().getEventFrameworkSink();
            if (eventFrameworkSink != null) {
                eventFrameworkSink.navigateLater(iElement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setDefaultProject(ElementInfo elementInfo) {
        if (projectSwitchingEnabled && elementInfo != null) {
            UMLSupport.setDefaultProject(elementInfo.getProject());
            if (!UMLSupport.getUMLSupport().getIDEManager().activateIDEProject(UMLSupport.getDefaultProject())) {
                throw new RoundtripVetoException("");
            }
        }
    }

    protected void setDefaultProject(MethodInfo methodInfo) {
        if (projectSwitchingEnabled && methodInfo != null) {
            UMLSupport.setDefaultProject(methodInfo.getProject());
            if (!UMLSupport.getUMLSupport().getIDEManager().activateIDEProject(UMLSupport.getDefaultProject())) {
                throw new RoundtripVetoException("");
            }
        }
    }

    public static void setProjectSwitchingEnabled(boolean bl) {
        projectSwitchingEnabled = bl;
    }

    public static void setEventsBlocked(boolean bl) {
        eventsBlocked = bl;
    }

    public static class RoundtripVetoException
    extends RuntimeException {
        public RoundtripVetoException() {
        }

        public RoundtripVetoException(String string) {
            super(string);
        }
    }

    public static abstract class RoundtripThread
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                EventManager.setRoundTripActive(true);
                this.work();
            }
            finally {
                EventManager.setRoundTripActive(false);
            }
        }

        public abstract void work();
    }
}

