/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.roundtripframework.IChangeRequest;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.events.MethodParameterInfo;

public class ChangeUtils {
    public static final short CT_MODIFY = 0;
    public static final short CT_DELETE = 1;
    public static final short CT_CREATE = 2;
    static final String[] changeTypes = new String[]{"CT_MODIFY", "CT_DELETE", "CT_CREATE"};
    public static final int RDT_NONE = 0;
    public static final int RDT_DOCUMENTATION_MODIFIED = 1;
    public static final int RDT_ELEMENT_DELETED = 2;
    public static final int RDT_NAME_MODIFIED = 3;
    public static final int RDT_VISIBILITY_MODIFIED = 4;
    public static final int RDT_ELEMENT_ADDED_TO_NAMESPACE = 5;
    public static final int RDT_RELATION_VALIDATE = 6;
    public static final int RDT_RELATION_MODIFIED = 7;
    public static final int RDT_RELATION_DELETED = 8;
    public static final int RDT_ATTRIBUTE_DEFAULT_MODIFIED = 9;
    public static final int RDT_ATTRIBUTE_DEFAULT_BODY_MODIFIED = 10;
    public static final int RDT_ATTRIBUTE_DEFAULT_LANGUAGE_MODIFIED = 11;
    public static final int RDT_CONCURRENCY_MODIFIED = 12;
    public static final int RDT_SIGNAL_ADDED = 13;
    public static final int RDT_SIGNAL_REMOVED = 14;
    public static final int RDT_PARAMETER_ADDED = 15;
    public static final int RDT_PARAMETER_REMOVED = 16;
    public static final int RDT_ABSTRACT_MODIFIED = 17;
    public static final int RDT_FEATURE_ADDED = 18;
    public static final int RDT_FEATURE_REMOVED = 19;
    public static final int RDT_STATIC_MODIFIED = 20;
    public static final int RDT_CONDITION_ADDED = 21;
    public static final int RDT_CONDITION_REMOVED = 22;
    public static final int RDT_QUERY_MODIFIED = 23;
    public static final int RDT_PARAMETER_DEFAULT_MODIFIED = 24;
    public static final int RDT_PARAMETER_DEFAULT_BODY_MODIFIED = 25;
    public static final int RDT_PARAMETER_DEFAULT_LANGUAGE_MODIFIED = 26;
    public static final int RDT_PARAMETER_DIRECTION_MODIFIED = 27;
    public static final int RDT_CHANGEABILITY_MODIFIED = 28;
    public static final int RDT_MULTIPLICITY_MODIFIED = 29;
    public static final int RDT_TYPE_MODIFIED = 30;
    public static final int RDT_LOWER_MODIFIED = 31;
    public static final int RDT_UPPER_MODIFIED = 32;
    public static final int RDT_RANGE_ADDED = 33;
    public static final int RDT_RANGE_REMOVED = 34;
    public static final int RDT_ORDER_MODIFIED = 35;
    public static final int RDT_PACKAGE_NAME_MODIFIED = 36;
    public static final int RDT_TRANSIENT_MODIFIED = 37;
    public static final int RDT_NATIVE_MODIFIED = 38;
    public static final int RDT_VOLATILE_MODIFIED = 39;
    public static final int RDT_LEAF_MODIFIED = 40;
    public static final int RDT_RELATION_END_MODIFIED = 41;
    public static final int RDT_RELATION_END_ADDED = 42;
    public static final int RDT_RELATION_END_REMOVED = 43;
    public static final int RDT_DEPENDENCY_ADDED = 44;
    public static final int RDT_DEPENDENCY_REMOVED = 45;
    public static final int RDT_ASSOCIATION_END_MODIFIED = 46;
    public static final int RDT_ASSOCIATION_END_ADDED = 47;
    public static final int RDT_ASSOCIATION_END_REMOVED = 48;
    public static final int RDT_RELATION_CREATED = 49;
    public static final int RDT_FEATURE_MOVED = 50;
    public static final int RDT_FEATURE_DUPLICATED = 51;
    public static final int RDT_NAMESPACE_MODIFIED = 52;
    public static final int RDT_CHANGED_NAMESPACE = 53;
    public static final int RDT_NAMESPACE_MOVED = 54;
    public static final int RDT_FINAL_MODIFIED = 55;
    public static final int RDT_STRICTFP_MODIFIED = 56;
    public static final int RDT_MULTIPLE_PARAMETER_TYPE_MODIFIED = 57;
    public static final int RDT_TRANSFORM = 58;
    public static final int RDT_EXCEPTION_ADDED = 59;
    public static final int RDT_EXCEPTION_REMOVED = 60;
    public static final int RDT_SIGNATURE_CHANGED = 61;
    public static final int RDT_SOURCE_DIR_CHANGED = 62;
    static final String[] reqDetailEnum = new String[]{"RDT_NONE", "RDT_DOCUMENTATION_MODIFIED", "RDT_ELEMENT_DELETED", "RDT_NAME_MODIFIED", "RDT_VISIBILITY_MODIFIED", "RDT_ELEMENT_ADDED_TO_NAMESPACE", "RDT_RELATION_VALIDATE", "RDT_RELATION_MODIFIED", "RDT_RELATION_DELETED", "RDT_ATTRIBUTE_DEFAULT_MODIFIED", "RDT_ATTRIBUTE_DEFAULT_BODY_MODIFIED", "RDT_ATTRIBUTE_DEFAULT_LANGUAGE_MODIFIED", "RDT_CONCURRENCY_MODIFIED", "RDT_SIGNAL_ADDED", "RDT_SIGNAL_REMOVED", "RDT_PARAMETER_ADDED", "RDT_PARAMETER_REMOVED", "RDT_ABSTRACT_MODIFIED", "RDT_FEATURE_ADDED", "RDT_FEATURE_REMOVED", "RDT_STATIC_MODIFIED", "RDT_CONDITION_ADDED", "RDT_CONDITION_REMOVED", "RDT_QUERY_MODIFIED", "RDT_PARAMETER_DEFAULT_MODIFIED", "RDT_PARAMETER_DEFAULT_BODY_MODIFIED", "RDT_PARAMETER_DEFAULT_LANGUAGE_MODIFIED", "RDT_PARAMETER_DIRECTION_MODIFIED", "RDT_CHANGEABILITY_MODIFIED", "RDT_MULTIPLICITY_MODIFIED", "RDT_TYPE_MODIFIED", "RDT_LOWER_MODIFIED", "RDT_UPPER_MODIFIED", "RDT_RANGE_ADDED", "RDT_RANGE_REMOVED", "RDT_ORDER_MODIFIED", "RDT_PACKAGE_NAME_MODIFIED", "RDT_TRANSIENT_MODIFIED", "RDT_NATIVE_MODIFIED", "RDT_VOLATILE_MODIFIED", "RDT_LEAF_MODIFIED", "RDT_RELATION_END_MODIFIED", "RDT_RELATION_END_ADDED", "RDT_RELATION_END_REMOVED", "RDT_DEPENDENCY_ADDED", "RDT_DEPENDENCY_REMOVED", "RDT_ASSOCIATION_END_MODIFIED", "RDT_ASSOCIATION_END_ADDED", "RDT_ASSOCIATION_END_REMOVED", "RDT_RELATION_CREATED", "RDT_FEATURE_MOVED", "RDT_FEATURE_DUPLICATED", "RDT_NAMESPACE_MODIFIED", "RDT_CHANGED_NAMESPACE", "RDT_NAMESPACE_MOVED", "RDT_FINAL_MODIFIED", "RDT_STRICTFP_MODIFIED", "RDT_MULTIPLE_PARAMETER_TYPE_MODIFIED", "RDT_TRANSFORM", "RDT_EXCEPTION_ADDED", "RDT_EXCEPTION_REMOVED", "RDT_SIGNATURE_CHANGED", "RDT_SOURCE_DIR_CHANGED"};
    public static final String REL_GENER = "Generalization";
    public static final String REL_REALZ = "Realization";
    public static final String REL_IMPL = "Implementation";
    public static final String REL_ASSOS = "Association";

    private static void say(String string) {
        Log.out((String)string);
    }

    private static void say(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() < 29) {
            char[] cArray = new char[29 - string.length()];
            Arrays.fill(cArray, ' ');
            stringBuffer.append(cArray);
        }
        stringBuffer.append(": ").append(string2);
        Log.out((String)stringBuffer.toString());
    }

    private static String getVis(int n) {
        return Modifier.toString(JavaClassUtils.getJavaModifier(n));
    }

    public static void say(IChangeRequest iChangeRequest) {
    }

    public static void sayElement(IElement iElement) {
        if (iElement instanceof IClass) {
            IClass iClass = (IClass)iElement;
            ChangeUtils.sayClass(iClass);
        } else if (iElement instanceof IInterface) {
            IInterface iInterface = (IInterface)iElement;
            ChangeUtils.sayInterface(iInterface);
        } else if (iElement instanceof IAttribute) {
            IAttribute iAttribute = (IAttribute)iElement;
            ChangeUtils.sayAttribute(iAttribute);
        } else if (iElement instanceof IOperation) {
            IOperation iOperation = (IOperation)iElement;
            ChangeUtils.sayOperation(iOperation);
        } else if (iElement instanceof IParameter) {
            IParameter iParameter = (IParameter)iElement;
            ChangeUtils.sayParameter(iParameter);
        } else if (iElement instanceof IAssociation) {
            IAssociation iAssociation = (IAssociation)iElement;
            ChangeUtils.sayAssociation(iAssociation);
        } else if (iElement instanceof IAssociationEnd) {
            IAssociationEnd iAssociationEnd = (IAssociationEnd)iElement;
            ChangeUtils.sayAssociation(iAssociationEnd.getAssociation());
        }
    }

    public static void sayAssociation(IAssociation iAssociation) {
        if (iAssociation == null) {
            return;
        }
        ChangeUtils.say(" Association type", iAssociation.getElementType());
        ChangeUtils.say(" Association end participants");
        ETList eTList = iAssociation.getAssociationEnds();
        if (eTList != null) {
            for (int i = 0; i < eTList.getCount(); ++i) {
                IAssociationEnd iAssociationEnd = (IAssociationEnd)eTList.item(i);
                IClassifier iClassifier = iAssociationEnd.getParticipant();
                ChangeUtils.say("    " + (iAssociationEnd.getIsNavigable() ? "-> " : "   ") + iClassifier.getName());
            }
        } else {
            ChangeUtils.say("    << None >>");
        }
    }

    public static void sayClass(IClass iClass) {
        ChangeUtils.say(" Class name", JavaClassUtils.getFullyQualifiedName((INamedElement)iClass));
        ChangeUtils.say(" Modifiers", ChangeUtils.getVis(iClass.getVisibility()));
        ChangeUtils.say(" Superclass", ChangeUtils.getSuperclasses((IClassifier)iClass));
        ChangeUtils.say(" Subclasses", ChangeUtils.getSubclasses(iClass));
        ChangeUtils.say(" Interfaces", ChangeUtils.getSuperInterfaces((IClassifier)iClass));
    }

    public static void sayInterface(IInterface iInterface) {
        ChangeUtils.say(" Interface name", JavaClassUtils.getFullyQualifiedName((INamedElement)iInterface));
        ChangeUtils.say(" Modifiers", ChangeUtils.getVis(iInterface.getVisibility()));
        ChangeUtils.say(" Superclasses?", ChangeUtils.getSuperclasses((IClassifier)iInterface));
        ChangeUtils.say(" Super interfaces", ChangeUtils.getSuperInterfaces(iInterface));
        ChangeUtils.say(" Sub types", ChangeUtils.getSubTypes(iInterface));
    }

    public static void sayParameter(IParameter iParameter) {
        ChangeUtils.say(" Parameter name", iParameter.getName());
        ChangeUtils.say(" Type", iParameter.getTypeName());
        ChangeUtils.say(" Owning operation:");
        IOperation iOperation = (IOperation)iParameter.getOwner();
        ChangeUtils.sayOperation(iOperation);
    }

    public static void sayOperation(IOperation iOperation) {
        IParameter iParameter;
        StringBuffer stringBuffer = new StringBuffer();
        ETList eTList = iOperation.getFormalParameters();
        for (int i = 0; eTList != null && i < eTList.getCount(); ++i) {
            iParameter = (IParameter)eTList.item(i);
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(MethodParameterInfo.getType(iParameter) + " " + iParameter.getName());
        }
        IParameter iParameter2 = iOperation.getReturnType();
        ChangeUtils.say(" Operation", ChangeUtils.getVis(iOperation.getVisibility()) + " " + iOperation.getName() + "(" + stringBuffer.toString() + ") : " + (iParameter2 != null ? iParameter2.getTypeName() : ""));
        iParameter = iOperation.getOwner();
        if (iParameter instanceof INamedElement) {
            INamedElement iNamedElement = (INamedElement)iParameter;
            ChangeUtils.say(" Owner", iNamedElement.getName());
        }
    }

    public static void sayAttribute(IAttribute iAttribute) {
        ChangeUtils.say(" Attribute", iAttribute.getName());
        ChangeUtils.say(" Type", iAttribute.getTypeName());
        ChangeUtils.say(" Modifiers", ChangeUtils.getVis(iAttribute.getVisibility()));
        IElement iElement = iAttribute.getOwner();
        if (iElement instanceof INamedElement) {
            INamedElement iNamedElement = (INamedElement)iElement;
            ChangeUtils.say(" Owner", iNamedElement.getName());
        }
    }

    public static String getSuperclasses(IClassifier iClassifier) {
        ETList eTList = iClassifier.getGeneralizations();
        if (eTList != null && eTList.getCount() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < eTList.getCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((IGeneralization)eTList.item(i)).getGeneral().getName());
            }
            return stringBuffer.toString();
        }
        return "<none>";
    }

    public static String getSubclasses(IClass iClass) {
        ETList eTList = iClass.getSpecializations();
        if (eTList != null && eTList.getCount() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < eTList.getCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((IGeneralization)eTList.item(i)).getSpecific().getName());
            }
            return stringBuffer.toString();
        }
        return "<none>";
    }

    public static String getSuperInterfaces(IClassifier iClassifier) {
        ETList eTList = iClassifier.getImplementations();
        if (eTList != null && eTList.getCount() > 0) {
            StringBuffer stringBuffer = new StringBuffer("{" + eTList.getCount() + "} ");
            for (int i = 0; i < eTList.getCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                INamedElement iNamedElement = ((IImplementation)eTList.item(i)).getSupplier();
                stringBuffer.append(iNamedElement.getName());
            }
            return stringBuffer.toString();
        }
        return "<none>";
    }

    public static String getSuperInterfaces(IInterface iInterface) {
        return ChangeUtils.getSuperInterfaces((IClassifier)iInterface);
    }

    public static String getSubTypes(IInterface iInterface) {
        return "<not impl>";
    }
}

