/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.finddialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.text.Position;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.preferenceframework.PreferenceAccessor;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.finddialog.DefaultFindDialogResource;
import org.netbeans.modules.uml.integration.finddialog.FindController;
import org.netbeans.modules.uml.integration.finddialog.IFindResults;
import org.netbeans.modules.uml.integration.finddialog.ui.FindTableModel;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.ui.support.UserSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUtilities {
    static boolean m_bWaiting = false;

    public static void initializeGrid(JTable jTable) {
    }

    public static ETList<String> buildColumns() {
        ETArrayList eTArrayList = new ETArrayList();
        eTArrayList.add((Object)"IDS_ICON");
        eTArrayList.add((Object)"IDS_NAME");
        eTArrayList.add((Object)"IDS_ALIAS");
        eTArrayList.add((Object)"IDS_TYPE");
        eTArrayList.add((Object)"IDS_FULLNAME");
        eTArrayList.add((Object)"IDS_PROJECT");
        return eTArrayList;
    }

    public static void populateComboBoxes(String string, JComboBox jComboBox) {
        ETList eTList;
        String string2;
        UserSettings userSettings = new UserSettings();
        if (userSettings != null && (string2 = userSettings.getSettingValue("FindDialog", string)) != null && string2.length() > 0 && (eTList = StringUtilities.splitOnDelimiter((String)string2, (String)"|")) != null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            int n = eTList.size();
            for (int i = n - 1; i >= 0; --i) {
                String string3 = (String)eTList.get(i);
                if (string3 == null || string3.length() <= 0) continue;
                defaultComboBoxModel.addElement(string3);
            }
            jComboBox.setModel(defaultComboBoxModel);
        }
    }

    public static void saveSearchString(String string, JComboBox jComboBox) {
        UserSettings userSettings;
        String string2 = (String)jComboBox.getSelectedItem();
        if (string2 != null && string2.length() > 0 && (userSettings = new UserSettings()) != null) {
            String string3 = userSettings.getSettingValue("FindDialog", string);
            if (string3 != null && string3.length() > 0) {
                ETList eTList = StringUtilities.splitOnDelimiter((String)string3, (String)"|");
                if (eTList != null) {
                    int n = eTList.size();
                    if (n > 10) {
                        if (!FindUtilities.inList(string2, (ETList<String>)eTList)) {
                            String string4 = "";
                            for (int i = 1; i < n; ++i) {
                                String string5 = (String)eTList.get(i);
                                if (string5 == null || string5.length() <= 0) continue;
                                string4 = string4 + string5;
                                string4 = string4 + "|";
                            }
                            string4 = string4 + string2;
                            userSettings.setSettingValue("FindDialog", string, string4);
                        }
                    } else if (!FindUtilities.inList(string2, (ETList<String>)eTList)) {
                        string3 = string3 + "|";
                        string3 = string3 + string2;
                        userSettings.setSettingValue("FindDialog", string, string3);
                    }
                }
            } else {
                userSettings.setSettingValue("FindDialog", string, string2);
            }
        }
    }

    public static boolean inList(String string, ETList<String> eTList) {
        boolean bl = false;
        for (int i = 0; i < eTList.size(); ++i) {
            String string2 = (String)eTList.get(i);
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void populateProjectList(JList jList) {
        Project[] projectArray = ProjectUtil.getOpenUMLProjects();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < projectArray.length; ++i) {
            String string;
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)projectArray[i].getLookup().lookup(UMLProjectHelper.class);
            if (uMLProjectHelper == null) continue;
            IProject iProject = uMLProjectHelper.getProject();
            if (iProject != null && (string = iProject.getName()).length() > 0) {
                defaultListModel.addElement(string);
            }
            jList.setModel(defaultListModel);
        }
    }

    public static boolean onDblClickFindResults(int n, FindTableModel findTableModel, FindController findController, boolean bl) {
        boolean bl2 = false;
        IElement iElement = findTableModel.getElementAtRow(n);
        if (iElement != null) {
            bl2 = findController.navigateToElement(iElement, bl);
        } else {
            IProxyDiagram iProxyDiagram = findTableModel.getDiagramAtRow(n);
            if (iProxyDiagram != null) {
                bl2 = findController.navigateToDiagram(iProxyDiagram);
            }
        }
        return bl2;
    }

    public static void loadController() {
    }

    public static ETList<Object> loadResultsIntoArray(IFindResults iFindResults) {
        ETArrayList eTArrayList = new ETArrayList();
        if (iFindResults != null) {
            ETList<IProxyDiagram> eTList;
            int n;
            ETList<IElement> eTList2 = iFindResults.getElements();
            if (eTList2 != null) {
                int n2 = eTList2.size();
                for (n = 0; n < n2; ++n) {
                    IElement iElement = (IElement)eTList2.get(n);
                    if (iElement == null) continue;
                    eTArrayList.add((Object)iElement);
                }
            }
            if ((eTList = iFindResults.getDiagrams()) != null) {
                n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    IProxyDiagram iProxyDiagram = (IProxyDiagram)eTList.get(i);
                    if (iProxyDiagram == null) continue;
                    eTArrayList.add((Object)iProxyDiagram);
                }
            }
        }
        return eTArrayList;
    }

    public static void loadResults(JTable jTable, IFindResults iFindResults) {
    }

    public static void selectProjectInList(JList jList) {
        if (jList != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Project[] projectArray = ProjectUtil.getSelectedProjects(UMLProject.class);
            for (int i = 0; i < projectArray.length; ++i) {
                String string;
                int n;
                UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)projectArray[i].getLookup().lookup(UMLProjectHelper.class);
                if (uMLProjectHelper == null || (n = jList.getNextMatch(string = uMLProjectHelper.getProject().getName(), 0, Position.Bias.Forward)) == -1) continue;
                arrayList.add(n);
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            if (nArray.length > 0) {
                jList.setSelectedIndices(nArray);
            } else {
                jList.setSelectedIndex(0);
            }
        }
    }

    public static void setPicture() {
    }

    public static void setPictureD() {
    }

    public static void loadProjectListOfController(JList jList, FindController findController) {
        Object[] objectArray;
        if (jList != null && findController != null && (objectArray = jList.getSelectedValues()).length > 0) {
            for (Object object : objectArray) {
                if (object == null || !(object instanceof String)) continue;
                String string = (String)object;
                findController.addToProjectList(string);
            }
        }
    }

    public static String translateString(String string) {
        return DefaultFindDialogResource.getString(string);
    }

    public static Font getGridFontFromPreferences() {
        Font font = null;
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance();
        if (preferenceAccessor != null) {
            String string = preferenceAccessor.getFontName("DefaultGridFont");
            String string2 = preferenceAccessor.getFontSize("DefaultGridFont");
            Integer n = new Integer(string2);
            int n2 = 0;
            boolean bl = preferenceAccessor.getFontBold("DefaultGridFont");
            boolean bl2 = preferenceAccessor.getFontItalic("DefaultGridFont");
            if (bl) {
                n2 |= 1;
            }
            if (bl2) {
                n2 |= 2;
            }
            font = new Font(string, n2, n);
        }
        return font;
    }

    public static void startWaitCursor(Component component) {
        if (!m_bWaiting && component != null) {
            component.setCursor(Cursor.getPredefinedCursor(3));
            m_bWaiting = true;
        }
    }

    public static void endWaitCursor(Component component) {
        if (m_bWaiting && component != null) {
            m_bWaiting = false;
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

