/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.samples.bankapp;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.uml.project.UMLProjectGenerator;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.samples.bankapp.UMLBankAppSampleWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UMLBankAppSampleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;
    private FileObject umlProjectZipFO;
    private FileObject readmeFO;
    private static final String FILE_CONTENTS_JAVA_PROJECT_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.getProperty("line.separator") + "<project xmlns=\"http://www.netbeans.org/ns/project/1\">" + System.getProperty("line.separator") + "    <type>org.netbeans.modules.java.j2seproject</type>" + System.getProperty("line.separator") + "    <configuration>" + System.getProperty("line.separator") + "        <data xmlns=\"http://www.netbeans.org/ns/j2se-project/2\">" + System.getProperty("line.separator") + "            <name>{0}</name>" + System.getProperty("line.separator") + "            <minimum-ant-version>1.6</minimum-ant-version>" + System.getProperty("line.separator") + "            <source-roots>" + System.getProperty("line.separator") + "                <root id=\"src.dir\"/>" + System.getProperty("line.separator") + "            </source-roots>" + System.getProperty("line.separator") + "            <test-roots>" + System.getProperty("line.separator") + "                <root id=\"test.src.dir\"/>" + System.getProperty("line.separator") + "            </test-roots>" + System.getProperty("line.separator") + "        </data>" + System.getProperty("line.separator") + "    </configuration>" + System.getProperty("line.separator") + "</project>" + System.getProperty("line.separator");

    public static UMLBankAppSampleWizardIterator createIterator() {
        return new UMLBankAppSampleWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new UMLBankAppSampleWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(UMLBankAppSampleWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        File file;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file2 = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject fileObject2 = FileUtil.createFolder((File)file2);
        this.unZipFile(fileObject.getInputStream(), fileObject2, false);
        this.renameJavaProjectTokens(file2, this.wiz.getProperty("name").toString());
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add(file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        if (this.readmeFO != null) {
            linkedHashSet.add(this.readmeFO);
        }
        File file3 = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("umlprojdir")));
        Project project = ProjectManager.getDefault().findProject(fileObject2);
        UMLProjectGenerator.createRevEngProject((File)file3, (String)this.wiz.getProperty("umlname").toString(), (Project)project, (JavaSourceRootsUI.JavaSourceRootsModel)JavaSourceRootsUI.createModel((Project)project), null, (int)2);
        linkedHashSet.add(FileUtil.toFileObject((File)file3));
        return linkedHashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unZipFile(InputStream inputStream, FileObject fileObject, boolean bl) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        if (!bl) {
                            if (fileObject2.getNameExt().equals("umlProject.zip")) {
                                this.umlProjectZipFO = fileObject2;
                            } else if (fileObject2.getName().equals("README")) {
                                this.readmeFO = fileObject2;
                            }
                        }
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameJavaProjectTokens(File file, String string) {
        File[] fileArray = file.listFiles();
        Object[] objectArray = new String[]{string};
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || !fileArray[i].getName().equals("nbproject")) continue;
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new FileWriter(fileArray[i].getAbsolutePath() + File.separatorChar + "project.xml");
                outputStreamWriter.flush();
                outputStreamWriter.write(MessageFormat.format(FILE_CONTENTS_JAVA_PROJECT_XML, objectArray));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

