/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.source.ui.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public static void setupContext(JEditorPane jEditorPane) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)"text/x-java");
        jEditorPane.setEditorKit(editorKit);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        CallStackFrame callStackFrame = jPDADebugger.getCurrentCallStackFrame();
        if (callStackFrame != null) {
            String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
            String string2 = sourcePath.getURL(callStackFrame, string);
            int n = callStackFrame.getLineNumber(string);
            WatchPanel.setupContext(jEditorPane, string2, n);
        } else {
            WatchPanel.setupUI(jEditorPane);
        }
    }

    public static void setupContext(JEditorPane jEditorPane, String string, int n) {
        StyledDocument styledDocument;
        EditorCookie editorCookie;
        FileObject fileObject;
        WatchPanel.setupUI(jEditorPane);
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject == null) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            editorCookie = DialogBinding.bindComponentToFile((FileObject)fileObject, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
    }

    private static void setupUI(final JEditorPane jEditorPane) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
                editorUI.removeLayer("highlight-row-layer");
                try {
                    Field field = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    field.setAccessible(true);
                    field.set(editorUI, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        WatchPanel.setupContext(this.editorPane);
        JScrollPane jScrollPane = WatchPanel.createScrollableLineEditor(this.editorPane);
        FontMetrics fontMetrics = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n = 2 * fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        this.editorPane.setPreferredSize(new Dimension(30 * n, 1 * n));
        jScrollPane.setPreferredSize(new Dimension(30 * n, 1 * n + 2));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", jScrollPane);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField();
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }
}

