/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class Evaluator
extends JPanel {
    private static final int MAX_ITEMS_TO_KEEP = 20;
    private JPDADebugger debugger;
    private EvaluatorModelListener viewModelListener;
    private Variable result;
    private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Evaluator", 1).create((Runnable)new EvaluateTask());
    private boolean ignoreEvents = false;
    private SessionListener sessionListener;
    private PropertyChangeListener csfListener;
    private JComboBox expressionComboBox;
    private JLabel expressionLabel;
    private JLabel resultLabel;
    private JPanel resultPanel;
    private static Dialog evalDialog;
    private static volatile Evaluator currentEvaluator;

    public Evaluator(JPDADebugger jPDADebugger) {
        this.setDebugger(jPDADebugger);
        this.initComponents();
        this.initCombo();
        this.initResult();
        Mnemonics.setLocalizedText((JLabel)this.expressionLabel, (String)NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Expression"));
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Result"));
        this.sessionListener = new SessionListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.sessionListener);
    }

    private void setDebugger(JPDADebugger jPDADebugger) {
        this.debugger = jPDADebugger;
        this.csfListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("currentCallStackFrame".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Evaluator.this.initCombo();
                        }
                    });
                }
            }
        };
        jPDADebugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.csfListener, (Object)jPDADebugger));
    }

    private void initComponents() {
        this.expressionLabel = new JLabel();
        this.expressionComboBox = new JComboBox();
        this.resultLabel = new JLabel();
        this.resultPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.expressionLabel.setLabelFor(this.expressionComboBox);
        this.expressionLabel.setText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Expression"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 12);
        this.add((Component)this.expressionLabel, gridBagConstraints);
        this.expressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.ExpressionA11YDescr"));
        this.expressionComboBox.setToolTipText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.ExpressionA11YDescr"));
        this.expressionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Evaluator.this.expressionComboBoxItemStateChanged(itemEvent);
            }
        });
        this.expressionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Evaluator.this.expressionComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 12, 12);
        this.add((Component)this.expressionComboBox, gridBagConstraints);
        this.resultLabel.setText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Result"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 11, 12);
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.resultLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.ResultA11YDescr"));
        this.resultPanel.setBorder(BorderFactory.createEtchedBorder());
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 12, 12);
        this.add((Component)this.resultPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.A11YName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.A11YDescr"));
    }

    private void expressionComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreEvents) {
            return;
        }
        this.evaluate();
    }

    private void expressionComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void initCombo() {
        String string = (String)this.expressionComboBox.getEditor().getItem();
        CompletionedEditor completionedEditor = new CompletionedEditor();
        this.expressionComboBox.setEditor(completionedEditor);
        this.expressionComboBox.setEditable(true);
        completionedEditor.setupContext();
        this.expressionComboBox.getEditor().setItem(string);
        this.expressionComboBox.repaint();
    }

    private void initResult() {
        Object object;
        JComponent jComponent = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        Container container = (Container)((Container)((Container)jComponent.getComponents()[0]).getComponents()[0]).getComponents()[0];
        container = (Container)jComponent.getComponents()[0];
        try {
            object = container.getClass().getSuperclass().getDeclaredField("treeTable");
            ((Field)object).setAccessible(true);
            container = (Container)((Field)object).get(container);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        container.setFocusCycleRoot(false);
        container.setFocusTraversalPolicy(null);
        container.setFocusTraversalPolicyProvider(false);
        this.resultPanel.add((Component)jComponent, "Center");
        this.viewModelListener = new EvaluatorModelListener(jComponent);
        object = jComponent.getPreferredSize();
        ((Dimension)object).height = ((Dimension)object).width / 2;
        jComponent.setPreferredSize((Dimension)object);
        jComponent.setName(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.ResultA11YName"));
        jComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.ResultA11YDescr"));
        this.resultLabel.setLabelFor(jComponent);
        JTextField jTextField = new JTextField();
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jComponent.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jComponent.setFocusTraversalKeys(1, set);
    }

    private void destroy() {
        this.viewModelListener.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpression() {
        String string = (String)this.expressionComboBox.getEditor().getItem();
        String string2 = (String)this.expressionComboBox.getSelectedItem();
        if (string != null && !string.equals(string2)) {
            try {
                this.ignoreEvents = true;
                this.expressionComboBox.setSelectedItem(string);
                string2 = string;
            }
            finally {
                this.ignoreEvents = false;
            }
        }
        return string2;
    }

    private void evaluate() {
        this.evalTask.schedule(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExpressionToHistory(String string) {
        try {
            int n;
            this.ignoreEvents = true;
            int n2 = this.expressionComboBox.getItemCount();
            for (n = 0; n < n2; ++n) {
                String string2 = (String)this.expressionComboBox.getItemAt(n);
                if (!string2.equals(string)) continue;
                this.expressionComboBox.removeItemAt(n);
                break;
            }
            if (n >= 20) {
                this.expressionComboBox.removeItemAt(n - 1);
            }
            if (n2 > 0) {
                this.expressionComboBox.insertItemAt(string, 0);
            } else {
                this.expressionComboBox.addItem(string);
            }
            this.expressionComboBox.setSelectedItem(string);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private void displayResult(Variable variable) {
        this.result = variable;
        this.viewModelListener.updateModel();
    }

    public static void open(JPDADebugger jPDADebugger) {
        if (evalDialog != null) {
            evalDialog.setVisible(true);
            evalDialog.requestFocus();
            Evaluator.requestFocusForExpression();
            return;
        }
        final Evaluator evaluator = new Evaluator(jPDADebugger);
        String string = NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Evaluate");
        String string2 = NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Watch");
        String string3 = NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Close");
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)string);
        jButton.setToolTipText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Evaluate.TLT"));
        final JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)string2);
        jButton2.setToolTipText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Watch.TLT"));
        final JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)string3);
        jButton3.setToolTipText(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Close.TLT"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)evaluator, NbBundle.getMessage(Evaluator.class, (String)"Evaluator.Title"), false, new Object[]{jButton, jButton2, jButton3}, (Object)string, 0, new HelpCtx(Evaluator.class.getName()), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (jButton.equals(object)) {
                    evaluator.evaluate();
                } else if (jButton2.equals(object)) {
                    DebuggerManager.getDebuggerManager().createWatch(evaluator.getExpression());
                } else if (jButton3.equals(object)) {
                    Evaluator.close();
                }
            }
        });
        evalDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        evalDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.A11YDescr"));
        evalDialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Evaluator.class, (String)"Evaluator.A11YName"));
        currentEvaluator = evaluator;
        evalDialog.setVisible(true);
        Evaluator.requestFocusForExpression();
        currentEvaluator.setNextFocusableComponent(jButton);
    }

    private static void traverseComponents(Component component, Container container, FocusTraversalPolicy focusTraversalPolicy) {
        if (component instanceof Container) {
            Component[] componentArray;
            Container container2 = (Container)component;
            System.err.println("\nComponent " + component);
            System.err.println("isFocusable: " + container2.isFocusable() + ", isFocusCycleRoot: " + container2.isFocusCycleRoot() + ", is PolicySet: " + container2.isFocusTraversalPolicySet() + ", is PolicyProvider: " + container2.isFocusTraversalPolicyProvider());
            if (container2.isFocusCycleRoot()) {
                System.err.println("DEFAULT component: " + focusTraversalPolicy.getDefaultComponent(container) + ", first component: " + focusTraversalPolicy.getFirstComponent(container));
                if (container2 != container) {
                    container2.setFocusCycleRoot(false);
                    container2.setFocusTraversalPolicyProvider(false);
                    container2.setFocusTraversalPolicy(null);
                }
            }
            if (container2 instanceof JComponent) {
                System.err.println("NEXT Focusable: " + ((JComponent)container2).getNextFocusableComponent());
                System.err.println("NEXT After:     " + focusTraversalPolicy.getComponentAfter(container, component));
            }
            for (Component component2 : componentArray = container2.getComponents()) {
                Evaluator.traverseComponents(component2, container, focusTraversalPolicy);
            }
        }
    }

    private static void requestFocusForExpression() {
        Component component = Evaluator.currentEvaluator.expressionComboBox.getEditor().getEditorComponent();
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        component.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        evalDialog.setVisible(false);
        try {
            Evaluator.currentEvaluator.ignoreEvents = true;
            Evaluator.currentEvaluator.expressionComboBox.setSelectedItem("");
        }
        finally {
            Evaluator.currentEvaluator.ignoreEvents = false;
        }
        Evaluator.currentEvaluator.result = null;
        Evaluator.currentEvaluator.viewModelListener.updateModel();
    }

    private static class EvaluatorModel
    implements TreeModel,
    ExtendedNodeModel {
        private Models.CompoundModel treeModel;
        private Models.CompoundModel nodeModel;

        public EvaluatorModel(Models.CompoundModel compoundModel, Models.CompoundModel compoundModel2) {
            this.treeModel = compoundModel;
            this.nodeModel = compoundModel2;
        }

        public void addModelListener(ModelListener modelListener) {
            this.treeModel.addModelListener(modelListener);
        }

        public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
            if ("Root".equals(object)) {
                Evaluator evaluator = currentEvaluator;
                if (evaluator == null || evaluator.result == null) {
                    return new Object[0];
                }
                return new Object[]{evaluator.result};
            }
            return this.treeModel.getChildren(object, n, n2);
        }

        public int getChildrenCount(Object object) throws UnknownTypeException {
            if ("Root".equals(object)) {
                return currentEvaluator == null ? 0 : 1;
            }
            return this.treeModel.getChildrenCount(object);
        }

        public Object getRoot() {
            return "Root";
        }

        public boolean isLeaf(Object object) throws UnknownTypeException {
            if ("Root".equals(object)) {
                return false;
            }
            return this.treeModel.isLeaf(object);
        }

        public void removeModelListener(ModelListener modelListener) {
            this.treeModel.removeModelListener(modelListener);
        }

        public String getDisplayName(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return evaluator.getExpression();
            }
            return this.nodeModel.getDisplayName(object);
        }

        public String getIconBase(Object object) throws UnknownTypeException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getShortDescription(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return evaluator.getExpression();
            }
            return this.nodeModel.getShortDescription(object);
        }

        public boolean canRename(Object object) throws UnknownTypeException {
            return this.nodeModel.canRename(object);
        }

        public boolean canCopy(Object object) throws UnknownTypeException {
            return this.nodeModel.canCopy(object);
        }

        public boolean canCut(Object object) throws UnknownTypeException {
            return this.nodeModel.canCut(object);
        }

        public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
            return this.nodeModel.clipboardCopy(object);
        }

        public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
            return this.nodeModel.clipboardCut(object);
        }

        public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
            return this.nodeModel.getPasteTypes(object, transferable);
        }

        public void setName(Object object, String string) throws UnknownTypeException {
            this.nodeModel.setName(object, string);
        }

        public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
            }
            return this.nodeModel.getIconBaseWithExtension(object);
        }
    }

    private static class EvaluatorModelListener
    extends DebuggerManagerAdapter {
        private String viewType = "LocalsView";
        private JComponent view;
        private List models = new ArrayList(11);

        public EvaluatorModelListener(JComponent jComponent) {
            this.view = jComponent;
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.updateModel();
        }

        public void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null) {
                evaluator.csfListener = null;
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (debuggerEngine == null) {
                    return;
                }
                JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
                evaluator.setDebugger(jPDADebugger);
            }
            this.updateModel();
        }

        public synchronized void updateModel() {
            int n;
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            DebuggerEngine debuggerEngine = debuggerManager.getCurrentEngine();
            DebuggerManager debuggerManager2 = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager) : debuggerManager;
            List list = debuggerManager2.lookup(this.viewType, TreeModel.class);
            List list2 = debuggerManager2.lookup(this.viewType, TreeModelFilter.class);
            List list3 = debuggerManager2.lookup(this.viewType, TreeExpansionModel.class);
            List list4 = debuggerManager2.lookup(this.viewType, NodeModel.class);
            List list5 = debuggerManager2.lookup(this.viewType, NodeModelFilter.class);
            List list6 = debuggerManager2.lookup(this.viewType, TableModel.class);
            List list7 = debuggerManager2.lookup(this.viewType, TableModelFilter.class);
            List list8 = debuggerManager2.lookup(this.viewType, NodeActionsProvider.class);
            List list9 = debuggerManager2.lookup(this.viewType, NodeActionsProviderFilter.class);
            List list10 = debuggerManager2.lookup(this.viewType, ColumnModel.class);
            List list11 = debuggerManager2.lookup(this.viewType, Model.class);
            ArrayList<List> arrayList = new ArrayList<List>(11);
            arrayList.add(list);
            for (n = 0; n < 2; ++n) {
                arrayList.add(Collections.EMPTY_LIST);
            }
            arrayList.add(list4);
            for (n = 0; n < 7; ++n) {
                arrayList.add(Collections.EMPTY_LIST);
            }
            Models.CompoundModel compoundModel = Models.createCompoundModel(arrayList);
            EvaluatorModel evaluatorModel = new EvaluatorModel(compoundModel, compoundModel);
            this.models.clear();
            list.clear();
            list.add(evaluatorModel);
            this.models.add(list);
            this.models.add(list2);
            this.models.add(list3);
            list4.clear();
            list4.add(evaluatorModel);
            this.models.add(list4);
            this.models.add(list5);
            this.models.add(list6);
            this.models.add(list7);
            this.models.add(list8);
            this.models.add(list9);
            this.models.add(list10);
            this.models.add(list11);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel((List)this.models));
        }
    }

    private static final class CompletionedEditor
    implements ComboBoxEditor {
        private JEditorPane editor = new JEditorPane();
        private Component component;
        private Object oldValue;
        private boolean isContextSetUp;

        public CompletionedEditor() {
            this.editor.setBorder(null);
            this.editor.setKeymap(new FilteredKeymap(this.editor));
            this.editor.setFocusCycleRoot(false);
            this.editor.setFocusTraversalPolicy(null);
            this.editor.setFocusTraversalPolicyProvider(false);
            this.component = new JScrollPane(this.editor, 21, 31);
            this.editor.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    CompletionedEditor.this.setupContext();
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
            JTextField jTextField = new JTextField();
            Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
            this.editor.setFocusTraversalKeys(0, set);
            set = jTextField.getFocusTraversalKeys(1);
            this.editor.setFocusTraversalKeys(1, set);
        }

        public void setupContext() {
            if (!this.isContextSetUp) {
                WatchPanel.setupContext(this.editor);
                this.isContextSetUp = true;
            }
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public Component getEditorComponent() {
            return this.component;
        }

        public Object getItem() {
            Object object = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    object = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void setItem(Object object) {
            if (object != null) {
                this.editor.setText(object.toString());
                this.oldValue = object;
            } else {
                this.editor.setText("");
            }
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        public void run() {
            String string = Evaluator.this.getExpression();
            if (string == null || "".equals(string)) {
                return;
            }
            try {
                Variable variable = Evaluator.this.debugger.evaluate(string);
                Evaluator.this.addExpressionToHistory(string);
                Evaluator.this.displayResult(variable);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage()));
            }
        }
    }

    private class SessionListener
    extends DebuggerManagerAdapter {
        private boolean autoClosed = false;

        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (session != null && "Java".equals(session.getCurrentLanguage())) {
                if (this.autoClosed) {
                    DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                    if (debuggerEngine == null) {
                        return;
                    }
                    JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
                    if (jPDADebugger == null) {
                        return;
                    }
                    Evaluator.open(jPDADebugger);
                    this.autoClosed = false;
                }
            } else if (evalDialog.isVisible()) {
                this.autoClosed = true;
                Evaluator.close();
            }
        }
    }
}

