/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.validation;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.netbeans.modules.xml.validation.ValidationOutputWindowController;
import org.netbeans.modules.xml.validation.ui.ValidationOutputWindow;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ValidateAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final String ACCELERATOR = "alt shift F9";
    private static final Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/validation/resources/validation.png"));
    private static final String label = NbBundle.getMessage(ValidateAction.class, (String)"NAME_Validate_XML");
    private Model model;

    public ValidateAction(Model model) {
        super(label, icon);
        this.putValue("Name", label);
        this.putValue("ShortDescription", label);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(ACCELERATOR));
        this.model = model;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post((Runnable)new RunAction());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RunAction
    implements Runnable {
        private List<Validator.ResultItem> validationResults;

        @Override
        public void run() {
            InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ValidationOutputWindow.class, (String)"TITLE_XML_check_window"), false);
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            inputOutput.getOut().println(NbBundle.getMessage(ValidateAction.class, (String)"MSG_XML_valid_start"));
            inputOutput.select();
            ValidationOutputWindowController validationOutputWindowController = new ValidationOutputWindowController();
            this.validationResults = validationOutputWindowController.validate(ValidateAction.this.model);
            inputOutput.getOut().print(NbBundle.getMessage(ValidateAction.class, (String)"MSG_XML_valid_end"));
            inputOutput.select();
        }

        public List<Validator.ResultItem> getValidationResults() {
            return this.validationResults;
        }
    }
}

