/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.RelatedEntityResource;
import org.netbeans.modules.websvc.rest.codegen.model.RuntimeEntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.RuntimeJpaEntity;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResourceModelBuilder {
    private Map<String, EntityClassInfo> entityClassInfoMap = new HashMap<String, EntityClassInfo>();
    EntityResourceBeanModel model;

    public EntityResourceModelBuilder(Project project, Collection<Entity> collection) {
        for (Entity entity : collection) {
            try {
                EntityClassInfo entityClassInfo = null;
                JavaSource javaSource = SourceGroupSupport.getJavaSourceFromClassName(entity.getClass2(), project);
                if (javaSource != null) {
                    entityClassInfo = new EntityClassInfo(entity, project, this, javaSource);
                } else if (entity instanceof RuntimeJpaEntity) {
                    entityClassInfo = new RuntimeEntityClassInfo((RuntimeJpaEntity)entity, project, this);
                }
                if (entityClassInfo == null) continue;
                this.entityClassInfoMap.put(entity.getClass2(), entityClassInfo);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (EntityClassInfo entityClassInfo : this.entityClassInfoMap.values()) {
            arrayList.add(entityClassInfo.getEntity());
        }
        return arrayList;
    }

    public Set<EntityClassInfo> getEntityInfos() {
        return new HashSet<EntityClassInfo>(this.entityClassInfoMap.values());
    }

    public Set<String> getAllEntityNames() {
        return this.entityClassInfoMap.keySet();
    }

    public EntityClassInfo getEntityClassInfo(String string) {
        return this.entityClassInfoMap.get(string);
    }

    public EntityResourceBeanModel build(Collection<Entity> collection) {
        this.model = new EntityResourceBeanModel(this);
        try {
            for (Entity entity : collection) {
                EntityClassInfo entityClassInfo = this.entityClassInfoMap.get(entity.getClass2());
                this.getContainerResourceBean(entityClassInfo);
            }
            this.model.setValid(true);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            this.model.setValid(false);
        }
        return this.model;
    }

    private EntityResourceBean getContainerResourceBean(EntityClassInfo entityClassInfo) {
        EntityResourceBean entityResourceBean = this.model.getContainerResourceBean(entityClassInfo);
        if (entityResourceBean == null) {
            entityResourceBean = this.createContainerResourceBean(entityClassInfo);
        }
        return entityResourceBean;
    }

    private EntityResourceBean createContainerResourceBean(EntityClassInfo entityClassInfo) {
        EntityResourceBean entityResourceBean = new EntityResourceBean(EntityResourceBean.Type.CONTAINER);
        String string = Util.pluralize(entityClassInfo.getName());
        entityResourceBean.setName(string);
        entityResourceBean.setEntityClassInfo(entityClassInfo);
        entityResourceBean.setUriTemplate("/" + Util.lowerFirstChar(string) + "/");
        this.model.addContainerResourceBean(entityResourceBean);
        EntityResourceBean entityResourceBean2 = this.getItemResourceBean(entityClassInfo);
        entityResourceBean.addSubResource(new RelatedEntityResource(entityResourceBean2, entityClassInfo.getIdFieldInfo()));
        return entityResourceBean;
    }

    private EntityResourceBean getItemResourceBean(EntityClassInfo entityClassInfo) {
        EntityResourceBean entityResourceBean = this.model.getItemResourceBean(entityClassInfo);
        if (entityResourceBean == null) {
            entityResourceBean = this.createItemResourceBean(entityClassInfo);
        }
        return entityResourceBean;
    }

    private EntityResourceBean createItemResourceBean(EntityClassInfo entityClassInfo) {
        EntityResourceBean entityResourceBean = new EntityResourceBean(EntityResourceBean.Type.ITEM);
        entityResourceBean.setName(Util.singularize(entityClassInfo.getName()));
        entityResourceBean.setEntityClassInfo(entityClassInfo);
        EntityClassInfo.FieldInfo fieldInfo = entityClassInfo.getIdFieldInfo();
        String string = "";
        if (!fieldInfo.isEmbeddedId()) {
            string = "{" + entityClassInfo.getIdFieldInfo().getName() + "}/";
        } else {
            int n = 0;
            for (EntityClassInfo.FieldInfo fieldInfo2 : fieldInfo.getFieldInfos()) {
                if (n++ > 0) {
                    string = string + ",";
                }
                string = string + "{" + fieldInfo2.getName() + "}";
            }
            string = string + "/";
        }
        entityResourceBean.setUriTemplate(string);
        this.model.addItemResourceBean(entityResourceBean);
        this.computeRelationship(entityResourceBean, entityClassInfo);
        return entityResourceBean;
    }

    private void computeRelationship(EntityResourceBean entityResourceBean, EntityClassInfo entityClassInfo) {
        for (EntityClassInfo.FieldInfo fieldInfo : entityClassInfo.getFieldInfos()) {
            if (!fieldInfo.isRelationship()) continue;
            EntityResourceBean entityResourceBean2 = null;
            EntityResourceBean entityResourceBean3 = null;
            if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
                entityResourceBean2 = this.getContainerResourceBean(this.entityClassInfoMap.get(fieldInfo.getTypeArg()));
                entityResourceBean3 = this.getItemResourceBean(this.entityClassInfoMap.get(fieldInfo.getTypeArg()));
            } else {
                entityResourceBean2 = this.getItemResourceBean(this.entityClassInfoMap.get(fieldInfo.getType()));
            }
            RelatedEntityResource relatedEntityResource = new RelatedEntityResource(entityResourceBean2, fieldInfo);
            entityResourceBean.addSubResource(relatedEntityResource);
            RelatedEntityResource relatedEntityResource2 = new RelatedEntityResource(entityResourceBean, fieldInfo);
            entityResourceBean2.addSuperResource(relatedEntityResource2);
            if (entityResourceBean3 == null) continue;
            entityResourceBean3.addSuperResource(relatedEntityResource2);
        }
    }
}

