/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.TypeUtil;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStubModel {
    private Project p;
    private SortedMap<String, JavaSource> srcMap = new TreeMap<String, JavaSource>();
    private List<Resource> resourceList = Collections.emptyList();
    private Map<String, RepresentationDocument> documentMap = new HashMap<String, RepresentationDocument>();
    private FileObject wadlFile;

    public List<Resource> getResources() {
        return this.resourceList;
    }

    public void addResource(Resource resource) {
        this.resourceList.add(resource);
    }

    public JavaSource getJavaSource(String string) {
        return (JavaSource)this.srcMap.get(string);
    }

    public void buildModel(Project project) throws IOException {
        Object object;
        this.p = project;
        this.resourceList = new ArrayList<Resource>();
        List<JavaSource> list = JavaSourceHelper.getJavaSources(project);
        ArrayList<JavaSource> arrayList = new ArrayList<JavaSource>();
        ArrayList<JavaSource> arrayList2 = new ArrayList<JavaSource>();
        ArrayList<JavaSource> arrayList3 = new ArrayList<JavaSource>();
        for (JavaSource javaSource : list) {
            if (JavaSourceHelper.isEntity(javaSource) || (object = JavaSourceHelper.getClassNameQuietly(javaSource)) == null) continue;
            this.srcMap.put((String)object, javaSource);
            if (RestUtils.isStaticResource(javaSource)) {
                arrayList.add(javaSource);
                continue;
            }
            if (RestUtils.isConverter(javaSource)) {
                arrayList3.add(javaSource);
                continue;
            }
            if (!RestUtils.isDynamicResource(javaSource)) continue;
            arrayList2.add(javaSource);
        }
        for (JavaSource javaSource : arrayList) {
            object = this.createResource(javaSource);
            this.addResource((Resource)object);
        }
        for (JavaSource javaSource : arrayList2) {
            object = this.createResource(javaSource);
            this.addResource((Resource)object);
        }
    }

    public String buildModel(FileObject fileObject) throws IOException {
        String string = null;
        this.wadlFile = fileObject;
        this.resourceList = new ArrayList<Resource>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileObject.getInputStream());
            string = RestUtils.getAttributeValue(document, "//application/resources", "base");
            NodeList nodeList = RestUtils.getNodeList(document, "//application/resources/resource");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    String string2 = null;
                    Attr attr = (Attr)namedNodeMap.getNamedItem("path");
                    if (attr != null) {
                        string2 = attr.getNodeValue();
                    }
                    String string3 = string2.replaceAll("/", "");
                    string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                    Resource resource = new Resource(string3, string2);
                    NodeList nodeList2 = RestUtils.getNodeList(node, "method");
                    if (nodeList2 != null && nodeList2.getLength() > 0) {
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Node node2 = nodeList2.item(j);
                            String string4 = this.getMethodName(node2);
                            if (string4 == null) {
                                string4 = this.getMethodRef(node2);
                                if (string4 == null) {
                                    throw new IOException("Method do not have name or href attribute for resource: " + string3);
                                }
                                String string5 = string4;
                                if (string5.startsWith("#")) {
                                    string5 = string5.substring(1);
                                }
                                node2 = this.findMethodNodeByRef(document, string5);
                                string4 = this.getMethodName(node2);
                                this.addMethod(resource, string4, node2);
                                continue;
                            }
                            this.addMethod(resource, string4, node2);
                        }
                    }
                    this.addResource(resource);
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getMethodName(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem("name");
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private String getMethodRef(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem("href");
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private Node findMethodNodeByRef(Node node, String string) throws XPathExpressionException {
        Node node2 = null;
        NodeList nodeList = RestUtils.getNodeList(node, "//application/method");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                node2 = nodeList.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Attr attr = (Attr)namedNodeMap.getNamedItem("id");
                if (attr == null || !(string2 = attr.getNodeValue()).equals(string)) continue;
                return node2;
            }
        }
        return node2;
    }

    private void addMethod(Resource resource, String string, Node node) throws XPathExpressionException {
        if (string != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Method method = new Method(string.toLowerCase());
            method.setType(MethodType.valueOf(string));
            NodeList nodeList = RestUtils.getNodeList(node, "request");
            if (nodeList != null && nodeList.getLength() > 0) {
                object6 = nodeList.item(0);
                object5 = new Request();
                object4 = RestUtils.getNodeList((Node)object6, "representation");
                if (object4 != null && object4.getLength() > 0) {
                    for (int i = 0; i < object4.getLength(); ++i) {
                        Node node2 = object4.item(i);
                        object3 = "application/xml";
                        object2 = (Attr)node2.getAttributes().getNamedItem("mediaType");
                        if (object2 != null) {
                            object3 = object2.getNodeValue();
                        }
                        object = new Representation((String)object3);
                        ((Request)object5).addRepresentation((Representation)object);
                    }
                }
                method.setRequest((Request)object5);
            }
            if ((object6 = RestUtils.getNodeList(node, "response")) != null && object6.getLength() > 0) {
                object5 = object6.item(0);
                object4 = new Response();
                NodeList nodeList2 = RestUtils.getNodeList((Node)object5, "representation");
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    for (int i = 0; i < nodeList2.getLength(); ++i) {
                        object3 = nodeList2.item(i);
                        object2 = "application/xml";
                        object = (Attr)object3.getAttributes().getNamedItem("mediaType");
                        if (object != null) {
                            object2 = object.getNodeValue();
                        }
                        Representation representation = new Representation((String)object2);
                        ((Response)object4).addRepresentation(representation);
                    }
                }
                method.setResponse((Response)object4);
            }
            resource.addMethod(method);
        }
    }

    public static String toValidJavaName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuilder.append(string.charAt(0));
        } else {
            stringBuilder.append("_");
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    public static String normailizeName(String string) {
        return ClientStubModel.toValidJavaName(string);
    }

    private Resource createResource(JavaSource javaSource) throws IOException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = RestUtils.findUri(javaSource);
        if (string3 != null) {
            string2 = string3;
            string = string2;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
        } else {
            object = JavaSourceHelper.getClassNameQuietly(javaSource);
            string = RestUtils.findStubNameFromClass((String)object);
            string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        object = new Resource(string, string2);
        this.buildResource((Resource)object, javaSource);
        return object;
    }

    private void buildResource(Resource resource, JavaSource javaSource) throws IOException {
        resource.setSource(javaSource);
        List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
        for (MethodTree methodTree : list) {
            String string = methodTree.getName().toString();
            Method method = null;
            List<? extends AnnotationTree> list2 = methodTree.getModifiers().getAnnotations();
            if (list2 != null && list2.size() > 0) {
                for (AnnotationTree annotationTree : list2) {
                    Representation representation;
                    String[] stringArray;
                    String string2;
                    String string3 = annotationTree.getAnnotationType().toString();
                    List<? extends ExpressionTree> list3 = annotationTree.getArguments();
                    if ("Path".equals(string3) || "javax.ws.rs.Path".equals(string3)) {
                        int n;
                        method = this.createNavigationMethod(string);
                        method.setTree(methodTree);
                        method.setType(MethodType.GETCHILD);
                        for (ExpressionTree expressionTree : list3) {
                            string2 = expressionTree.toString();
                            if (string2.contains("{")) {
                                stringArray = methodTree.getReturnType().toString();
                                if (stringArray.indexOf(".") != -1) {
                                    stringArray = stringArray.substring(stringArray.lastIndexOf(".") + 1);
                                }
                                if (stringArray.indexOf("Resource") != -1) {
                                    stringArray = stringArray.substring(0, stringArray.indexOf("Resource"));
                                }
                                String[] stringArray2 = resource.getName();
                                if (((String)stringArray + "s").equals(stringArray2)) {
                                    resource.setIsContainer(true);
                                }
                                string2 = string2.substring(string2.indexOf("{") + 1, string2.lastIndexOf("}"));
                            } else if (string2.contains("\"") && string2.contains("/")) {
                                string2 = string2.substring(string2.indexOf("\"") + 1, string2.lastIndexOf("/"));
                            } else {
                                throw new IOException("Cannot find method with @Path(\"subresource/\") or @Path(\"{containerId}/\")");
                            }
                            ((NavigationMethod)method).setNavigationUri(string2);
                        }
                        Object object3 = methodTree.getReturnType().toString();
                        if (object3 != null && (n = ((String)object3).lastIndexOf(".")) != -1) {
                            object3 = ((String)object3).substring(n + 1);
                        }
                        String string4 = RestUtils.findStubNameFromClass((String)object3);
                        ((NavigationMethod)method).setLinkName(string4);
                        continue;
                    }
                    if ("GET".equals(string3) || "javax.ws.rs.GET".equals(string3)) {
                        if (method != null) continue;
                        method = this.createMethod(string, methodTree);
                        method.setType(MethodType.GET);
                        continue;
                    }
                    if ("POST".equals(string3) || "javax.ws.rs.POST".equals(string3)) {
                        if (method != null) continue;
                        method = this.createMethod(string, methodTree);
                        method.setType(MethodType.POST);
                        continue;
                    }
                    if ("PUT".equals(string3) || "javax.ws.rs.PUT".equals(string3)) {
                        if (method != null) continue;
                        method = this.createMethod(string, methodTree);
                        method.setType(MethodType.PUT);
                        continue;
                    }
                    if ("DELETE".equals(string3) || "javax.ws.rs.DELETE".equals(string3)) {
                        if (method != null) continue;
                        method = this.createMethod(string, methodTree);
                        method.setType(MethodType.DELETE);
                        continue;
                    }
                    if ("ProduceMime".equals(string3) || "javax.ws.rs.ProduceMime".equals(string3)) {
                        if (method == null) {
                            method = this.createMethod(string, methodTree);
                        }
                        for (ExpressionTree expressionTree : list3) {
                            string2 = RestUtils.getValueFromAnnotation(expressionTree);
                            for (String string5 : stringArray = string2.split(",")) {
                                representation = new Representation(string5);
                                method.getResponse().addRepresentation(representation);
                            }
                        }
                        continue;
                    }
                    if (!"ConsumeMime".equals(string3) && !"javax.ws.rs.ConsumeMime".equals(string3)) continue;
                    if (method == null) {
                        method = this.createMethod(string, methodTree);
                    }
                    for (ExpressionTree expressionTree : list3) {
                        string2 = RestUtils.getValueFromAnnotation(expressionTree);
                        for (String string5 : stringArray = string2.split(",")) {
                            representation = new Representation(string5);
                            method.getRequest().addRepresentation(representation);
                        }
                    }
                }
            }
            if (method == null) continue;
            resource.addMethod(method);
        }
        this.buildRepresentationDocument(resource, javaSource);
    }

    private Method createMethod(String string, MethodTree methodTree) {
        Method method = new Method(string);
        Representation representation = new Representation("application/xml");
        Request request = new Request();
        request.addRepresentation(representation);
        method.setRequest(request);
        Representation representation2 = new Representation("application/xml");
        Response response = new Response();
        response.addRepresentation(representation2);
        method.setResponse(response);
        method.setTree(methodTree);
        return method;
    }

    private Method createNavigationMethod(String string) {
        NavigationMethod navigationMethod = new NavigationMethod(string);
        Representation representation = new Representation("application/xml");
        Request request = new Request();
        request.addRepresentation(representation);
        navigationMethod.setRequest(request);
        Representation representation2 = new Representation("application/xml");
        Response response = new Response();
        response.addRepresentation(representation2);
        navigationMethod.setResponse(response);
        return navigationMethod;
    }

    private void buildRepresentationDocument(Resource resource, JavaSource javaSource) throws IOException {
        RepresentationDocument representationDocument = resource.getRepresentation();
        MethodTree methodTree = RestUtils.findGetAsXmlMethod(javaSource);
        if (methodTree != null) {
            String string = methodTree.getReturnType().toString();
            RepresentationNode representationNode = null;
            JavaSource javaSource2 = this.getJavaSource(string);
            if (javaSource2 != null) {
                representationNode = this.createRootNode(javaSource2, representationDocument);
            } else {
                Class clazz = TypeUtil.getClass(string, javaSource, this.p);
                if (clazz != null) {
                    representationNode = this.createRootNode(clazz, representationDocument);
                }
            }
            representationDocument.setRoot(representationNode);
            this.documentMap.put(string, representationDocument);
            this.processConverter(string, representationDocument, representationNode, resource);
        }
    }

    private RepresentationNode createRootNode(JavaSource javaSource, RepresentationDocument representationDocument) {
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            AnnotationMirror annotationMirror = list.get(i);
            String string = annotationMirror.getAnnotationType().toString();
            if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
            String string2 = RestUtils.getValueFromAnnotation(annotationMirror);
            RepresentationNode representationNode = new RepresentationNode(string2);
            representationNode.setIsRoot(true);
            return representationNode;
        }
        return null;
    }

    private RepresentationNode createRootNode(Class clazz, RepresentationDocument representationDocument) {
        List<Annotation> list = TypeUtil.getAnnotations(clazz, true);
        for (Annotation annotation : list) {
            String string = annotation.annotationType().getName();
            if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
            String string2 = TypeUtil.getAnnotationValueName(annotation);
            RepresentationNode representationNode = new RepresentationNode(string2);
            representationNode.setIsRoot(true);
            return representationNode;
        }
        return null;
    }

    private void processConverter(String string, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource) throws IOException {
        JavaSource javaSource;
        assert (string != null);
        String string2 = string;
        if ((string2.indexOf("Collection<") > -1 || string2.indexOf("List<") > -1 || string2.indexOf("Set<") > -1) && string2.indexOf("<") != -1) {
            string2 = string2.substring(string2.indexOf("<") + 1, string2.indexOf(">"));
        }
        if ((javaSource = this.getJavaSource(string2)) == null) {
            Class clazz = TypeUtil.getClass(string2, resource.getSource(), this.p);
            if (clazz != null) {
                this.processConverter(clazz, representationDocument, representationNode, resource);
            }
        } else {
            this.processConverter(javaSource, representationDocument, representationNode, resource);
        }
    }

    private void processConverter(JavaSource javaSource, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource) throws IOException {
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            int n;
            AnnotationMirror annotationMirror = list.get(i);
            String string = annotationMirror.getAnnotationType().toString();
            if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
            representationNode.setSource(javaSource);
            List<MethodTree> list2 = JavaSourceHelper.getAllMethods(javaSource);
            if (list2 == null) continue;
            ArrayList<RepresentationNode> arrayList = new ArrayList<RepresentationNode>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < list2.size(); ++n) {
                MethodTree methodTree = list2.get(n);
                List<? extends AnnotationTree> list3 = methodTree.getModifiers().getAnnotations();
                if (list3 == null) continue;
                for (int j = 0; j < list3.size(); ++j) {
                    Object object;
                    String string2;
                    AnnotationTree annotationTree = list3.get(j);
                    String string3 = annotationTree.getAnnotationType().toString();
                    if ("XmlElement".equals(string3) || "javax.xml.bind.annotation.XmlElement".equals(string3)) {
                        string2 = methodTree.getReturnType().toString();
                        object = this.documentMap.get(string2);
                        RepresentationNode representationNode2 = null;
                        if (object == null || ((RepresentationDocument)object).getRoot() == null) {
                            String string4 = RestUtils.findElementName(methodTree);
                            representationNode2 = new RepresentationNode(string4);
                            representationNode2.setLink(methodTree);
                            arrayList.add(representationNode2);
                            arrayList2.add(string2);
                        } else {
                            representationNode2 = ((RepresentationDocument)object).getRoot();
                        }
                        representationNode.addChild(representationNode2);
                        continue;
                    }
                    if (!"XmlAttribute".equals(string3) && !"javax.xml.bind.annotation.XmlAttribute".equals(string3)) continue;
                    string2 = RestUtils.findElementName(methodTree);
                    object = new RepresentationNode(string2);
                    ((RepresentationNode)object).setLink(methodTree);
                    representationNode.addAttribute((RepresentationNode)object);
                }
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.processConverter((String)arrayList2.get(n), representationDocument, (RepresentationNode)arrayList.get(n), resource);
            }
        }
    }

    private void processConverter(Class clazz, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource) throws IOException {
        Annotation annotation;
        Object object;
        Object object2;
        String string;
        representationNode.setSource(null);
        if (!TypeUtil.isXmlRoot(clazz)) {
            return;
        }
        ArrayList<RepresentationNode> arrayList = new ArrayList<RepresentationNode>();
        for (java.lang.reflect.Method accessibleObject : clazz.getMethods()) {
            string = accessibleObject.getGenericReturnType().toString();
            object2 = accessibleObject.getName();
            if (((String)object2).startsWith("get")) {
                object2 = ((String)object2).substring(3);
            }
            object = this.documentMap.get(string);
            annotation = TypeUtil.getXmlElementAnnotation(accessibleObject);
            if (annotation == null) continue;
            this.collectElement(annotation, representationNode, (RepresentationDocument)object, arrayList, string, (String)object2);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            string = ((Field)accessibleObject).getGenericType().toString();
            object2 = this.documentMap.get(string);
            object = TypeUtil.getXmlElementAnnotation((Field)accessibleObject);
            if (object != null) {
                this.collectElement((Annotation)object, representationNode, (RepresentationDocument)object2, arrayList, string, ((Field)accessibleObject).getName());
            }
            if ((annotation = TypeUtil.getXmlAttributeAnnotation((Field)accessibleObject)) == null) continue;
            this.collectAttribute(annotation, representationNode, ((Field)accessibleObject).getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.processConverter(((RepresentationNode)arrayList.get(i)).getType(), representationDocument, (RepresentationNode)arrayList.get(i), resource);
        }
    }

    private void collectElement(Annotation annotation, RepresentationNode representationNode, RepresentationDocument representationDocument, List<RepresentationNode> list, String string, String string2) {
        RepresentationNode representationNode2 = null;
        if (representationDocument == null || representationDocument.getRoot() == null) {
            String string3 = TypeUtil.getAnnotationValueName(annotation);
            if (string3 == null) {
                string3 = string2;
            }
            representationNode2 = new RepresentationNode(string3);
            representationNode2.setType(string);
            representationNode2.setLink(null);
            list.add(representationNode2);
        } else {
            representationNode2 = representationDocument.getRoot();
        }
        representationNode.addChild(representationNode2);
    }

    private void collectAttribute(Annotation annotation, RepresentationNode representationNode, String string) {
        String string2 = TypeUtil.getAnnotationValueName(annotation);
        if (string2 == null || string2.equals("##default")) {
            string2 = string;
        }
        RepresentationNode representationNode2 = new RepresentationNode(string2);
        representationNode2.setLink(null);
        representationNode.addAttribute(representationNode2);
    }

    public class Representation {
        private String mime;

        public Representation(String string) {
            this.mime = string;
        }

        public String getMime() {
            return this.mime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Response {
        private List<Representation> repList = new ArrayList<Representation>();

        public List<Representation> getRepresentation() {
            return this.repList;
        }

        protected void addRepresentation(Representation representation) {
            this.repList.add(representation);
        }

        protected void setRepresentation(List<Representation> list) {
            this.repList = list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Request {
        private List<Representation> repList = new ArrayList<Representation>();

        public List<Representation> getRepresentation() {
            return this.repList;
        }

        protected void addRepresentation(Representation representation) {
            this.repList.add(representation);
        }

        protected void setRepresentation(List<Representation> list) {
            this.repList = list;
        }
    }

    public class NavigationMethod
    extends Method {
        private String nUri;
        private String linkName;

        public NavigationMethod(String string) {
            super(string);
        }

        public String getNavigationUri() {
            return this.nUri;
        }

        protected void setNavigationUri(String string) {
            this.nUri = string;
        }

        public String getLinkName() {
            return this.linkName;
        }

        protected void setLinkName(String string) {
            this.linkName = string;
        }
    }

    public class Method {
        private String name;
        private MethodType type;
        private Request request;
        private Response response;
        private MethodTree tree;

        public Method(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public MethodType getType() {
            return this.type;
        }

        protected void setType(MethodType methodType) {
            this.type = methodType;
        }

        public Request getRequest() {
            return this.request;
        }

        protected void setRequest(Request request) {
            this.request = request;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        protected MethodTree getTree() {
            return this.tree;
        }

        protected void setTree(MethodTree methodTree) {
            this.tree = methodTree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        GET(Constants.HttpMethodType.GET.value()),
        PUT(Constants.HttpMethodType.PUT.value()),
        POST(Constants.HttpMethodType.POST.value()),
        DELETE(Constants.HttpMethodType.DELETE.value()),
        GETCHILD("getChild");

        private String prefix;
        private static MethodType NAVIGATE;

        private MethodType(String string2) {
            this.prefix = string2;
        }

        public String value() {
            return this.name();
        }

        public String prefix() {
            return this.prefix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RepresentationNode {
        private String name;
        private String type;
        private MethodTree link;
        private JavaSource src;
        private List<RepresentationNode> attrList = new ArrayList<RepresentationNode>();
        private List<RepresentationNode> childList = new ArrayList<RepresentationNode>();
        private boolean isRoot;

        public RepresentationNode(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public MethodTree getLink() {
            return this.link;
        }

        protected void setLink(MethodTree methodTree) {
            this.link = methodTree;
        }

        public List<RepresentationNode> getAttributes() {
            return this.attrList;
        }

        public void addAttribute(RepresentationNode representationNode) {
            this.attrList.add(representationNode);
        }

        public List<RepresentationNode> getChildren() {
            return this.childList;
        }

        public void addChild(RepresentationNode representationNode) {
            this.childList.add(representationNode);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        protected void setIsRoot(boolean bl) {
            this.isRoot = bl;
        }

        public boolean isReference() {
            return this.getName() != null && this.getName().endsWith("Ref");
        }

        public boolean isEntity() {
            return this.src != null;
        }

        protected JavaSource getSource() {
            return this.src;
        }

        protected void setSource(JavaSource javaSource) {
            this.src = javaSource;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class RepresentationDocument {
        private RepresentationNode root;

        public RepresentationNode getRoot() {
            return this.root;
        }

        protected void setRoot(RepresentationNode representationNode) {
            this.root = representationNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Resource {
        private String name;
        private String path;
        private String desc;
        private JavaSource src;
        private RepresentationDocument rep;
        private boolean isContainer;
        private boolean isContainerItem;
        private List<Method> methodList = Collections.emptyList();

        public Resource(String string, String string2, String string3) {
            this.name = string;
            this.path = string2;
            this.desc = string3;
            this.methodList = new ArrayList<Method>();
            this.rep = new RepresentationDocument();
        }

        public Resource(String string, String string2) {
            this(string, string2, string);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public List<Method> getMethods() {
            return this.methodList;
        }

        public void addMethod(Method method) {
            this.methodList.add(method);
        }

        protected JavaSource getSource() {
            return this.src;
        }

        protected void setSource(JavaSource javaSource) {
            this.src = javaSource;
        }

        public RepresentationDocument getRepresentation() {
            return this.rep;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public void setIsContainer(boolean bl) {
            this.isContainer = bl;
        }

        public boolean isContainerItem() {
            return !this.isContainer;
        }

        public void setIsContainerItem(boolean bl) {
            this.isContainerItem = bl;
        }

        public String toString() {
            return this.getName() + " : " + this.getPath();
        }
    }
}

