/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.RelatedEntityResource;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.Inflector;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResourcesGenerator
extends AbstractGenerator {
    public static final String RESOURCE_FOLDER = "service";
    public static final String CONVERTER_FOLDER = "converter";
    public static final String RESOURCE_SUFFIX = "Resource";
    public static final String CONVERTER_SUFFIX = "Converter";
    public static final String REF_CONVERTER_SUFFIX = "RefConverter";
    public static final String REF_SUFFIX = "Ref";
    private static final String DEFAULT_TEMPLATE = "Templates/WebServices/DefaultResource.java";
    private static final String URI_RESOLVER_TEMPLATE = "Templates/WebServices/UriResolver.java";
    private static final String URI_RESOLVER = "UriResolver";
    private static final String PERSISTENCE_SERVICE_TEMPLATE = "Templates/WebServices/PersistenceService.java";
    private static final String PERSISTENCE_SERVICE = "PersistenceService";
    private static final String DEFAULT_PU_FIELD = "DEFAULT_PU";
    private static final String[] CONTAINER_IMPORTS = new String[]{"javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.ProduceMime", "javax.ws.rs.ConsumeMime", "javax.ws.rs.PathParam", "javax.ws.rs.QueryParam", "javax.ws.rs.DefaultValue", "javax.ws.rs.core.Response", "javax.ws.rs.core.Context", "javax.ws.rs.core.UriInfo"};
    private static final String[] ITEM_IMPORTS = new String[]{"javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.ProduceMime", "javax.ws.rs.ConsumeMime", "javax.ws.rs.WebApplicationException", "javax.persistence.NoResultException"};
    private static final String[] CONTAINER_CONVERTER_IMPORTS = new String[]{"javax.xml.bind.annotation.XmlRootElement", "javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlTransient", "javax.xml.bind.annotation.XmlAttribute", "java.util.ArrayList"};
    private static final String[] ITEM_CONVERTER_IMPORTS = new String[]{"javax.xml.bind.annotation.XmlRootElement", "javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlTransient", "javax.xml.bind.annotation.XmlAttribute"};
    private static final String[] REF_CONVERTER_IMPORTS = new String[]{"javax.xml.bind.annotation.XmlRootElement", "javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlTransient", "javax.xml.bind.annotation.XmlAttribute", "javax.ws.rs.core.UriBuilder"};
    private static final String mimeTypes = "{\"" + Constants.MimeType.XML.value() + "\", \"" + Constants.MimeType.JSON.value() + "\"}";
    private String persistenceUnitName;
    private String targetPackageName;
    private FileObject targetFolder;
    private String packageName;
    private FileObject resourceFolder;
    private String resourcePackageName;
    private FileObject converterFolder;
    private String converterPackageName;
    private EntityResourceBeanModel model;

    public EntityResourcesGenerator(EntityResourceBeanModel entityResourceBeanModel, FileObject fileObject, String string, String string2) {
        this(entityResourceBeanModel, fileObject, string, null, null, string2);
    }

    public EntityResourcesGenerator(EntityResourceBeanModel entityResourceBeanModel, String string, String string2) {
        this(entityResourceBeanModel, null, null, string, string2, null);
    }

    public EntityResourcesGenerator(EntityResourceBeanModel entityResourceBeanModel, FileObject fileObject, String string, String string2, String string3, String string4) {
        this.model = entityResourceBeanModel;
        this.persistenceUnitName = string4;
        this.targetFolder = fileObject;
        this.targetPackageName = string;
        this.resourcePackageName = string2 == null ? string + "." + RESOURCE_FOLDER : string2;
        this.converterPackageName = string3 == null ? string + "." + CONVERTER_FOLDER : string3;
        this.packageName = this.packageName;
    }

    private String toFilePath(String string) {
        return string.replace(".", "/");
    }

    private FileObject getSourceRootFolder(FileObject fileObject, String string) {
        String[] stringArray = string.split("\\.");
        FileObject fileObject2 = fileObject;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) {
                return fileObject2;
            }
            if (fileObject2 == null || !stringArray[i].equals(fileObject2.getNameExt())) {
                throw new IllegalArgumentException("Unmatched folder: " + fileObject.getPath() + " and package name: " + string);
            }
            fileObject2 = fileObject2.getParent();
        }
        return fileObject2;
    }

    public Collection<String> previewClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<EntityResourceBean> collection = this.model.getResourceBeans();
        for (EntityResourceBean entityResourceBean : collection) {
            arrayList.add(this.getResourceType(entityResourceBean));
            arrayList.add(this.getConverterType(entityResourceBean));
            if (!entityResourceBean.isItem()) continue;
            arrayList.add(this.getRefConverterType(entityResourceBean));
        }
        arrayList.add(this.getPersistenceServiceClassType());
        arrayList.add(this.getUriResolverClassType());
        return Utils.sortKeys(arrayList);
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        this.initProgressReporting(progressHandle);
        this.createFolders();
        this.generatePersistenceService();
        this.generateUriResolver();
        HashMap<EntityResourceBean, JavaSource> hashMap = new HashMap<EntityResourceBean, JavaSource>();
        HashMap<EntityResourceBean, JavaSource> hashMap2 = new HashMap<EntityResourceBean, JavaSource>();
        HashMap<EntityResourceBean, JavaSource> hashMap3 = new HashMap<EntityResourceBean, JavaSource>();
        Collection<EntityResourceBean> collection = this.model.getResourceBeans();
        for (EntityResourceBean entityResourceBean : collection) {
            hashMap.put(entityResourceBean, this.generateResourceBean(entityResourceBean));
            hashMap2.put(entityResourceBean, this.generateConverter(entityResourceBean));
            if (!entityResourceBean.isItem()) continue;
            hashMap3.put(entityResourceBean, this.generateRefConverter(entityResourceBean));
        }
        for (EntityResourceBean entityResourceBean : collection) {
            this.modifyResourceBean((JavaSource)hashMap.get(entityResourceBean), entityResourceBean);
            this.modifyConverter((JavaSource)hashMap2.get(entityResourceBean), entityResourceBean);
            if (!entityResourceBean.isItem()) continue;
            this.modifyRefConverter((JavaSource)hashMap3.get(entityResourceBean), entityResourceBean);
        }
        this.finishProgressReporting();
        return new HashSet<FileObject>();
    }

    private void createFolders() {
        FileObject fileObject = this.getSourceRootFolder(this.targetFolder, this.targetPackageName);
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            String string = this.toFilePath(this.resourcePackageName);
            this.resourceFolder = fileObject.getFileObject(string);
            if (this.resourceFolder == null) {
                this.resourceFolder = FileUtil.createFolder((File)new File(file, string));
            }
            String string2 = this.toFilePath(this.converterPackageName);
            this.converterFolder = fileObject.getFileObject(string2);
            if (this.converterFolder == null) {
                this.converterFolder = FileUtil.createFolder((File)new File(file, string2));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void generatePersistenceService() {
        this.reportProgress(this.getPersistenceServiceClassType(), false);
        JavaSource javaSource = JavaSourceHelper.createJavaSource(PERSISTENCE_SERVICE_TEMPLATE, this.resourceFolder, this.getResourcePackageName(), PERSISTENCE_SERVICE);
        if (javaSource == null) {
            return;
        }
        this.reportProgress(this.getPersistenceServiceClassType(), true);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.replaceFieldValue(workingCopy, JavaSourceHelper.getField((CompilationController)workingCopy, EntityResourcesGenerator.DEFAULT_PU_FIELD), EntityResourcesGenerator.this.persistenceUnitName);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void generateUriResolver() {
        this.reportProgress(this.getUriResolverClassType(), false);
        JavaSource javaSource = JavaSourceHelper.createJavaSource(URI_RESOLVER_TEMPLATE, this.converterFolder, this.getConverterPackageName(), URI_RESOLVER);
        this.reportProgress(this.getUriResolverClassType(), true);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, new String[]{EntityResourcesGenerator.this.getPersistenceServiceClassType()});
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private JavaSource generateResourceBean(EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getResourceType(entityResourceBean), false);
        return JavaSourceHelper.createJavaSource(DEFAULT_TEMPLATE, this.resourceFolder, this.getResourcePackageName(), this.getResourceName(entityResourceBean));
    }

    private JavaSource generateConverter(EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getConverterType(entityResourceBean), false);
        return JavaSourceHelper.createJavaSource(DEFAULT_TEMPLATE, this.converterFolder, this.getConverterPackageName(), this.getConverterName(entityResourceBean));
    }

    private JavaSource generateRefConverter(EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getRefConverterType(entityResourceBean), false);
        return JavaSourceHelper.createJavaSource(DEFAULT_TEMPLATE, this.converterFolder, this.getConverterPackageName(), this.getRefConverterName(entityResourceBean));
    }

    private void modifyResourceBean(JavaSource javaSource, EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getResourceType(entityResourceBean), true);
        if (entityResourceBean.isContainer()) {
            this.modifyContainerResourceBean(javaSource, entityResourceBean);
        } else {
            this.modifyItemResourceBean(javaSource, entityResourceBean);
        }
    }

    private void modifyContainerResourceBean(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, EntityResourcesGenerator.this.getContainerResourceImports(entityResourceBean));
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"Path"}, new Object[]{entityResourceBean.getUriTemplate(), JavaSourceHelper.createIdentifierTree(workingCopy, "{" + EntityResourcesGenerator.this.getItemResourceName(entityResourceBean) + ".class}")});
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addStatefulResourceBeanConstructor(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addContainerGetMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addContainerPostMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
                        classTree2 = EntityResourcesGenerator.this.addContainerGetResourceMethod(workingCopy, classTree2, entityResourceBean, relatedEntityResource);
                    }
                    classTree2 = EntityResourcesGenerator.this.addGetEntitiesMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addCreateEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyItemResourceBean(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, EntityResourcesGenerator.this.getItemResourceImports(entityResourceBean));
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addStatefulResourceBeanConstructor(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addItemGetMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addItemPutMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addItemDeleteMethod(workingCopy, classTree2, entityResourceBean);
                    for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
                        classTree2 = EntityResourcesGenerator.this.addItemGetResourceMethod(workingCopy, classTree2, entityResourceBean, relatedEntityResource);
                    }
                    classTree2 = EntityResourcesGenerator.this.addGetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addUpdateEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyConverter(JavaSource javaSource, EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getConverterType(entityResourceBean), true);
        if (entityResourceBean.isContainer()) {
            this.modifyContainerConverter(javaSource, entityResourceBean);
        } else {
            this.modifyItemConverter(javaSource, entityResourceBean);
        }
    }

    private void modifyContainerConverter(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, CONTAINER_CONVERTER_IMPORTS);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", EntityResourcesGenerator.this.getConverterXMLName(entityResourceBean))});
                    classTree2 = EntityResourcesGenerator.this.addConverterFields(workingCopy, classTree2, entityResourceBean, false);
                    classTree2 = EntityResourcesGenerator.this.addConverterConstructor(workingCopy, classTree2, entityResourceBean, false);
                    classTree2 = EntityResourcesGenerator.this.addGetReferencesMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addSetReferencesMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addGetUriMethod(workingCopy, classTree2);
                    classTree2 = EntityResourcesGenerator.this.addContainerConverterGetEntitiesMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyItemConverterDefaultConstructor(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, new String[]{EntityResourcesGenerator.this.getEntityClassType(entityResourceBean)});
                    String string = "{ entity = new $CLASS$(); }";
                    string = string.replace("$CLASS$", EntityResourcesGenerator.this.getEntityClassName(entityResourceBean));
                    JavaSourceHelper.replaceMethodBody(workingCopy, JavaSourceHelper.getDefaultConstructor((CompilationController)workingCopy), string);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyItemConverter(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        this.modifyItemConverterDefaultConstructor(javaSource, entityResourceBean);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, ITEM_CONVERTER_IMPORTS);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", EntityResourcesGenerator.this.getConverterXMLName(entityResourceBean))});
                    classTree2 = EntityResourcesGenerator.this.addConverterFields(workingCopy, classTree2, entityResourceBean, false);
                    classTree2 = EntityResourcesGenerator.this.addConverterConstructor(workingCopy, classTree2, entityResourceBean, false);
                    for (EntityClassInfo.FieldInfo fieldInfo : entityResourceBean.getEntityClassInfo().getFieldInfos()) {
                        classTree2 = EntityResourcesGenerator.this.addGetterMethod(workingCopy, classTree2, fieldInfo);
                        classTree2 = EntityResourcesGenerator.this.addSetterMethod(workingCopy, classTree2, fieldInfo, entityResourceBean);
                    }
                    classTree2 = EntityResourcesGenerator.this.addGetUriMethod(workingCopy, classTree2);
                    classTree2 = EntityResourcesGenerator.this.addItemConverterGetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addItemConverterSetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyRefConverter(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getRefConverterType(entityResourceBean), true);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, REF_CONVERTER_IMPORTS);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", EntityResourcesGenerator.this.getRefConverterXMLName(entityResourceBean))});
                    classTree2 = EntityResourcesGenerator.this.addConverterFields(workingCopy, classTree2, entityResourceBean, true);
                    classTree2 = EntityResourcesGenerator.this.addConverterConstructor(workingCopy, classTree2, entityResourceBean, true);
                    EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
                    classTree2 = EntityResourcesGenerator.this.addGetterMethod(workingCopy, classTree2, fieldInfo);
                    classTree2 = EntityResourcesGenerator.this.addGetUriMethod(workingCopy, classTree2, fieldInfo);
                    classTree2 = EntityResourcesGenerator.this.addSetUriMethod(workingCopy, classTree2, fieldInfo);
                    classTree2 = EntityResourcesGenerator.this.addRefConverterGetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private String[] getContainerResourceImports(EntityResourceBean entityResourceBean) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CONTAINER_IMPORTS));
        HashSet<String> hashSet = new HashSet<String>();
        EntityResourceBean entityResourceBean2 = this.getItemSubResource(entityResourceBean);
        for (RelatedEntityResource relatedEntityResource : entityResourceBean2.getSubResources()) {
            if (!relatedEntityResource.getFieldInfo().isOneToMany()) continue;
            hashSet.add(this.getEntityClassType(relatedEntityResource.getResourceBean()));
        }
        arrayList.addAll(hashSet);
        arrayList.add(this.getConverterType(entityResourceBean));
        arrayList.add(this.getConverterType(this.getItemConverterBean(entityResourceBean)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getItemResourceImports(EntityResourceBean entityResourceBean) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_IMPORTS));
        HashSet<String> hashSet = new HashSet<String>();
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSuperResources()) {
            hashSet.add(this.getEntityClassType(relatedEntityResource.getResourceBean()));
        }
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            if (entityResourceBean2.isContainer()) {
                hashSet.add("java.util.Collection");
                continue;
            }
            String string = this.getIdFieldType(entityResourceBean2);
            if (string.startsWith("java.lang.")) continue;
            hashSet.add(string);
        }
        arrayList.addAll(hashSet);
        arrayList.add(this.getConverterType(entityResourceBean));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private EntityResourceBean getItemConverterBean(EntityResourceBean entityResourceBean) {
        return this.model.getItemResourceBean(entityResourceBean.getEntityClassInfo());
    }

    private ClassTree addResourceBeanFields(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
        ClassTree classTree2 = classTree;
        String[] stringArray = null;
        if (entityResourceBean.isContainer()) {
            stringArray = new String[]{"Context"};
        }
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, stringArray, null, "context", "javax.ws.rs.core.UriInfo");
        if (!entityResourceBean.isContainer()) {
            String[] stringArray2 = this.getIdFieldIdArray(entityResourceBean, false, null);
            Object[] objectArray = this.getIdFieldTypeArray(entityResourceBean, false, null);
            for (int i = 0; i < stringArray2.length; ++i) {
                classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, stringArray, null, stringArray2[i], (String)objectArray[i]);
            }
        }
        return classTree2;
    }

    private ClassTree addStatefulResourceBeanConstructor(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = null;
        Object[] objectArray = null;
        if (entityResourceBean.isContainer()) {
            stringArray = new String[]{"context"};
            objectArray = new String[]{"javax.ws.rs.core.UriInfo"};
        } else {
            stringArray = this.getIdFieldIdArray(entityResourceBean, true, "context");
            objectArray = this.getIdFieldTypeArray(entityResourceBean, true, "javax.ws.rs.core.UriInfo");
        }
        String string = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "this." + stringArray[i] + " = " + stringArray[i] + ";";
        }
        string = string + "}";
        String string2 = "Constructor used for instantiating an instance of dynamic resource.\n\n@param context HttpContext inherited from the parent resource";
        return JavaSourceHelper.addConstructor(workingCopy, classTree, new Modifier[]{Modifier.PUBLIC}, stringArray, objectArray, string, string2);
    }

    private ClassTree addContainerGetMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.GET.prefix();
        String[] stringArray = new String[]{"GET", "ProduceMime"};
        Object[] objectArray = new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)};
        String string3 = this.getConverterType(entityResourceBean);
        String[] stringArray2 = new String[]{"start", "max"};
        Object[] objectArray2 = new String[]{"int", "int"};
        String[][] stringArrayArray = new String[][]{{"QueryParam", "DefaultValue"}, {"QueryParam", "DefaultValue"}};
        Object[][] objectArrayArray = new Object[][]{{"start", "0"}, {"max", "10"}};
        String string4 = "{ try {return new $CONVERTER$(getEntities(start, max), context.getAbsolutePath());} finally {PersistenceService.getInstance().close();}}";
        string4 = string4.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        String string5 = "Get method for retrieving a collection of $CLASS$ instance in XML format.\n\n@return an instance of $CONVERTER$";
        string5 = string5.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, string3, stringArray2, objectArray2, (Object[])stringArrayArray, (Object[])objectArrayArray, string4, string5);
    }

    private ClassTree addContainerPostMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        String string2 = Constants.HttpMethodType.POST.prefix();
        String[] stringArray = new String[]{"POST", "ConsumeMime"};
        Object[] objectArray = new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)};
        String string3 = "javax.ws.rs.core.Response";
        String[] stringArray2 = new String[]{"data"};
        Object[] objectArray2 = new Object[]{this.getItemConverterName(entityResourceBean)};
        String string4 = "{PersistenceService service = PersistenceService.getInstance();try {service.beginTx();$CLASS$ entity = data.getEntity();createEntity(entity);service.commitTx();return Response.created(context.getAbsolutePath().resolve($ID_TO_URI$ + \"/\")).build();} finally {service.close();}}";
        string4 = string4.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$ID_TO_URI$", this.getIdFieldToUriStmt(entityResourceBean));
        String string5 = "Post method for creating an instance of $CLASS$ using XML as the input format.\n\n@param data an $CONVERTER$ entity that is deserialized from an XML stream\n@return an instance of $CONVERTER$";
        string5 = string5.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getItemConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, stringArray, objectArray, string2, string3, stringArray2, objectArray2, null, null, string4, string5);
    }

    private ClassTree addContainerGetResourceMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, RelatedEntityResource relatedEntityResource) {
        EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"Path"};
        Object[] objectArray = new String[]{entityResourceBean2.getUriTemplate()};
        String string = this.getResourceType(entityResourceBean2);
        String string2 = this.getResourceName(entityResourceBean2);
        String string3 = "get" + string2;
        String[] stringArray2 = this.getIdFieldIdArray(entityResourceBean2, false, null);
        Object[] objectArray2 = this.getIdFieldTypeArray(entityResourceBean2, false, null);
        Object[] objectArray3 = this.getIdFieldUriParamArray(entityResourceBean2, false, null);
        Object[] objectArray4 = this.getIdFieldNameArray(entityResourceBean2, false, null);
        String string4 = this.getIdFieldIdList(entityResourceBean2) + ", context";
        String string5 = "{ return new $RESOURCE$(" + string4 + "); }";
        string5 = string5.replace("$RESOURCE$", string2);
        String string6 = "Returns a dynamic instance of $RESOURCE$ used for entity navigation.\n\n@return an instance of $RESOURCE$";
        string6 = string6.replace("$RESOURCE$", this.getResourceName(entityResourceBean2));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string3, string, stringArray2, objectArray2, objectArray3, objectArray4, string5, string6);
    }

    private ClassTree addGetEntitiesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
        String string = "{return PersistenceService.getInstance().createQuery(\"SELECT e FROM $CLASS$ e\").setFirstResult(start).setMaxResults(max).getResultList();}";
        String[] stringArray = new String[]{"start", "max"};
        Object[] objectArray = new Object[]{"int", "int"};
        string = string.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        String string2 = "Returns all the entities associated with this resource.\n\n@return a collection of $CLASS$ instances";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "getEntities", tree, stringArray, objectArray, null, null, string, string2);
    }

    private String getGetEntitiesSubText(EntityResourceBean entityResourceBean) {
        String string = "if (parent instanceof $CLASS$) {return (($CLASS$) parent).$GETTER$();}";
        String string2 = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSuperResources()) {
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
            string2 = string2 + string.replace("$CLASS$", this.getEntityClassName(entityResourceBean2)).replace("$GETTER$", this.getGetterName(fieldInfo));
        }
        return string2;
    }

    private ClassTree addCreateEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string = "void";
        String[] stringArray = new String[]{"entity"};
        Object[] objectArray = new Object[]{this.getEntityClassType(entityResourceBean)};
        String string2 = "{PersistenceService.getInstance().persistEntity(entity);";
        string2 = string2 + this.getUpdateOneToManyRelSubText(this.getItemSubResource(entityResourceBean)) + "}";
        String string3 = "Persist the given entity.\n\n@param entity the entity to persist";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "createEntity", string, stringArray, objectArray, null, null, string2, string3);
    }

    private ClassTree addGetUriMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String string = "{return context.getAbsolutePath();}";
        String string2 = "Returns the URI associated with this resource.\n\n@return URI associated with this resource";
        return JavaSourceHelper.addMethod(workingCopy, classTree, new Modifier[]{Modifier.PRIVATE}, null, null, "getUri", "java.net.URI", null, null, null, null, string, string2);
    }

    private ClassTree addItemGetMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.GET.prefix();
        String[] stringArray = new String[]{"GET", "ProduceMime"};
        Object[] objectArray = new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)};
        String string3 = this.getConverterType(entityResourceBean);
        String string4 = "{ try {return  new $CONVERTER$(getEntity(), context.getAbsolutePath()); } finally {PersistenceService.getInstance().close();}}";
        string4 = string4.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        String string5 = "Get method for retrieving an instance of $CLASS identified by id in XML format.\n\n@param id identifier for the entity\n@return an instance of $CONVERTER$";
        string5 = string5.replace("$CLASS", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, string3, null, null, null, null, string4, string5);
    }

    private ClassTree addItemPutMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.PUT.prefix();
        String[] stringArray = new String[]{"PUT", "ConsumeMime"};
        Object[] objectArray = new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)};
        String[] stringArray2 = new String[]{"data"};
        Object[] objectArray2 = new String[]{this.getConverterType(entityResourceBean)};
        String string3 = "{ PersistenceService service = PersistenceService.getInstance();try {service.beginTx();updateEntity(getEntity(), data.getEntity());service.commitTx();} finally {service.close();}}";
        String string4 = "Put method for updating an instance of $CLASS identified by id using XML as the input format.\n\n@param id identifier for the entity\n@param data an $CONVERTER$ entity that is deserialized from a XML stream\n";
        string4 = string4.replace("$CLASS", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, "void", stringArray2, objectArray2, null, null, string3, string4);
    }

    private ClassTree addItemDeleteMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "void";
        String[] stringArray = new String[]{"DELETE"};
        Object[] objectArray = new Object[]{null};
        String string2 = "{PersistenceService service = PersistenceService.getInstance();try {service.beginTx();$CLASS$ entity = getEntity();service.removeEntity(entity);service.commitTx();} finally {service.close();}}";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        String string3 = "Delete method for deleting an instance of $CLASS identified by id.\n\n@param id identifier for the entity\n";
        string3 = string3.replace("$CLASS", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, Constants.HttpMethodType.DELETE.prefix(), string, null, null, null, null, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    private ClassTree addItemGetResourceMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, RelatedEntityResource relatedEntityResource) {
        void var15_28;
        EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
        EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"Path"};
        String string = this.lowerCaseFirstLetter(entityResourceBean2.getName()) + "/";
        Object[] objectArray = new String[]{string};
        String string2 = this.getResourceType(entityResourceBean2);
        String string3 = this.getResourceName(entityResourceBean2);
        boolean bl = false;
        for (RelatedEntityResource object2 : entityResourceBean.getSubResources()) {
            if (object2 == relatedEntityResource || !string3.equals(this.getResourceName(object2.getResourceBean()))) continue;
            bl = true;
            break;
        }
        Object object3 = "get" + string3;
        if (bl) {
            object3 = (String)object3 + "For" + this.capitalizeFirstLetter(fieldInfo.getName());
        }
        Object var15_16 = null;
        if (entityResourceBean2.isItem()) {
            String string5 = "{final $CLASS$ parent = getEntity();return new $RESOURCE$($ID_PARAMS$, context) {@Override protected $SUBCLASS$ getEntity() {$SUBCLASS$ entity = parent.$GETTER$();if (entity == null) {throw new WebApplicationException(new Throwable(\"Resource for \" + context.getAbsolutePath() + \" does not exist.\"), 404);}return entity;}};}";
            string5 = string5.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$RESOURCE$", string3).replace("$SUBCLASS$", this.getEntityClassName(entityResourceBean2)).replace("$ID_PARAMS$", this.getIdFieldNullValueList(entityResourceBean2)).replace("$GETTER$", this.getGetterName(fieldInfo));
        } else {
            void var15_25;
            String string6 = "{final $CLASS$ parent = getEntity();return new $RESOURCE$(context) {@Override protected Collection<$SUBCLASS$> getEntities(int start, int max) {Collection<$SUBCLASS$> result = new java.util.ArrayList<$SUBCLASS$>();int index = 0;for ($SUBCLASS$ e : parent.$GETTER$()) {if (index >= start && (index - start) < max) {result.add(e);}index++;}return result;}@Override protected void createEntity($SUBCLASS$ entity) {super.createEntity(entity);";
            if (fieldInfo.isOneToMany()) {
                String string7 = string6 + "entity.$SETTER$(parent);";
                for (RelatedEntityResource relatedEntityResource2 : this.getItemSubResource(entityResourceBean2).getSubResources()) {
                    if (entityResourceBean != relatedEntityResource2.getResourceBean()) continue;
                    String string8 = string7.replace("$SETTER$", this.getSetterName(relatedEntityResource2.getFieldInfo()));
                    break;
                }
            } else if (fieldInfo.isManyToMany()) {
                String string9 = string6 + "if (!entity.$GETTER2$().contains(parent)) {entity.$GETTER2$().add(parent);}";
                for (RelatedEntityResource relatedEntityResource3 : this.getItemSubResource(entityResourceBean2).getSubResources()) {
                    EntityResourceBean entityResourceBean3 = relatedEntityResource3.getResourceBean();
                    if (!entityResourceBean3.isContainer() || entityResourceBean != this.getItemSubResource(entityResourceBean3)) continue;
                    String string10 = string9.replace("$GETTER2$", this.getGetterName(relatedEntityResource3.getFieldInfo()));
                    break;
                }
            }
            String string12 = (String)var15_25 + "}};}";
            string12 = string12.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$RESOURCE$", string3).replace("$SUBCLASS$", this.getEntityClassName(entityResourceBean2)).replace("$GETTER$", this.getGetterName(fieldInfo));
        }
        Object object = "Returns a dynamic instance of $RESOURCE$ used for entity navigation.\n\n@param id identifier for the parent entity\n@return an instance of $RESOURCE$";
        object = ((String)object).replace("$RESOURCE$", this.getResourceName(entityResourceBean2));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, (String)object3, string2, null, null, null, null, (String)var15_28, (String)object);
    }

    private ClassTree addGetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        String string = "id";
        String string2 = "";
        String string3 = fieldInfo.getType();
        if (fieldInfo.isEmbeddedId()) {
            string2 = string3 + " id = new " + string3 + "(" + this.getIdFieldIdList(entityResourceBean) + ");";
        } else if (string3.equals("java.lang.Character")) {
            string = "id.charAt(0)";
        }
        String string4 = "{try {$NEW_ID_STMT$return ($CLASS$) PersistenceService.getInstance().createQuery(\"SELECT e FROM $CLASS$ e where e.$ID$ = :$ID$\").setParameter(\"$ID$\", $ID_STRING$).getSingleResult();} catch (NoResultException ex) {throw new WebApplicationException(new Throwable(\"Resource for \" + context.getAbsolutePath() + \" does not exist.\"), 404);}}";
        String string5 = entityResourceBean.getEntityClassInfo().getIdFieldInfo().getName();
        string4 = string4.replace("$NEW_ID_STMT$", string2).replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$ID$", string5).replace("$ID_STRING$", string);
        String string6 = "Returns an instance of $CLASS$ identified by id.\n\n@param id identifier for the entity\n@return an instance of $CLASS$";
        string6 = string6.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "getEntity", this.getEntityClassType(entityResourceBean), null, null, null, null, string4, string6);
    }

    private String getGetEntitySubText(EntityResourceBean entityResourceBean) {
        String string = "if (parent instanceof $SUPERCLASS$) {for ($CLASS$ e : (($SUPERCLASS$) parent).$SUPERGETTER$()) {if (e.$GETTER$().equals(id)) {return e;}}}";
        String string2 = "if (parent instanceof $SUPERCLASS$) {return (($SUPERCLASS$) parent).$SUPERGETTER$();}";
        String string3 = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSuperResources()) {
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
            String string4 = null;
            if (fieldInfo.isOneToMany()) continue;
            string4 = string2;
            string3 = string3 + string4.replace("$SUPERCLASS$", this.getEntityClassName(entityResourceBean2)).replace("$SUPERGETTER$", this.getGetterName(fieldInfo)).replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$GETTER$", this.getGetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo()));
        }
        return string3;
    }

    private ClassTree addUpdateEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string = this.getEntityClassType(entityResourceBean);
        String[] stringArray = new String[]{"entity", "newEntity"};
        Object[] objectArray = new Object[]{this.getEntityClassType(entityResourceBean), this.getEntityClassType(entityResourceBean)};
        String string2 = "{ newEntity.$SETTER$(entity.$GETTER$();";
        string2 = string2.replace("$SETTER$", this.getIdSetter(entityResourceBean)).replace("$GETTER$", this.getIdGetter(entityResourceBean));
        string2 = string2 + this.getRemoveOneToManyRelSubText(entityResourceBean);
        string2 = string2 + "entity = PersistenceService.getInstance().mergeEntity(newEntity);";
        string2 = string2 + this.getUpdateOneToManyRelSubText(entityResourceBean) + "return entity;}";
        String string3 = "Updates entity using data from newEntity.\n\n@param entity the entity to update\n@param newEntity the entity containing the new data\n@return the updated entity";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "updateEntity", string, stringArray, objectArray, null, null, string2, string3);
    }

    private String getRemoveOneToManyRelSubText(EntityResourceBean entityResourceBean) {
        String string = "entity.$GETTER$().removeAll(newEntity.$GETTER$());for ($CLASS$ value : entity.$GETTER$()) {value.$SETTER$(null);}";
        String string2 = "";
        block0: for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
            if (!fieldInfo.isOneToMany() && !fieldInfo.isManyToMany()) continue;
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            EntityResourceBean entityResourceBean3 = this.getItemSubResource(entityResourceBean2);
            for (RelatedEntityResource relatedEntityResource2 : entityResourceBean3.getSubResources()) {
                EntityResourceBean entityResourceBean4 = relatedEntityResource2.getResourceBean();
                if (entityResourceBean != entityResourceBean4) continue;
                string2 = string2 + string.replace("$CLASS$", this.getEntityClassName(entityResourceBean2)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$SETTER$", this.getSetterName(relatedEntityResource2.getFieldInfo()));
                continue block0;
            }
        }
        return string2;
    }

    private String getUpdateOneToManyRelSubText(EntityResourceBean entityResourceBean) {
        String string = "for ($CLASS$ value : entity.$GETTER$()) {value.$SETTER$(entity);}";
        String string2 = "";
        block0: for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
            if (!fieldInfo.isOneToMany() && !fieldInfo.isManyToMany()) continue;
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            EntityResourceBean entityResourceBean3 = this.getItemSubResource(entityResourceBean2);
            for (RelatedEntityResource relatedEntityResource2 : entityResourceBean3.getSubResources()) {
                EntityResourceBean entityResourceBean4 = relatedEntityResource2.getResourceBean();
                if (entityResourceBean != entityResourceBean4) continue;
                string2 = string2 + string.replace("$CLASS$", this.getEntityClassName(entityResourceBean2)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$SETTER$", this.getSetterName(relatedEntityResource2.getFieldInfo()));
                continue block0;
            }
        }
        return string2;
    }

    private ClassTree addConverterFields(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, boolean bl) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
        ClassTree classTree2 = classTree;
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "uri", "java.net.URI");
        if (entityResourceBean.isItem()) {
            if (bl) {
                classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "isUriExtendable", "boolean");
            }
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "entity", this.getEntityClassType(entityResourceBean));
        } else {
            Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getRefConverterType(entityResourceBean)});
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "references", tree);
            tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "entities", tree);
        }
        return classTree2;
    }

    private ClassTree addConverterConstructor(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, boolean bl) {
        String[] stringArray = null;
        Object[] objectArray = null;
        String string = null;
        String string2 = null;
        if (entityResourceBean.isItem()) {
            objectArray = new String[]{this.getEntityClassType(entityResourceBean), "java.net.URI", "boolean"};
            if (bl) {
                stringArray = new String[]{"entity", "uri", "isUriExtendable"};
                string = "{this.entity = entity; this.uri = uri;this.isUriExtendable = isUriExtendable;}";
                string2 = "Creates a new instance of $CONVERTER$.\n\n@param entity associated entity\n@param uri associated uri\n@param isUriExtendable indicates whether the uri can be extended";
                string2 = string2.replace("$CONVERTER$", this.getRefConverterName(entityResourceBean));
            } else {
                stringArray = new String[]{"entity", "uri"};
                string = "{this.entity = entity; this.uri = uri;}";
                string2 = "Creates a new instance of $CONVERTER$.\n\n@param entity associated entity\n@param uri associated uri";
                string2 = string2.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
            }
        } else {
            stringArray = new String[]{"entities", "uri"};
            Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
            objectArray = new Object[]{tree, "java.net.URI"};
            string = "{this.entities = entities; this.uri = uri;}";
            string2 = "Creates a new instance of $CONVERTER$.\n\n@param entities associated entities\n@param uri associated uri";
            string2 = string2.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        }
        return JavaSourceHelper.addConstructor(workingCopy, classTree, new Modifier[]{Modifier.PUBLIC}, stringArray, objectArray, string, string2);
    }

    private ClassTree addGetReferencesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlElement"};
        Object[] objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", this.getRefConverterXMLName(entityResourceBean))};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getRefConverterType(entityResourceBean)});
        String string = "{ references = new ArrayList<$REF_CONVERTER$>();if (entities != null) {for ($CLASS$ entity : entities) {references.add(new $REF_CONVERTER$(entity, uri, true));}}return references;}";
        string = string.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$REF_CONVERTER$", this.getRefConverterName(entityResourceBean));
        String string2 = "Returns a collection of $REF_CONVERTER$.\n\n@return a collection of $REF_CONVERTER$";
        string2 = string2.replace("$REF_CONVERTER$", this.getRefConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, "getReferences", tree, null, null, null, null, string, string2);
    }

    private ClassTree addSetReferencesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"references"};
        String string = this.getRefConverterType(entityResourceBean);
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{string});
        String string2 = "{this.references = references;}";
        String string3 = "Sets a collection of $REF_CONVERTER$.\n\n@param a collection of $REF_CONVERTER$ to set";
        string3 = string3.replace("$REF_CONVERTER$", this.getRefConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, null, null, "setReferences", "void", stringArray, new Object[]{tree}, null, null, string2, string3);
    }

    private ClassTree addGetUriMethod(WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlAttribute"};
        Object[] objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", "uri")};
        String string = "java.net.URI";
        String string2 = "{return uri;}";
        String string3 = "Returns the URI associated with this converter.\n\n@return the uri";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, "getResourceUri", string, null, null, null, null, string2, string3);
    }

    private ClassTree addContainerConverterGetEntitiesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"XmlTransient"};
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
        String string = "{ entities = new ArrayList<$CLASS$>();if (references != null) { for ($REFCLASS$ ref : references) {entities.add(ref.getEntity()); } }return entities;}";
        string = string.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$REFCLASS$", this.getRefConverterName(entityResourceBean));
        String string2 = "Returns a collection $CLASS$ entities.\n\n@return a collection of $CLASS$ entities";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, "getEntities", tree, null, null, null, null, string, string2);
    }

    private ClassTree addGetterMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo) {
        Object object;
        String string = this.getGetterName(fieldInfo);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlElement"};
        Object[] objectArray = null;
        Object object2 = null;
        String string2 = null;
        if (!fieldInfo.isRelationship()) {
            object2 = fieldInfo.getTypeArg() == null ? fieldInfo.getType() : JavaSourceHelper.createParameterizedTypeTree(workingCopy, fieldInfo.getType(), new String[]{fieldInfo.getTypeArg()});
            string2 = "{return entity.$GETTER$();}";
            string2 = string2.replace("$GETTER$", string);
        } else if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
            object = this.model.getContainerResourceBean(fieldInfo.getTypeArg());
            objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", this.lowerCaseFirstLetter(((EntityResourceBean)object).getName()))};
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{if (entity.$GETTER$() != null){return new $CONVERTER$(entity.$GETTER$(), uri.resolve(\"$FIELD$/\"));} return null;}";
            string2 = string2.replace("$CONVERTER$", this.getConverterName((EntityResourceBean)object)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$FIELD$", this.lowerCaseFirstLetter(((EntityResourceBean)object).getName()));
        } else {
            object = this.model.getItemResourceBean(fieldInfo.getType());
            objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", this.getRefConverterXMLName((EntityResourceBean)object))};
            object2 = this.getRefConverterType((EntityResourceBean)object);
            string2 = "{if (entity.$GETTER$() != null){return new $REF_CONVERTER$(entity.$GETTER$(), uri.resolve(\"$FIELD$/\"), false);}return null;}";
            string2 = string2.replace("$REF_CONVERTER$", this.getRefConverterName((EntityResourceBean)object)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$FIELD$", this.lowerCaseFirstLetter(((EntityResourceBean)object).getName()));
        }
        object = "Getter for $FIELD$.\n\n@return value for $FIELD$";
        object = ((String)object).replace("$FIELD$", fieldInfo.getName());
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string, object2, null, null, null, null, string2, (String)object);
    }

    private ClassTree addSetterMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo, EntityResourceBean entityResourceBean) {
        Object object;
        String string = this.getSetterName(fieldInfo);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = null;
        Object[] objectArray = null;
        String[] stringArray2 = new String[]{"value"};
        Object object2 = null;
        String string2 = null;
        if (!fieldInfo.isRelationship()) {
            object2 = fieldInfo.getTypeArg() == null ? fieldInfo.getType() : JavaSourceHelper.createParameterizedTypeTree(workingCopy, fieldInfo.getType(), new String[]{fieldInfo.getTypeArg()});
            string2 = "{ entity.$SETTER$(value); }";
            string2 = string2.replace("$SETTER$", string).replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        } else if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
            object = this.model.getContainerResourceBean(fieldInfo.getTypeArg());
            String string3 = this.model.getItemResourceBean(fieldInfo.getTypeArg()).getName();
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{ if (value != null) {entity.$SETTER$(value.getEntities());}}";
            string2 = string2.replace("$CLASS$", string3).replace("$SETTER$", string);
        } else {
            object = this.model.getItemResourceBean(fieldInfo.getType());
            object2 = this.getRefConverterType((EntityResourceBean)object);
            string2 = "{ if (value != null) {entity.$SETTER$(value.getEntity()); }}";
            string2 = string2.replace("$CLASS$", ((EntityResourceBean)object).getName()).replace("$SETTER$", string);
        }
        object = "Setter for $FIELD$.\n\n@param value the value to set";
        object = ((String)object).replace("$FIELD$", fieldInfo.getName());
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string, "void", stringArray2, new Object[]{object2}, null, null, string2, (String)object);
    }

    private ClassTree addItemConverterGetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"XmlTransient"};
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "{ return entity; }";
        String string2 = "Returns the $CLASS$ entity.\n\n@return an entity";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, "getEntity", this.getEntityClassType(entityResourceBean), null, null, null, null, string, string2);
    }

    private ClassTree addItemConverterSetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"entity"};
        Object[] objectArray = new Object[]{this.getEntityClassName(entityResourceBean)};
        String string = "{ this.entity = entity; }";
        String string2 = "Sets the $CLASS$ entity.\n\n@param entity to set";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "setEntity", "void", stringArray, objectArray, null, null, string, string2);
    }

    private ClassTree addGetUriMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlAttribute"};
        Object[] objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", "uri")};
        String string = "java.net.URI";
        String string2 = "{if (isUriExtendable) {return UriBuilder.fromUri(uri).path($ID_TO_URI$ + \"/\").build();}return uri;}";
        string2 = string2.replace("$ID_TO_URI$", this.getIdFieldToUriStmt(fieldInfo));
        String string3 = "Returns the URI associated with this reference converter.\n\n@return the converted uri";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, "getResourceUri", string, null, null, null, null, string2, string3);
    }

    private ClassTree addSetUriMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "void";
        String[] stringArray = new String[]{"uri"};
        Object[] objectArray = new Object[]{"java.net.URI"};
        String string2 = "{ this.uri = uri; }";
        String string3 = "Sets the URI for this reference converter.\n\n";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "setResourceUri", string, stringArray, objectArray, null, null, string2, string3);
    }

    private ClassTree addRefConverterGetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"XmlTransient"};
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "{ $CONVERTER$ result = UriResolver.getInstance().resolve($CONVERTER$.class, uri);if (result != null) {return result.getEntity();}return null;}";
        string = string.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        String string2 = "Returns the $CLASS$ entity.\n\n@return $CLASS$ entity";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, "getEntity", this.getEntityClassType(entityResourceBean), null, null, null, null, string, string2);
    }

    private EntityResourceBean getItemSubResource(EntityResourceBean entityResourceBean) {
        Collection<RelatedEntityResource> collection = entityResourceBean.getSubResources();
        return collection.iterator().next().getResourceBean();
    }

    private String getResourcePackageName() {
        return this.resourcePackageName;
    }

    private String getConverterPackageName() {
        return this.converterPackageName;
    }

    private String getResourceName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getName() + RESOURCE_SUFFIX;
    }

    private String getItemResourceName(EntityResourceBean entityResourceBean) {
        return Util.getSingularName(entityResourceBean) + RESOURCE_SUFFIX;
    }

    private String getConverterName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getName() + CONVERTER_SUFFIX;
    }

    private String getItemConverterName(EntityResourceBean entityResourceBean) {
        return Util.getSingularName(entityResourceBean) + CONVERTER_SUFFIX;
    }

    private String getRefConverterName(EntityResourceBean entityResourceBean) {
        return Util.getSingularName(entityResourceBean) + REF_CONVERTER_SUFFIX;
    }

    private String getConverterXMLName(EntityResourceBean entityResourceBean) {
        return this.lowerCaseFirstLetter(entityResourceBean.getName());
    }

    private String getRefConverterXMLName(EntityResourceBean entityResourceBean) {
        return this.lowerCaseFirstLetter(Util.getSingularName(entityResourceBean) + REF_SUFFIX);
    }

    private String getRefConverterType(EntityResourceBean entityResourceBean) {
        return this.getConverterPackageName() + "." + this.getRefConverterName(entityResourceBean);
    }

    private String getConverterType(EntityResourceBean entityResourceBean) {
        return this.getConverterPackageName() + "." + entityResourceBean.getName() + CONVERTER_SUFFIX;
    }

    private String getResourceType(EntityResourceBean entityResourceBean) {
        return this.getResourcePackageName() + "." + entityResourceBean.getName() + RESOURCE_SUFFIX;
    }

    private String getGetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "get" + this.capitalizeFirstLetter(fieldInfo.getName());
    }

    private String getSetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "set" + this.capitalizeFirstLetter(fieldInfo.getName());
    }

    private String getIdFieldType(EntityResourceBean entityResourceBean) {
        String string = entityResourceBean.getEntityClassInfo().getIdFieldInfo().getType();
        if (string.equals("java.lang.Character")) {
            return "java.lang.String";
        }
        return string;
    }

    private String getIdFieldName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getIdFieldInfo().getName();
    }

    private String[] getIdFieldIdArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            boolean bl2 = false;
            int n = bl ? collection.size() + 1 : collection.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "id" + (i + 1);
            }
            if (bl) {
                stringArray[n - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{"id"};
        }
        return new String[]{"id", string};
    }

    private String[] getIdFieldNameArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            int n2 = bl ? collection.size() + 1 : collection.size();
            String[] stringArray = new String[n2];
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                stringArray[n++] = fieldInfo2.getName();
            }
            if (bl) {
                stringArray[n2 - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{fieldInfo.getName()};
        }
        return new String[]{fieldInfo.getName(), string};
    }

    private Object[] getIdFieldTypeArray(EntityResourceBean entityResourceBean, boolean bl, Object object) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            int n2 = bl ? collection.size() + 1 : collection.size();
            Object[] objectArray = new Object[n2];
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                objectArray[n++] = fieldInfo2.getType();
            }
            if (bl) {
                objectArray[n2 - 1] = object;
            }
            return objectArray;
        }
        String string = fieldInfo.getType();
        if (string.equals("java.lang.Character")) {
            string = "java.lang.String";
        }
        if (!bl) {
            return new Object[]{string};
        }
        return new Object[]{string, object};
    }

    private String[] getIdFieldUriParamArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            int n = bl ? fieldInfo.getFieldInfos().size() + 1 : fieldInfo.getFieldInfos().size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "PathParam";
            }
            if (bl) {
                stringArray[n - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{"PathParam"};
        }
        return new String[]{"PathParam", string};
    }

    private String getIdFieldIdList(EntityResourceBean entityResourceBean) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            int n = fieldInfo.getFieldInfos().size();
            String string = "";
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    string = string + ", ";
                }
                string = string + "id" + i;
            }
            return string;
        }
        return "id";
    }

    private String getIdFieldNullValueList(EntityResourceBean entityResourceBean) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            String string = "";
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + this.getNullValue(fieldInfo2);
                ++n;
            }
            return string;
        }
        return this.getNullValue(fieldInfo);
    }

    private String getIdFieldToUriStmt(EntityResourceBean entityResourceBean) {
        return this.getIdFieldToUriStmt(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    private String getIdFieldToUriStmt(EntityClassInfo.FieldInfo fieldInfo) {
        String string = this.getGetterName(fieldInfo);
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = collection.size();
            String string2 = "";
            int n2 = 0;
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                if (n2++ > 0) {
                    string2 = string2 + " + \",\" + ";
                }
                string2 = string2 + "entity." + string + "()." + this.getGetterName(fieldInfo2) + "()";
            }
            return string2;
        }
        return "entity." + string + "()";
    }

    private String getIdFieldParamList(EntityResourceBean entityResourceBean) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            int n2 = collection.size();
            String string = "";
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                if (n++ > 0) {
                    string = string + ", ";
                }
                string = string + fieldInfo2.getSimpleTypeName() + " id" + n;
            }
            return string;
        }
        String string = fieldInfo.getSimpleTypeName();
        if (string.equals("Character")) {
            string = "String";
        }
        return string + " id";
    }

    private String getIdGetter(EntityResourceBean entityResourceBean) {
        return this.getGetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    private String getIdSetter(EntityResourceBean entityResourceBean) {
        return this.getSetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    private String getEntityClassName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getName();
    }

    private String getEntityClassType(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getType();
    }

    private String getPersistenceServiceClassType() {
        return this.getResourcePackageName() + "." + PERSISTENCE_SERVICE;
    }

    private String getUriResolverClassType() {
        return this.getConverterPackageName() + "." + URI_RESOLVER;
    }

    private String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    private String lowerCaseFirstLetter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
    }

    private String demodulize(String string) {
        return Inflector.getInstance().demodulize(string);
    }

    private String getNullValue(EntityClassInfo.FieldInfo fieldInfo) {
        String string = fieldInfo.getSimpleTypeName();
        if (string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("byte") || string.equals("short") || string.equals("char")) {
            return "(" + fieldInfo.getSimpleTypeName() + ") 0";
        }
        if (string.equals("boolean")) {
            return "false";
        }
        return "null";
    }

    @Override
    protected int getTotalWorkUnits() {
        int n = 0;
        for (EntityResourceBean entityResourceBean : this.model.getResourceBeans()) {
            n += 2;
            if (!entityResourceBean.isItem()) continue;
            ++n;
        }
        n = (n + 2) * 2;
        return n;
    }

    private void reportProgress(String string, boolean bl) {
        String string2 = null;
        string2 = !bl ? NbBundle.getMessage(EntityResourcesGenerator.class, (String)"MSG_CreatingClass", (Object)string) : NbBundle.getMessage(EntityResourcesGenerator.class, (String)"MSG_ModifyingClass", (Object)string);
        this.reportProgress(string2);
    }
}

