/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.Wizard;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductProjectManager;
import org.netbeans.modules.uml.ui.support.wizard.IWizardSheet;
import org.netbeans.modules.uml.ui.support.wizard.WizardInteriorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardTarget
extends WizardInteriorPage {
    private static final String PG_CAPTION = DefaultDesignPatternResource.getString("IDS_WIZARDCAPTION");
    private static final String PG_TITLE = DefaultDesignPatternResource.getString("IDS_TARGETSCOPE");
    private static final String PG_SUBTITLE = DefaultDesignPatternResource.getString("IDS_TARGETSCOPEHELP");
    private Wizard m_Wizard = null;
    private IProject m_Project = null;
    private JComboBox m_ProjectList = new JComboBox();
    private JLabel jLabel1 = new JLabel();
    private JComboBox m_NamespaceList = new JComboBox();
    private JLabel jLabel2 = new JLabel();
    private JTextArea helpCaption = new JTextArea();

    public WizardTarget(IWizardSheet iWizardSheet, String string, String string2, String string3) {
        super(iWizardSheet, string, string2, string3);
        this.createUI();
    }

    public WizardTarget(IWizardSheet iWizardSheet) {
        this(iWizardSheet, PG_CAPTION, PG_TITLE, PG_SUBTITLE);
    }

    protected void createUI() {
        super.createUI();
        this.jLabel1.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_PROJECT")));
        DefaultDesignPatternResource.setMnemonic((Object)this.jLabel1, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        this.jLabel1.setLabelFor(this.m_ProjectList);
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_ProjectList, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        this.jLabel1.setBorder(new EmptyBorder(new Insets(0, 0, 3, 0)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_PROJECT_COMBOBOX"));
        this.jLabel2.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_NAMESPACE")));
        DefaultDesignPatternResource.setMnemonic((Object)this.jLabel2, (String)DefaultDesignPatternResource.getString("IDS_NAMESPACE"));
        this.jLabel2.setLabelFor(this.m_NamespaceList);
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_NamespaceList, (String)DefaultDesignPatternResource.getString("IDS_NAMESPACE"));
        this.jLabel2.setBorder(new EmptyBorder(new Insets(0, 0, 3, 0)));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_NAMESPACE"));
        this.helpCaption.setLineWrap(true);
        this.helpCaption.setOpaque(false);
        this.helpCaption.setPreferredSize(new Dimension(300, 30));
        this.helpCaption.setMinimumSize(new Dimension(300, 30));
        this.helpCaption.setFont(new Font("SansSerif", 0, 10));
        this.helpCaption.setEditable(false);
        this.helpCaption.setFocusable(false);
        this.helpCaption.getAccessibleContext().setAccessibleName(DefaultDesignPatternResource.getString("ACSN_TEXTAREA"));
        this.helpCaption.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_TEXTAREA"));
        this.pnlContents.setLayout(new GridBagLayout());
        this.pnlContents.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 205), 32, 0));
        this.pnlContents.add((Component)this.m_ProjectList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 284, 0));
        this.pnlContents.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 205), 32, 0));
        this.pnlContents.add((Component)this.m_NamespaceList, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 284, 0));
        this.pnlContents.add((Component)this.helpCaption, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 20, 200, 20), 47, 1));
        this.m_ProjectList.setEditable(false);
        this.m_ProjectList.setEnabled(false);
        this.m_NamespaceList.setEditable(false);
        this.pnlContents.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.addActionListeners();
        this.onInitDialog();
    }

    private void addActionListeners() {
        this.m_ProjectList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardTarget.this.m_ProjectList_actionPerformed(actionEvent);
            }
        });
    }

    private void m_ProjectList_actionPerformed(ActionEvent actionEvent) {
        this.onSelChangeProjectList();
    }

    protected boolean onInitDialog() {
        super.onInitDialog();
        IWizardSheet iWizardSheet = this.getParentSheet();
        this.m_Wizard = (Wizard)iWizardSheet;
        return true;
    }

    public void onSetActive() {
        if (this.m_Wizard != null) {
            this.populateProjectList();
            this.populateProject();
        }
        super.onSetActive();
    }

    public void onWizardBack() {
        if (this.m_Wizard != null) {
            this.m_Wizard.m_RefreshPages = false;
        }
        super.onWizardBack();
    }

    public void onWizardNext() {
        ETList<String> eTList = this.validatePage();
        if (eTList != null && eTList.size() == 0) {
            IDesignPatternDetails iDesignPatternDetails = this.m_Wizard.getDetails();
            if (iDesignPatternDetails != null) {
                iDesignPatternDetails.setProject(this.m_Project);
                INamespace iNamespace = DesignPatternUtilities.getSelectedNamespace(this.m_NamespaceList, this.m_Project);
                if (iNamespace != null) {
                    iDesignPatternDetails.setNamespace(iNamespace);
                } else {
                    iDesignPatternDetails.setNamespace(null);
                }
                super.onWizardNext();
            }
        } else if (eTList != null && eTList.size() > 0) {
            String string = DesignPatternUtilities.formatErrorMessage(eTList);
            DesignPatternUtilities.displayErrorMessage((JDialog)((Object)this.m_Wizard), string);
        }
    }

    private void populateProjectList() {
        if (this.m_ProjectList.getItemCount() == 0) {
            DesignPatternUtilities.populateProjectListWithUserProjects(this.m_ProjectList, true);
        }
    }

    private void populateProject() {
        String string;
        IProject iProject;
        IProductProjectManager iProductProjectManager;
        IProduct iProduct = ProductHelper.getProduct();
        if (iProduct != null && (iProductProjectManager = iProduct.getProjectManager()) != null && (iProject = iProductProjectManager.getCurrentProject()) != null && (string = iProject.getName()) != null && string.length() > 0) {
            this.m_ProjectList.setSelectedItem(string);
            this.onSelChangeProjectList();
        }
    }

    private void onSelChangeProjectList() {
        IProject iProject;
        this.m_Project = null;
        String string = (String)this.m_ProjectList.getSelectedItem();
        if (string != null && string.length() > 0 && (iProject = DesignPatternUtilities.onSelChangeProjectList(string, (JDialog)((Object)this.m_Wizard))) != null) {
            this.m_Project = iProject;
            String string2 = (String)this.m_NamespaceList.getSelectedItem();
            DesignPatternUtilities.populateNamespaceList(this.m_NamespaceList, iProject);
            this.m_NamespaceList.setSelectedItem(string2);
        }
    }

    private ETList<String> validatePage() {
        ETArrayList eTArrayList = new ETArrayList();
        if (this.m_ProjectList.getSelectedIndex() == -1) {
            String string = DesignPatternUtilities.translateString("IDS_SCOPE_NOSELECT");
            eTArrayList.add((Object)string);
        }
        return eTArrayList;
    }
}

