/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.FileSysManip;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.IDesignPatternManager;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PromotePatternPanel
extends JPanel {
    private JLabel errorMsg;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox m_NamespaceCombo;
    private JComboBox m_ProjectCombo;
    private JCheckBox m_RemoveCheck;
    private IProject m_Project = null;
    private IDesignPatternManager m_Manager = null;
    private IDesignPatternDetails m_Details = null;

    public PromotePatternPanel(IDesignPatternManager iDesignPatternManager, IDesignPatternDetails iDesignPatternDetails) {
        this.m_Manager = iDesignPatternManager;
        this.m_Details = iDesignPatternDetails;
        this.initComponents();
        this.populateProjects();
    }

    private void populateProjects() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        IWorkspace iWorkspace = DesignPatternUtilities.getDesignPatternCatalogWorkspace();
        if (iWorkspace != null && (object = iWorkspace.getWSProjects()) != null) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                IWSProject iWSProject = (IWSProject)object.get(i);
                if (iWSProject == null) continue;
                String string = iWSProject.getName();
                String string2 = iWSProject.getLocation();
                String string3 = FileSysManip.getExtension((String)string2);
                if (string3 == null || string3.equals("etpat") || string == null || string.length() <= 0) continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList);
        }
        object = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.m_ProjectCombo.setModel(object);
        if (arrayList.size() > 0) {
            this.m_ProjectCombo.setSelectedIndex(0);
            this.updateNamespaces();
        } else {
            object = new DefaultComboBoxModel();
            this.m_NamespaceCombo.setModel(object);
        }
    }

    private void updateNamespaces() {
        IApplication iApplication;
        IProject iProject = null;
        String string = (String)this.m_ProjectCombo.getSelectedItem();
        if (string != null && (iApplication = ProductHelper.getApplication()) != null && iApplication != null) {
            IWorkspace iWorkspace = DesignPatternUtilities.getDesignPatternCatalogWorkspace();
            if (iWorkspace != null && (iProject = iApplication.openProject(iWorkspace, string)) == null) {
                this.errorMsg.setText(NbBundle.getMessage(PromotePatternPanel.class, (String)"IDS_OPENPROJECTFAILED", (Object)string));
            }
            this.m_Project = iProject;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "//UML:Element.ownedElement/UML:Package";
            ETList<String> eTList = DesignPatternUtilities.getElementNames(iProject, string2, false);
            if (eTList != null) {
                arrayList.add(" ");
                for (int i = 0; i < eTList.size(); ++i) {
                    String string3 = (String)eTList.get(i);
                    arrayList.add(string3);
                }
                Collections.sort(arrayList);
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
                this.m_NamespaceCombo.setModel(defaultComboBoxModel);
                this.m_NamespaceCombo.setSelectedIndex(0);
            }
        }
    }

    protected IDesignPatternDetails getDesignPatterDetail() {
        this.m_Details.setProject(this.m_Project);
        this.m_Details.setNamespace(DesignPatternUtilities.getSelectedNamespace(this.m_NamespaceCombo, this.m_Project));
        this.m_Details.setRemoveOnPromote(this.m_RemoveCheck.isSelected());
        return this.m_Details;
    }

    protected void promote() {
        this.m_Manager.promotePattern(this.getDesignPatterDetail());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.m_ProjectCombo = new JComboBox();
        this.m_NamespaceCombo = new JComboBox();
        this.m_RemoveCheck = new JCheckBox();
        this.errorMsg = new JLabel();
        this.jLabel1.setLabelFor(this.m_ProjectCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PromotePatternPanel.class, (String)"IDS_PROJECT"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PromotePatternPanel.class, (String)"ACSD_PROJECT_COMBOBOX"));
        this.jLabel2.setLabelFor(this.m_NamespaceCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PromotePatternPanel.class, (String)"IDS_NAMESPACE"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PromotePatternPanel.class, (String)"ACSD_Namespace"));
        this.m_ProjectCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.m_ProjectCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PromotePatternPanel.this.m_ProjectComboItemStateChanged(itemEvent);
            }
        });
        this.m_NamespaceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.m_RemoveCheck, (String)NbBundle.getMessage(PromotePatternPanel.class, (String)"IDS_REMOVEFROMPROJECT"));
        this.m_RemoveCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_RemoveCheck.setMargin(new Insets(0, 0, 0, 0));
        this.m_RemoveCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PromotePatternPanel.class, (String)"ACSD_remove_from_project"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.errorMsg)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(15, 15, 15).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.m_NamespaceCombo, 0, 194, Short.MAX_VALUE).addPreferredGap(0)).add((Component)this.m_ProjectCombo, 0, 194, Short.MAX_VALUE))))).add((Component)this.m_RemoveCheck)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.m_ProjectCombo, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.m_NamespaceCombo, -2, -1, -2)).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.m_RemoveCheck).add(19, 19, 19).add((Component)this.errorMsg).addContainerGap()));
    }

    private void m_ProjectComboItemStateChanged(ItemEvent itemEvent) {
        this.updateNamespaces();
    }
}

