/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.RoleCellRenderer;
import org.netbeans.modules.uml.designpattern.RoleTreeTableCellEditor;
import org.netbeans.modules.uml.designpattern.RoleTreeTablePopupListener;
import org.netbeans.modules.uml.designpattern.WizardRoleObject;
import org.netbeans.modules.uml.designpattern.WizardRoles;
import org.netbeans.modules.uml.ui.swing.treetable.JDefaultMutableTreeNode;
import org.netbeans.modules.uml.ui.swing.treetable.JTreeTable;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;

public class JRoleTreeTable
extends JTreeTable {
    private JPopupMenu m_popup = null;
    private WizardRoles m_Class = null;
    private int m_CurRow = 0;
    private WizardRoleObject m_CurRole = null;

    public JRoleTreeTable(TreeTableModel treeTableModel, WizardRoles wizardRoles) {
        super(treeTableModel);
        this.m_Class = wizardRoles;
        this.m_popup = new JPopupMenu();
        GridBagLayout gridBagLayout = new GridBagLayout();
        double[] dArray = new double[]{0.0, 0.5, 0.5};
        gridBagLayout.columnWeights = dArray;
        this.setLayout(gridBagLayout);
        gridBagLayout.invalidateLayout((Container)((Object)this));
        this.doLayout();
        TableColumnModel tableColumnModel = this.getColumnModel();
        RoleTreeTableCellEditor roleTreeTableCellEditor = new RoleTreeTableCellEditor(this.tree, wizardRoles);
        tableColumnModel.getColumn(0).setCellEditor(roleTreeTableCellEditor);
        tableColumnModel.getColumn(1).setCellEditor(roleTreeTableCellEditor);
        tableColumnModel.getColumn(2).setCellEditor(roleTreeTableCellEditor);
        RoleCellRenderer roleCellRenderer = new RoleCellRenderer();
        tableColumnModel.getColumn(0).setCellRenderer(roleCellRenderer);
        tableColumnModel.getColumn(1).setCellRenderer((TableCellRenderer)this.tree);
        tableColumnModel.getColumn(2).setCellRenderer(roleCellRenderer);
        RoleTreeTablePopupListener roleTreeTablePopupListener = new RoleTreeTablePopupListener();
        this.addMouseListener(roleTreeTablePopupListener);
        this.getTree().addMouseListener((MouseListener)new TreeMouseHandler());
        RoleTreeKeyboardHandler roleTreeKeyboardHandler = new RoleTreeKeyboardHandler();
        this.addKeyListener(roleTreeKeyboardHandler);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.setShowVerticalLines(true);
        this.setShowHorizontalLines(true);
        if (treeTableModel.getColumnName(0).equals("")) {
            this.getColumnModel().getColumn(0).setMinWidth(20);
            this.getColumnModel().getColumn(0).setMaxWidth(20);
        }
    }

    public void handlePopupDisplay(Component component) {
        int n = this.getTree().getSelectionRows()[0];
        Rectangle rectangle = this.getTree().getRowBounds(n);
        int n2 = rectangle.y;
        int n3 = rectangle.x;
        Point point = new Point(n3, n2);
        this.handlePopupDisplay(component, n, point);
    }

    public void handlePopupDisplay(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        this.handlePopupDisplay(mouseEvent.getComponent(), n, point);
    }

    public void handlePopupDisplay(Component component, int n, Point point) {
        Object object;
        JDefaultMutableTreeNode jDefaultMutableTreeNode;
        WizardRoleObject wizardRoleObject;
        this.m_popup.removeAll();
        TreePath treePath = this.getTree().getPathForRow(n);
        if (treePath != null && (wizardRoleObject = (WizardRoleObject)(jDefaultMutableTreeNode = (JDefaultMutableTreeNode)(object = treePath.getLastPathComponent())).getUserObject()) != null) {
            this.m_CurRow = n;
            this.m_CurRole = wizardRoleObject;
            ETList<String> eTList = this.m_Class.showMenu(n);
            this.m_Class.setRightClickRow(n);
            if (eTList != null) {
                int n2 = eTList.size();
                for (int i = 0; i < n2; ++i) {
                    String string = (String)eTList.get(i);
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener((ActionListener)((Object)this));
                    this.m_popup.add(jMenuItem);
                }
            }
        }
        if (this.m_popup != null) {
            this.m_popup.show(component, point.x, point.y);
        }
    }

    public WizardRoles getClazz() {
        return this.m_Class;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        String string2 = DefaultDesignPatternResource.getString("IDS_CREATE");
        String string3 = DefaultDesignPatternResource.getString("IDS_DELETE");
        String string4 = DefaultDesignPatternResource.getString("IDS_RENAME");
        if (string.equals(string2)) {
            this.m_Class.onPopupCreate(this.m_CurRow);
        } else if (string.equals(string3)) {
            this.m_Class.onPopupDelete(this.m_CurRow);
        } else if (string.equals(string4)) {
            this.m_Class.onPopupRename(this.m_CurRow);
        }
    }

    public class TreeMouseHandler
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            int n = JRoleTreeTable.this.getTree().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = JRoleTreeTable.this.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1 || mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() != 1 || (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
                // empty if block
            }
        }
    }

    public class RoleTreeKeyboardHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = KeyStroke.getKeyStroke("shift F10").getKeyCode();
            int[] nArray = JRoleTreeTable.this.getSelectedRows();
            if (nArray == null || nArray.length < 1) {
                return;
            }
            if (n == n2) {
                JRoleTreeTable.this.handlePopupDisplay(keyEvent.getComponent());
            }
            switch (n) {
                case 155: {
                    int n3 = nArray[0];
                    ETList<Integer> eTList = JRoleTreeTable.this.m_Class.handleKeys(n3);
                    if (!eTList.contains((Object)new Integer(n))) break;
                    JRoleTreeTable.this.m_Class.onPopupCreate(n3);
                    break;
                }
                case 127: {
                    for (int i = 0; i < nArray.length; ++i) {
                        ETList<Integer> eTList = JRoleTreeTable.this.m_Class.handleKeys(nArray[i]);
                        if (!eTList.contains((Object)new Integer(n))) continue;
                        JRoleTreeTable.this.m_Class.onPopupDelete(nArray[i]);
                        for (int j = i + 1; j < nArray.length; ++j) {
                            nArray[j] = nArray[j] - 1;
                        }
                    }
                    break;
                }
            }
        }
    }
}

