/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.IDesignCenterManager;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IPartFacade;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.ICollaboration;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.FileSysManip;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.designpattern.ADDesignCenterManager;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignCenterUtilities;
import org.netbeans.modules.uml.designpattern.IADDesignCenterManager;
import org.netbeans.modules.uml.designpattern.IDesignPatternCatalog;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeControl;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.IADProduct;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductProjectManager;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenu;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenuItem;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenuSelectionHandler;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingErrorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignPatternUtilities {
    public static boolean m_bWaiting = false;

    public static void populateProjectListWithUserProjects(JComboBox jComboBox, boolean bl) {
        IADProduct iADProduct;
        IProductProjectManager iProductProjectManager;
        ArrayList arrayList;
        ICoreProduct iCoreProduct = ProductHelper.getCoreProduct();
        if (iCoreProduct instanceof IADProduct && (arrayList = (iProductProjectManager = (iADProduct = (IADProduct)iCoreProduct).getProjectManager()).getOpenProjects()) != null) {
            DefaultComboBoxModel defaultComboBoxModel;
            if (bl) {
                jComboBox.removeAllItems();
            }
            if ((defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel()) == null) {
                defaultComboBoxModel = new DefaultComboBoxModel();
            }
            Vector<String> vector = new Vector<String>();
            int n = arrayList.size();
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                String string;
                IProject iProject = (IProject)arrayList.get(i);
                if (iProject == null || (string = iProject.getName()) == null || string.length() <= 0) continue;
                vector.add(string);
            }
            DesignPatternUtilities.sortStringInfo(defaultComboBoxModel, vector);
            jComboBox.setModel(defaultComboBoxModel);
        }
    }

    public static void populateProjectListWithDesignCenterProjects(JComboBox jComboBox, boolean bl) {
        ETList eTList;
        IWorkspace iWorkspace = DesignPatternUtilities.getDesignPatternCatalogWorkspace();
        if (iWorkspace != null && (eTList = iWorkspace.getWSProjects()) != null) {
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<String> vector = new Vector<String>();
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IWSProject iWSProject = (IWSProject)eTList.get(i);
                if (iWSProject == null) continue;
                String string = iWSProject.getName();
                if (bl) {
                    String string2 = iWSProject.getLocation();
                    String string3 = FileSysManip.getExtension((String)string2);
                    if (string3 == null || string3.equals("etpat") || string == null || string.length() <= 0) continue;
                    vector.add(string);
                    continue;
                }
                vector.add(string);
            }
            DesignPatternUtilities.sortStringInfo(defaultComboBoxModel, vector);
            jComboBox.setModel(defaultComboBoxModel);
            jComboBox.setSelectedIndex(-1);
        }
    }

    private static void sortStringInfo(DefaultComboBoxModel defaultComboBoxModel, Vector<String> vector) {
        if (defaultComboBoxModel != null) {
            TreeMap<Object[], Object[]> treeMap = new TreeMap<Object[], Object[]>();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = vector.get(i);
                if (objectArray == null) continue;
                treeMap.put(objectArray, objectArray);
            }
            Set set = treeMap.keySet();
            for (Object object : set.toArray()) {
                defaultComboBoxModel.addElement(object);
            }
        }
    }

    public static IProject onSelChangeProjectList(String string, JDialog jDialog) {
        IApplication iApplication;
        IProject iProject = null;
        if (string != null && (iApplication = ProductHelper.getApplication()) != null && iApplication != null) {
            IWorkspace iWorkspace;
            IWorkspace iWorkspace2 = ProductHelper.getWorkspace();
            if (iWorkspace2 != null) {
                DesignPatternUtilities.startWaitCursor(jDialog);
                EventBlocker.startBlocking();
                iProject = iApplication.openProject(iWorkspace2, string);
                EventBlocker.stopBlocking((boolean)false);
                DesignPatternUtilities.endWaitCursor(jDialog);
            }
            if (iProject == null && (iWorkspace = DesignPatternUtilities.getDesignPatternCatalogWorkspace()) != null) {
                SwingErrorDialog swingErrorDialog;
                DesignPatternUtilities.startWaitCursor(jDialog);
                EventBlocker.startBlocking();
                iProject = iApplication.openProject(iWorkspace, string);
                if (iProject == null && (swingErrorDialog = new SwingErrorDialog(jDialog)) != null) {
                    String string2 = DesignPatternUtilities.translateString("IDS_OPENPROJECTFAILED");
                    string2 = StringUtilities.replaceAllSubstrings((String)string2, (String)"%s", (String)string);
                    swingErrorDialog.display(string2, 3, "");
                }
                DesignPatternUtilities.endWaitCursor(jDialog);
                EventBlocker.stopBlocking((boolean)false);
            }
        }
        return iProject;
    }

    public static void populateNamespaceList(JComboBox jComboBox, IProject iProject) {
        if (iProject != null) {
            jComboBox.removeAllItems();
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<String> vector = new Vector<String>();
            String string = "//UML:Element.ownedElement/UML:Package";
            ETList<String> eTList = DesignPatternUtilities.getElementNames(iProject, string, false);
            if (eTList != null) {
                vector.add(" ");
                int n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)eTList.get(i);
                    vector.add(string2);
                }
                DesignPatternUtilities.sortStringInfo(defaultComboBoxModel, vector);
                jComboBox.setModel(defaultComboBoxModel);
            }
        }
    }

    public static INamespace getSelectedNamespace(JComboBox jComboBox, IProject iProject) {
        String string;
        INamespace iNamespace = null;
        if (iProject != null && (string = (String)jComboBox.getSelectedItem()) != null && string.length() > 0) {
            ETList eTList;
            String string2 = "//UML:Package";
            ElementLocator elementLocator = new ElementLocator();
            if (elementLocator != null && (eTList = elementLocator.findElementsByDeepQuery((INamespace)iProject, string2)) != null) {
                int n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    INamespace iNamespace2;
                    String string3;
                    IElement iElement = (IElement)eTList.get(i);
                    if (iElement == null || !(iElement instanceof INamespace) || !(string3 = (iNamespace2 = (INamespace)iElement).getQualifiedName()).equals(string)) continue;
                    iNamespace = iNamespace2;
                    break;
                }
            }
        }
        return iNamespace;
    }

    public static ETList<String> getElementNames(IProject iProject, String string, boolean bl) {
        ETList eTList;
        ElementLocator elementLocator;
        ETArrayList eTArrayList = new ETArrayList();
        if (iProject != null && string != null && (elementLocator = new ElementLocator()) != null && (eTList = elementLocator.findElementsByDeepQuery((INamespace)iProject, string)) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IElement iElement = (IElement)eTList.get(i);
                if (iElement == null || !(iElement instanceof INamedElement)) continue;
                INamedElement iNamedElement = (INamedElement)iElement;
                String string2 = iNamedElement.getXMIID();
                String string3 = iNamedElement.getQualifiedName();
                if (bl) {
                    eTArrayList.add((Object)string2);
                    continue;
                }
                eTArrayList.add((Object)string3);
            }
        }
        return eTArrayList;
    }

    public static ICollaboration getPatternByID(String string, IProject iProject) {
        IElement iElement;
        int n;
        String string2;
        ETList eTList;
        ElementLocator elementLocator;
        ICollaboration iCollaboration = null;
        if (iProject != null && string != null && (elementLocator = new ElementLocator()) != null && (eTList = elementLocator.findElementsByDeepQuery((INamespace)iProject, string2 = "//UML:Collaboration[@xmi.id='" + string + "']")) != null && (n = eTList.size()) > 0 && (iElement = (IElement)eTList.get(0)) instanceof ICollaboration) {
            iCollaboration = (ICollaboration)iElement;
        }
        return iCollaboration;
    }

    public static boolean onlyCollaborationSelected(IProductContextMenu iProductContextMenu) {
        boolean bl;
        block2: {
            block3: {
                int n;
                ICollaboration iCollaboration;
                ETList eTList;
                IElement iElement;
                IProjectTreeItem iProjectTreeItem;
                int n2;
                Object object;
                bl = false;
                if (iProductContextMenu == null || (object = iProductContextMenu.getParentControl()) == null) break block2;
                if (!(object instanceof IProjectTreeControl)) break block3;
                IProjectTreeControl iProjectTreeControl = (IProjectTreeControl)object;
                IProjectTreeItem[] iProjectTreeItemArray = iProjectTreeControl.getSelected();
                if (iProjectTreeItemArray == null || (n2 = iProjectTreeItemArray.length) != 1 || (iProjectTreeItem = iProjectTreeItemArray[0]) == null || (iElement = iProjectTreeItem.getModelElement()) == null || !(iElement instanceof ICollaboration) || (eTList = (iCollaboration = (ICollaboration)iElement).getTemplateParameters()) == null || (n = eTList.size()) <= 0) break block2;
                bl = true;
                break block2;
            }
            ETList<IPresentationElement> eTList = DesignPatternUtilities.getSelectedOnCurrentDiagram();
            if (eTList != null) {
                int n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    IElement iElement;
                    IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                    if (iPresentationElement == null || (iElement = iPresentationElement.getFirstSubject()) == null || !(iElement instanceof ICollaboration)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean onlyClassifiersSelected(IProductContextMenu iProductContextMenu) {
        boolean bl;
        block15: {
            block16: {
                Object object;
                bl = false;
                if (iProductContextMenu == null || (object = iProductContextMenu.getParentControl()) == null) break block15;
                if (!(object instanceof IProjectTreeControl)) break block16;
                IProjectTreeControl iProjectTreeControl = (IProjectTreeControl)object;
                IProjectTreeItem[] iProjectTreeItemArray = iProjectTreeControl.getSelected();
                if (iProjectTreeItemArray == null) break block15;
                for (IProjectTreeItem iProjectTreeItem : iProjectTreeItemArray) {
                    if (iProjectTreeItem == null) continue;
                    String string = iProjectTreeItem.getModelElementMetaType();
                    if (string != null && string.length() > 0) {
                        if (string.equals("PartFacade")) {
                            bl = false;
                        } else {
                            if (string.equals("Class") || string.equals("Actor") || string.equals("Artifact") || string.equals("DataType") || string.equals("DerivationClassifier") || string.equals("Interface") || string.equals("Behavior") || string.equals("Signal") || string.equals("Association") || string.equals("Aggregation") || string.equals("AssociationClass") || string.equals("UseCase") || string.equals("Enumeration") || string.equals("AliasedType") || string.equals("Node") || string.equals("Activity") || string.equals("StateMachine") || string.equals("Collaboration")) {
                                bl = true;
                                continue;
                            }
                            if (string.equals("Package")) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    break block15;
                }
                break block15;
            }
            ETList<IPresentationElement> eTList = DesignPatternUtilities.getSelectedOnCurrentDiagram();
            if (eTList != null) {
                int n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                    if (iPresentationElement == null) continue;
                    IElement iElement = iPresentationElement.getFirstSubject();
                    if (iElement != null) {
                        if (iElement instanceof IPartFacade) {
                            bl = false;
                        } else {
                            if (iElement instanceof IClassifier) {
                                bl = true;
                                continue;
                            }
                            if (iElement instanceof IPackage) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    break;
                }
            }
        }
        return bl;
    }

    public static ETList<IPresentationElement> getSelectedOnCurrentDiagram() {
        IDiagram iDiagram;
        IProductDiagramManager iProductDiagramManager;
        ETArrayList eTArrayList = new ETArrayList();
        IProduct iProduct = ProductHelper.getProduct();
        if (iProduct != null && (iProductDiagramManager = iProduct.getDiagramManager()) != null && (iDiagram = iProductDiagramManager.getCurrentDiagram()) != null) {
            eTArrayList = iDiagram.getSelected();
        }
        return eTArrayList;
    }

    public static ICollaboration getSelectedCollaboration(Object object) {
        ICollaboration iCollaboration = null;
        if (object != null) {
            if (object instanceof IProjectTreeControl) {
                IElement iElement;
                IProjectTreeItem iProjectTreeItem;
                int n;
                IProjectTreeControl iProjectTreeControl = (IProjectTreeControl)object;
                IProjectTreeItem[] iProjectTreeItemArray = iProjectTreeControl.getSelected();
                if (iProjectTreeItemArray != null && (n = iProjectTreeItemArray.length) == 1 && (iProjectTreeItem = iProjectTreeItemArray[0]) != null && (iElement = iProjectTreeItem.getModelElement()) != null && iElement instanceof ICollaboration) {
                    iCollaboration = (ICollaboration)iElement;
                }
            } else {
                IElement iElement;
                IPresentationElement iPresentationElement;
                int n;
                ETList<IPresentationElement> eTList = DesignPatternUtilities.getSelectedOnCurrentDiagram();
                if (eTList != null && (n = eTList.size()) == 1 && (iPresentationElement = (IPresentationElement)eTList.get(0)) != null && (iElement = iPresentationElement.getFirstSubject()) != null && iElement instanceof ICollaboration) {
                    iCollaboration = (ICollaboration)iElement;
                }
            }
        }
        return iCollaboration;
    }

    public static IWorkspace getDesignPatternCatalogWorkspace() {
        IWorkspace iWorkspace = null;
        ICoreProduct iCoreProduct = ProductHelper.getCoreProduct();
        if (iCoreProduct != null) {
            IWorkspace iWorkspace2;
            IDesignPatternCatalog iDesignPatternCatalog;
            IADDesignCenterManager iADDesignCenterManager;
            IDesignCenterManager iDesignCenterManager = iCoreProduct.getDesignCenterManager();
            if (iDesignCenterManager == null) {
                iADDesignCenterManager = new ADDesignCenterManager();
                iCoreProduct.setDesignCenterManager((IDesignCenterManager)iADDesignCenterManager);
                iDesignCenterManager = iADDesignCenterManager;
            }
            if (iDesignCenterManager != null && iDesignCenterManager instanceof IADDesignCenterManager && (iDesignPatternCatalog = (iADDesignCenterManager = (IADDesignCenterManager)iDesignCenterManager).getDesignPatternCatalog()) != null && (iWorkspace2 = iDesignPatternCatalog.getWorkspace()) instanceof IWorkspace) {
                iWorkspace = iWorkspace2;
            }
        }
        return iWorkspace;
    }

    public static void addApplyMenuItem(IProductContextMenu iProductContextMenu, IProductContextMenuSelectionHandler iProductContextMenuSelectionHandler) {
        if (iProductContextMenu != null && iProductContextMenuSelectionHandler != null) {
            String string = DesignPatternUtilities.translateString("IDS_POPUP_APPLY");
            boolean bl = true;
            IProductContextMenuItem iProductContextMenuItem = null;
            iProductContextMenuItem = DesignCenterUtilities.createMenuItemOnMain(iProductContextMenu, string, "MBK_DESIGN_PATTERN_APPLY", bl, iProductContextMenuSelectionHandler);
            if (iProductContextMenuItem != null) {
                IProductContextMenuItem iProductContextMenuItem2 = null;
                String string2 = DesignPatternUtilities.translateString("IDS_POPUP_DESIGNPATTERN");
                iProductContextMenuItem2 = DesignCenterUtilities.createMenuItemOnSub(iProductContextMenuItem, string2, "MBK_DESIGN_PATTERN_APPLY2", bl, iProductContextMenuSelectionHandler);
            }
        }
    }

    public static void populatePatternList(JComboBox jComboBox, IProject iProject) {
        if (iProject != null) {
            jComboBox.removeAllItems();
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<String> vector = new Vector<String>();
            String string = "//UML:Collaboration";
            ETList<String> eTList = DesignPatternUtilities.getElementNames(iProject, string, false);
            if (eTList != null) {
                int n = eTList.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)eTList.get(i);
                    vector.add(string2);
                }
            }
            DesignPatternUtilities.sortStringInfo(defaultComboBoxModel, vector);
            jComboBox.setModel(defaultComboBoxModel);
        }
    }

    public static void displayErrorMessage(JDialog jDialog, String string) {
        SwingErrorDialog swingErrorDialog;
        if (string != null && string.length() > 0 && (swingErrorDialog = new SwingErrorDialog(jDialog)) != null) {
            swingErrorDialog.display(string, 3, "");
        }
    }

    public static String formatErrorMessage(ETList<String> eTList) {
        String string = "";
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)eTList.get(i);
                if (string != null && string.length() > 0) {
                    string = string + "\n";
                }
                string = string + string2;
            }
        }
        return string;
    }

    public static String translateString(String string) {
        return DefaultDesignPatternResource.getString(string);
    }

    public static void startWaitCursor(Component component) {
        if (!m_bWaiting && component != null) {
            component.setCursor(Cursor.getPredefinedCursor(3));
            m_bWaiting = true;
        }
    }

    public static void endWaitCursor(Component component) {
        if (m_bWaiting && component != null) {
            m_bWaiting = false;
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

