/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.grammar;

import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntGrammar
implements GrammarQuery {
    private static final Logger LOG = Logger.getLogger(AntGrammar.class.getName());
    private static final String[] STOCK_PROPERTY_NAMES = new String[]{"ant.home", "basedir", "ant.file", "ant.project.name", "ant.java.version", "ant.version", "java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"};
    private static final String[] PROPERTY_NAME_VALUED_PROPERTY_NAMES = new String[]{"if", "unless", "property", "failureproperty", "errorproperty", "addproperty"};

    AntGrammar() {
    }

    public Enumeration<GrammarResult> queryEntities(String string) {
        ArrayList<MyEntityReference> arrayList = new ArrayList<MyEntityReference>();
        if ("lt".startsWith(string)) {
            arrayList.add(new MyEntityReference("lt"));
        }
        if ("gt".startsWith(string)) {
            arrayList.add(new MyEntityReference("gt"));
        }
        if ("apos".startsWith(string)) {
            arrayList.add(new MyEntityReference("apos"));
        }
        if ("quot".startsWith(string)) {
            arrayList.add(new MyEntityReference("quot"));
        }
        if ("amp".startsWith(string)) {
            arrayList.add(new MyEntityReference("amp"));
        }
        LOG.log(Level.FINE, "queryEntities({0}) -> {1}", new Object[]{string, arrayList});
        return Collections.enumeration(arrayList);
    }

    private static IntrospectedInfo getAntGrammar() {
        return IntrospectedInfo.getKnownInfo();
    }

    static final ElementType typeOf(Element element) {
        String string = element.getNodeName();
        Node node = element.getParentNode();
        if (node == null) {
            throw new IllegalArgumentException("Detached node: " + element);
        }
        if (node.getNodeType() == 9) {
            if (string.equals("project")) {
                return new ElementType(Kind.PROJECT, null);
            }
            return null;
        }
        if (node.getNodeType() == 1) {
            ElementType elementType = AntGrammar.typeOf((Element)node);
            if (elementType == null) {
                return null;
            }
            switch (elementType.kind) {
                case PROJECT: {
                    if (string.equals("description")) {
                        return new ElementType(Kind.DESCRIPTION, null);
                    }
                    if (string.equals("target")) {
                        return new ElementType(Kind.TARGET, null);
                    }
                    if (string.equals("import")) {
                        return new ElementType(Kind.IMPORT, null);
                    }
                    String string2 = (String)AntGrammar.getAntGrammar().getDefs("task").get(string);
                    if (string2 != null) {
                        return new ElementType(Kind.TASK, string2);
                    }
                    String string3 = (String)AntGrammar.getAntGrammar().getDefs("type").get(string);
                    if (string3 != null) {
                        return new ElementType(Kind.TYPE, string3);
                    }
                    return null;
                }
                case TARGET: {
                    String string4 = (String)AntGrammar.getAntGrammar().getDefs("task").get(string);
                    if (string4 != null) {
                        return new ElementType(Kind.TASK, string4);
                    }
                    String string5 = (String)AntGrammar.getAntGrammar().getDefs("type").get(string);
                    if (string5 != null) {
                        return new ElementType(Kind.TYPE, string5);
                    }
                    return null;
                }
                case DESCRIPTION: {
                    return null;
                }
                case IMPORT: {
                    return null;
                }
            }
            String string6 = (String)AntGrammar.getAntGrammar().getElements(elementType.name).get(string);
            if (string6 != null) {
                return new ElementType(Kind.DATA, string6);
            }
            return null;
        }
        throw new IllegalArgumentException("Bad parent for " + element.toString() + ": " + node);
    }

    public Enumeration<GrammarResult> queryAttributes(HintContext hintContext) {
        LinkedList<String> linkedList;
        Element element = null;
        if (hintContext.getNodeType() == 2) {
            element = ((Attr)hintContext).getOwnerElement();
        } else if (hintContext.getNodeType() == 1) {
            element = (Element)hintContext;
        }
        if (element == null) {
            return Enumerations.empty();
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        ElementType elementType = AntGrammar.typeOf(element);
        if (elementType == null) {
            return Enumerations.empty();
        }
        switch (elementType.kind) {
            case PROJECT: {
                linkedList = new LinkedList<String>();
                linkedList.add("default");
                linkedList.add("name");
                linkedList.add("basedir");
                break;
            }
            case TARGET: {
                linkedList = new LinkedList();
                linkedList.add("name");
                linkedList.add("depends");
                linkedList.add("description");
                linkedList.add("if");
                linkedList.add("unless");
                break;
            }
            case DESCRIPTION: {
                return Enumerations.empty();
            }
            case IMPORT: {
                linkedList = new LinkedList();
                linkedList.add("file");
                linkedList.add("optional");
                break;
            }
            default: {
                linkedList = new LinkedList();
                if (elementType.kind == Kind.TYPE) {
                    linkedList.add("id");
                }
                if (AntGrammar.getAntGrammar().isKnown(elementType.name)) {
                    linkedList.addAll(new TreeSet(AntGrammar.getAntGrammar().getAttributes(elementType.name).keySet()));
                }
                if (elementType.kind != Kind.TASK) break;
                linkedList.add("id");
                linkedList.add("description");
                linkedList.add("taskname");
            }
        }
        String string = hintContext.getCurrentPrefix();
        ArrayList<MyAttr> arrayList = new ArrayList<MyAttr>();
        for (String string2 : linkedList) {
            if (!string2.startsWith(string) || namedNodeMap.getNamedItem(string2) != null) continue;
            arrayList.add(new MyAttr(string2));
        }
        LOG.log(Level.FINE, "queryAttributes({0}) -> {1}", new Object[]{string, arrayList});
        return Collections.enumeration(arrayList);
    }

    public Enumeration<GrammarResult> queryElements(HintContext hintContext) {
        Object object;
        List<Object> list;
        Node node = hintContext.getParentNode();
        if (node == null) {
            return Enumerations.empty();
        }
        if (node.getNodeType() != 1) {
            return Enumerations.empty();
        }
        ElementType elementType = AntGrammar.typeOf((Element)node);
        if (elementType == null) {
            return Enumerations.empty();
        }
        switch (elementType.kind) {
            case PROJECT: {
                list = new LinkedList<String>();
                list.add("target");
                list.add("import");
                list.add("property");
                list.add("description");
                object = AntGrammar.getSortedDefs("task");
                object.remove("property");
                object.remove("import");
                list.addAll((Collection<Object>)object);
                list.addAll(AntGrammar.getSortedDefs("type"));
                break;
            }
            case TARGET: {
                list = new ArrayList<String>(AntGrammar.getSortedDefs("task"));
                list.addAll(AntGrammar.getSortedDefs("type"));
                break;
            }
            case DESCRIPTION: {
                return Enumerations.empty();
            }
            case IMPORT: {
                return Enumerations.empty();
            }
            default: {
                list = AntGrammar.getAntGrammar().isKnown(elementType.name) ? new ArrayList(new TreeSet(AntGrammar.getAntGrammar().getElements(elementType.name).keySet())) : Collections.emptyList();
            }
        }
        object = hintContext.getCurrentPrefix();
        ArrayList<MyElement> arrayList = new ArrayList<MyElement>();
        for (String string : list) {
            if (!string.startsWith((String)object)) continue;
            arrayList.add(new MyElement(string));
        }
        LOG.log(Level.FINE, "queryElements({0}) -> {1}", new Object[]{object, arrayList});
        return Collections.enumeration(arrayList);
    }

    private static SortedSet<String> getSortedDefs(String string) {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(AntGrammar.getAntGrammar().getDefs(string).keySet());
        return treeSet;
    }

    public Enumeration<GrammarResult> queryNotations(String string) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryValues(HintContext hintContext) {
        Object object;
        String string;
        LOG.log(Level.FINE, "queryValues({0})", hintContext.getCurrentPrefix());
        if (AntGrammar.canCompleteProperty(hintContext.getCurrentPrefix())) {
            LOG.fine("...can complete property");
            return AntGrammar.completeProperties(hintContext);
        }
        if (hintContext.getNodeType() != 2) {
            LOG.fine("...unknown node type");
            return Enumerations.empty();
        }
        Attr attr = (Attr)hintContext;
        Element element = attr.getOwnerElement();
        String string2 = attr.getName();
        ElementType elementType = AntGrammar.typeOf(element);
        if (elementType == null) {
            LOG.fine("...unknown type");
            return Enumerations.empty();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (elementType.kind) {
            case PROJECT: {
                if (string2.equals("default") || !string2.equals("basedir")) break;
                break;
            }
            case TARGET: {
                if (string2.equals("depends") || !string2.equals("if") && !string2.equals("unless")) break;
                arrayList.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(hintContext)));
                break;
            }
            case DESCRIPTION: {
                break;
            }
            case IMPORT: {
                if (string2.equals("file") || !string2.equals("optional")) break;
                arrayList.add("true");
                arrayList.add("false");
                break;
            }
            default: {
                String[] stringArray;
                string = elementType.name;
                if (!AntGrammar.getAntGrammar().isKnown(string) || (object = (String)AntGrammar.getAntGrammar().getAttributes(string).get(string2)) == null) break;
                if (AntGrammar.getAntGrammar().isKnown((String)object) && (stringArray = AntGrammar.getAntGrammar().getTags((String)object)) != null) {
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                if (((String)object).equals("boolean")) {
                    arrayList.add("true");
                    arrayList.add("false");
                    break;
                }
                if (((String)object).equals("org.apache.tools.ant.types.Reference") || ((String)object).equals("org.apache.tools.ant.types.Path") || ((String)object).equals("java.io.File") || !((String)object).equals("java.lang.String") || !Arrays.asList(PROPERTY_NAME_VALUED_PROPERTY_NAMES).contains(string2)) break;
                arrayList.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(hintContext)));
            }
        }
        string = hintContext.getCurrentPrefix();
        object = new ArrayList();
        for (String string3 : arrayList) {
            if (!string3.startsWith(string)) continue;
            object.add(new MyText(string3));
        }
        LOG.log(Level.FINE, "queryValues({0}) -> {1}", new Object[]{string, object});
        return Collections.enumeration(object);
    }

    private static boolean canCompleteProperty(String string) {
        if ((string = AntGrammar.deletedEscapedShells(string)).length() == 0) {
            return false;
        }
        if (string.charAt(string.length() - 1) == '$') {
            return true;
        }
        int n = string.lastIndexOf("${");
        return n != -1 && string.indexOf(125, n) == -1;
    }

    private static Enumeration<GrammarResult> completeProperties(HintContext hintContext) {
        String string;
        String string2;
        String string3 = hintContext.getCurrentPrefix();
        assert (string3.length() > 0);
        if (string3.charAt(string3.length() - 1) == '$') {
            string2 = string3 + '{';
            string = "";
        } else {
            int n = string3.lastIndexOf("${");
            assert (n != -1);
            string2 = string3.substring(0, n + 2);
            string = string3.substring(n + 2);
        }
        String[] stringArray = AntGrammar.likelyPropertyNames(hintContext);
        boolean bl = hintContext.getNodeType() == 3;
        ArrayList<MyText> arrayList = new ArrayList<MyText>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            String string4 = string2 + stringArray[i] + '}';
            if (bl) {
                assert (string4.startsWith(string3)) : "text=" + string4 + " content=" + string3;
                string4 = string4.substring(string3.length());
            }
            arrayList.add(new MyText(string4));
        }
        LOG.log(Level.FINE, "completeProperties({0}) -> {1}", new Object[]{string3, arrayList});
        return Collections.enumeration(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] likelyPropertyNames(HintContext hintContext) {
        Object object;
        Element element;
        if (hintContext.getNodeType() == 2) {
            element = ((Attr)hintContext).getOwnerElement();
        } else {
            if (hintContext.getNodeType() != 3) {
                System.err.println("strange context type: " + hintContext.getNodeType() + " " + hintContext);
                return new String[0];
            }
            object = hintContext.getParentNode();
            if (object != null && object.getNodeType() == 1) {
                element = (Element)object;
            } else {
                System.err.println("strange parent of text node: " + object.getNodeType() + " " + object);
                return new String[0];
            }
        }
        while (element.getParentNode() != null && element.getParentNode().getNodeType() == 1) {
            element = (Element)element.getParentNode();
        }
        object = new TreeSet<String>(Arrays.asList(STOCK_PROPERTY_NAMES));
        AntGrammar.visitForLikelyPropertyNames(element, (Set<String>)object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf("${") == -1) continue;
            iterator.remove();
        }
        return object.toArray(new String[object.size()]);
    }

    private static void visitForLikelyPropertyNames(Node node, Set<String> set) {
        Object object;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                object = (Element)node;
                String string = object.getTagName();
                if (string.equals("property")) {
                    String string2 = object.getAttribute("name");
                    if (string2 != null && string2.length() > 0) {
                        set.add(string2);
                    }
                } else if (string.equals("buildnumber")) {
                    set.add("build.number");
                } else if (string.equals("tstamp")) {
                    set.add("DSTAMP");
                    set.add("TSTAMP");
                    set.add("TODAY");
                }
                for (int i = 0; i < PROPERTY_NAME_VALUED_PROPERTY_NAMES.length; ++i) {
                    String string3 = object.getAttribute(PROPERTY_NAME_VALUED_PROPERTY_NAMES[i]);
                    if (string3 == null || string3.length() <= 0) continue;
                    set.add(string3);
                }
                break;
            }
            case 2: 
            case 3: {
                int n;
                int n2;
                String string = AntGrammar.deletedEscapedShells(node.getNodeValue());
                int n3 = 0;
                while ((n2 = string.indexOf("${", n3)) != -1 && (n = string.indexOf(125, n2 + 2)) != -1) {
                    String string4 = string.substring(n2 + 2, n);
                    if (string4.length() > 0) {
                        set.add(string4);
                    }
                    n3 = n + 1;
                }
                break;
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            AntGrammar.visitForLikelyPropertyNames(object.item(i), set);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                AntGrammar.visitForLikelyPropertyNames(namedNodeMap.item(i), set);
            }
        }
    }

    private static String deletedEscapedShells(String string) {
        return string.replaceAll("\\$\\$", "");
    }

    public GrammarResult queryDefault(HintContext hintContext) {
        return null;
    }

    public boolean isAllowed(Enumeration<GrammarResult> enumeration) {
        return true;
    }

    public Component getCustomizer(HintContext hintContext) {
        return null;
    }

    public boolean hasCustomizer(HintContext hintContext) {
        return false;
    }

    public Node.Property[] getProperties(HintContext hintContext) {
        return null;
    }

    private static class MyText
    extends AbstractResultNode
    implements Text {
        private String data;

        MyText(String string) {
            this.data = string;
        }

        public short getNodeType() {
            return 3;
        }

        public String getNodeValue() {
            return this.data;
        }

        public String getData() throws DOMException {
            return this.data;
        }

        public int getLength() {
            return this.data == null ? -1 : this.data.length();
        }

        public String toString() {
            return this.data;
        }

        public String getDisplayName() {
            return this.data;
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String string) {
            this.name = string;
        }

        public short getNodeType() {
            return 2;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;

        MyElement(String string) {
            this.name = string;
        }

        public short getNodeType() {
            return 1;
        }

        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String string) {
            this.name = string;
        }

        public short getNodeType() {
            return 5;
        }

        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int n) {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public boolean isEmptyElement() {
            return false;
        }
    }

    static class ElementType {
        final Kind kind;
        final String name;

        ElementType(Kind kind, String string) {
            this.kind = kind;
            this.name = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        TASK,
        TYPE,
        DATA,
        PROJECT,
        TARGET,
        DESCRIPTION,
        IMPORT;

    }
}

