/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.bpel.core.wizard.NewBpelFilePanel;
import org.netbeans.modules.bpel.core.wizard.Utilities;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class NewBpelFileIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    public static final Dimension PREF_SIZE = new Dimension(560, 350);
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private WizardDescriptor.Panel folderPanel;
    private transient SourceGroup[] sourceGroups;

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        JComponent jComponent;
        WizardDescriptor.Panel panel;
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        this.sourceGroups = sources.getSourceGroups("BIZPRO");
        if (this.sourceGroups.length == 0) {
            this.sourceGroups = sources.getSourceGroups("java");
        }
        this.folderPanel = new NewBpelFilePanel(project, this.sourceGroups);
        if (this.sourceGroups.length > 0 && this.sourceGroups[0] != null) {
            panel = DataFolder.findFolder((FileObject)this.sourceGroups[0].getRootFolder());
            jComponent = DataFolder.findFolder((FileObject)project.getProjectDirectory());
            try {
                if (templateWizard.getTargetFolder().equals(jComponent)) {
                    templateWizard.setTargetFolder((DataFolder)panel);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])this.sourceGroups, (WizardDescriptor.Panel)this.folderPanel);
        jComponent = (JComponent)panel.getComponent();
        String string = NbBundle.getMessage(NewBpelFileIterator.class, (String)"LBL_SimpleTargetChooserPanel_FileName_Label");
        ((NewBpelFilePanel)this.folderPanel).setNameTF((JTextField)Utilities.findTextFieldForLabel(jComponent, string));
        return new WizardDescriptor.Panel[]{panel};
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        NewBpelFilePanel newBpelFilePanel = (NewBpelFilePanel)this.folderPanel;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataObject dataObject = this.createBpelFile(Templates.getTargetName((WizardDescriptor)templateWizard), fileObject, newBpelFilePanel.getNS());
        if (dataObject == null) {
            return Collections.emptySet();
        }
        SoaUiUtil.fixEncoding((DataObject)dataObject, (FileObject)fileObject);
        return Collections.singleton(dataObject);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(NewBpelFileIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private DataObject createBpelFile(String string, FileObject fileObject, String string2) throws IOException {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
        boolean bl = false;
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wiz));
        this.initialiseNames(dataObject2.getPrimaryFile(), string, string2, "url1");
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseNames(FileObject fileObject, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = System.getProperty("line.separator");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
            try {
                String string5;
                while ((string5 = bufferedReader.readLine()) != null) {
                    string5 = string5.replace("_PROCNAME_", string);
                    string5 = string5.replace("_NS_", string2);
                    string5 = string5.replace("_URL_", string3);
                    stringBuffer.append(string5);
                    stringBuffer.append(string4);
                }
            }
            finally {
                bufferedReader.close();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(), FileEncodingQuery.getDefaultEncoding()));
            try {
                bufferedWriter.write(stringBuffer.toString());
            }
            finally {
                ((Writer)bufferedWriter).close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }
}

