/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.util;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.bpel.core.util.BPELValidationController;
import org.netbeans.modules.bpel.core.util.WeakTriggerListener;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExternalModelsValidationTrigger
implements ChangeEventListener {
    private BPELValidationController myController;
    private AtomicBoolean isTriggerDirty;
    private WeakTriggerListener myListener;
    private boolean importsLoaded;

    ExternalModelsValidationTrigger(BPELValidationController bPELValidationController) {
        this.myController = bPELValidationController;
        this.isTriggerDirty = new AtomicBoolean(false);
        this.myListener = new WeakTriggerListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
        BpelEntity bpelEntity = arrayUpdateEvent.getParent();
        BpelEntity[] bpelEntityArray = arrayUpdateEvent.getNewArray();
        BpelEntity[] bpelEntityArray2 = arrayUpdateEvent.getOldArray();
        if (!(bpelEntity instanceof Process)) {
            return;
        }
        if (bpelEntityArray2 != null && bpelEntityArray2.length > 0) {
            if (!(bpelEntityArray2[0] instanceof Import)) return;
            for (BpelEntity bpelEntity2 : bpelEntityArray2) {
                Import import_ = (Import)bpelEntity2;
                Collection<Model> collection = this.getModels(import_);
                for (Model model : collection) {
                    this.removeListener(model);
                }
            }
            this.loadImports();
            return;
        } else {
            if (bpelEntityArray == null || bpelEntityArray.length <= 0) return;
            if (!(bpelEntityArray[0] instanceof Import)) return;
            this.loadImports();
        }
    }

    public void notifyEntityInserted(EntityInsertEvent entityInsertEvent) {
        BpelEntity bpelEntity = entityInsertEvent.getParent();
        BpelEntity bpelEntity2 = entityInsertEvent.getValue();
        if (bpelEntity instanceof Process && bpelEntity2 instanceof Import) {
            Import import_ = (Import)bpelEntity2;
            Collection<Model> collection = this.getModels(import_);
            for (Model model : collection) {
                this.addListener(model);
            }
        }
    }

    public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
        BpelEntity bpelEntity = entityRemoveEvent.getParent();
        BpelEntity bpelEntity2 = entityRemoveEvent.getOldValue();
        if (bpelEntity instanceof Process && bpelEntity2 instanceof Import) {
            Import import_ = (Import)bpelEntity2;
            Collection<Model> collection = this.getModels(import_);
            for (Model model : collection) {
                this.removeListener(model);
            }
        }
    }

    public void notifyEntityUpdated(EntityUpdateEvent entityUpdateEvent) {
        BpelEntity bpelEntity = entityUpdateEvent.getParent();
        BpelEntity bpelEntity2 = entityUpdateEvent.getOldValue();
        BpelEntity bpelEntity3 = entityUpdateEvent.getNewValue();
        if (bpelEntity instanceof Process && (bpelEntity2 instanceof Import || bpelEntity3 instanceof Import)) {
            Import import_ = (Import)bpelEntity2;
            Import import_2 = (Import)bpelEntity3;
            Collection<Model> collection = this.getModels(import_);
            for (Model model : collection) {
                this.removeListener(model);
            }
            collection = this.getModels(import_2);
            for (Model model : collection) {
                this.addListener(model);
            }
        }
    }

    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
        BpelEntity bpelEntity = propertyRemoveEvent.getParent();
        if (bpelEntity instanceof Import) {
            Import import_ = (Import)bpelEntity;
            Collection<Model> collection = this.getOldModels(import_, propertyRemoveEvent.getName(), propertyRemoveEvent.getOldValue());
            this.reloadImport(import_, collection);
        }
    }

    public void notifyPropertyUpdated(PropertyUpdateEvent propertyUpdateEvent) {
        Object object;
        BpelEntity bpelEntity = propertyUpdateEvent.getParent();
        if (bpelEntity instanceof Import) {
            Import import_ = (Import)bpelEntity;
            Collection<Model> collection = this.getOldModels(import_, propertyUpdateEvent.getName(), propertyUpdateEvent.getOldValue());
            this.reloadImport(import_, collection);
        } else if ("<state>".equals(propertyUpdateEvent.getName()) && Model.State.VALID.equals(object = propertyUpdateEvent.getNewValue()) && !this.importsLoaded) {
            this.loadImports();
        }
    }

    void clearTrigger() {
        Runnable runnable = new Runnable(){

            public void run() {
                Import[] importArray;
                ExternalModelsValidationTrigger.this.importsLoaded = false;
                Process process = ExternalModelsValidationTrigger.this.getController().getModel().getProcess();
                if (process == null) {
                    return;
                }
                ExternalModelsValidationTrigger.this.isTriggerDirty.set(false);
                for (Import import_ : importArray = process.getImports()) {
                    Collection collection = ExternalModelsValidationTrigger.this.getModels(import_);
                    for (Model model : collection) {
                        ExternalModelsValidationTrigger.this.removeListener(model);
                    }
                }
            }
        };
        this.getController().getModel().invoke(runnable);
    }

    void loadImports() {
        Runnable runnable = new Runnable(){

            public void run() {
                Import[] importArray;
                Process process = ExternalModelsValidationTrigger.this.getController().getModel().getProcess();
                if (process == null) {
                    ExternalModelsValidationTrigger.this.importsLoaded = false;
                    return;
                }
                ExternalModelsValidationTrigger.this.isTriggerDirty.set(false);
                ExternalModelsValidationTrigger.this.importsLoaded = true;
                for (Import import_ : importArray = process.getImports()) {
                    Collection collection = ExternalModelsValidationTrigger.this.getModels(import_);
                    for (Model model : collection) {
                        ExternalModelsValidationTrigger.this.addListener(model);
                    }
                }
            }
        };
        this.getController().getModel().invoke(runnable);
    }

    void changeHappened() {
        this.isTriggerDirty.compareAndSet(false, true);
    }

    boolean isTriggerDirty() {
        return this.isTriggerDirty.getAndSet(false);
    }

    private void reloadImport(Import import_, Collection<Model> collection) {
        for (Model object2 : collection) {
            this.removeListener(object2);
        }
        Collection<Model> collection2 = this.getModels(import_);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            this.addListener(model);
        }
    }

    private Collection<Model> getOldModels(Import import_, String string, Object object) {
        Collection collection;
        LinkedList<Model> linkedList = new LinkedList<Model>();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if ("importType".equals(string)) {
            assert (object instanceof String);
            string2 = import_.getLocation();
            string3 = (String)object;
            string4 = import_.getNamespace();
        } else if ("location".equals(string)) {
            assert (object instanceof String);
            string2 = (String)object;
            string3 = import_.getImportType();
            string4 = import_.getNamespace();
        } else if ("namespace".equals(string)) {
            assert (object instanceof String);
            string2 = import_.getLocation();
            string3 = import_.getImportType();
            string4 = (String)object;
        }
        WSDLModel wSDLModel = ImportHelper.getWsdlModel((BpelModel)this.getController().getModel(), (String)string2, (String)string3);
        if (wSDLModel != null) {
            linkedList.add((Model)wSDLModel);
        }
        if ((wSDLModel = ImportHelper.getSchemaModel((BpelModel)this.getController().getModel(), (String)string2, (String)string3)) != null) {
            linkedList.add((Model)wSDLModel);
        }
        if ((collection = ImportHelper.getInlineSchema((BpelModel)this.getController().getModel(), (String)string4, (String)string2, (String)string3)) != null) {
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    private void addListener(Model model) {
        model.addComponentListener((ComponentListener)this.getListener());
        model.addPropertyChangeListener((PropertyChangeListener)this.getListener());
    }

    private void removeListener(Model model) {
        model.removeComponentListener((ComponentListener)this.getListener());
        model.removePropertyChangeListener((PropertyChangeListener)this.getListener());
    }

    private BPELValidationController getController() {
        return this.myController;
    }

    private Collection<Model> getModels(Import import_) {
        Collection collection;
        String string;
        SchemaModel schemaModel;
        if (import_ == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Model> linkedList = new LinkedList<Model>();
        WSDLModel wSDLModel = ImportHelper.getWsdlModel((Import)import_);
        if (wSDLModel != null) {
            linkedList.add((Model)wSDLModel);
        }
        if ((schemaModel = ImportHelper.getSchemaModel((Import)import_)) != null) {
            linkedList.add((Model)schemaModel);
        }
        if ((string = import_.getNamespace()) != null && (collection = ImportHelper.getInlineSchema((Import)import_, (String)string)) != null) {
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    private WeakTriggerListener getListener() {
        return this.myListener;
    }
}

