/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.freeform;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.freeform.Util;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.NBHTMLLabel;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FreeFormProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String ERROR_PARSING_BUILDFILE_MSG = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_ErrorParsingBuildFileMsg");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_OkButtonName");
    private static final String SELECT_PROFILING_TASK_DIALOG_CAPTION = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectProfilingTaskDialogCaption");
    private static final String NO_PROFILER_TASK_MSG = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_NoProfilerTaskMsg");
    private static final String SELECT_TARGET_ITEM_STRING = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectTargetItemString");
    private static final String SELECT_PROJECT_TASK_LABEL_STRING = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectProjectTaskLabelString");
    private static final String SELECT_FILE_TASK_LABEL_STRING = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_SelectFileTaskLabelString");
    private static final String CREATE_NEW_TARGET_MSG = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_CreateNewTargetMsg");
    private static final String TARGET_BOX_ACCESS_NAME = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_TargetBoxAccessName");
    private static final String TARGET_BOX_ACCESS_DESCR = NbBundle.getMessage((Class)FreeFormProjectTypeProfiler.class, (String)"FreeFormProjectTypeProfiler_TargetBoxAccessDescr");
    private static final String FREEFORM_PROJECT_NAMESPACE_40 = "http://www.netbeans.org/ns/freeform-project/1";
    private static final String FREEFORM_PROJECT_NAMESPACE_41 = "http://www.netbeans.org/ns/freeform-project/2";
    private static final String PROFILE_TARGET_ATTRIBUTE = "profile-target";
    private static final String PROFILE_SINGLE_TARGET_ATTRIBUTE = "profile-file-target";
    private static final String PROFILE_VERSION_ATTRIBUTE = "version";
    private static final String VERSION_NUMBER = "0.4";

    public String getProfilerTargetName(Project project, FileObject fileObject, int n, FileObject fileObject2) {
        Element element = ((AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class)).getConfigurationFragment("data", "http://www.netbeans.org/ns/profiler/1", false);
        String string = element.getAttribute(PROFILE_TARGET_ATTRIBUTE);
        String string2 = element.getAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE);
        switch (n) {
            case 1: {
                string = this.selectProfilingTarget(project, fileObject, 1, string);
                if (string == null) {
                    return null;
                }
                this.saveProfilerConfig(project, string, string2);
                return string;
            }
            case 2: {
                string2 = this.selectProfilingTarget(project, fileObject, 2, string2);
                if (string2 == null) {
                    return null;
                }
                this.saveProfilerConfig(project, string, string2);
                return string2;
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration == null) {
            ProfilerLogger.severe((String)("Auxiliary Configuration is null for Project: " + project));
            return false;
        }
        Element element = auxiliaryConfiguration.getConfigurationFragment("general-data", FREEFORM_PROJECT_NAMESPACE_40, true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("general-data", FREEFORM_PROJECT_NAMESPACE_41, true);
        }
        return element != null;
    }

    public FileObject getProjectBuildScript(Project project) {
        return Util.getProjectBuildScript(project);
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject fileObject) {
        return true;
    }

    public boolean checkProjectIsModifiedForProfiler(Project project) {
        Element element = ((AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class)).getConfigurationFragment("data", "http://www.netbeans.org/ns/profiler/1", false);
        if (element != null) {
            String string = element.getAttribute(PROFILE_TARGET_ATTRIBUTE);
            String string2 = element.getAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE);
            if (string != null || string2 != null) {
                return true;
            }
        } else {
            this.saveProfilerConfig(project, null, null);
        }
        return true;
    }

    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
        if (fileObject != null) {
            String string = SourceUtils.getToplevelClassName((FileObject)fileObject);
            properties.setProperty("profile.class", string);
            String string2 = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)fileObject), (FileObject)fileObject);
            properties.setProperty("javac.includes", string2);
        }
    }

    private boolean checkTarget(Element element) {
        NodeList nodeList = element.getElementsByTagName("nbprofiledirect");
        return nodeList.getLength() > 0;
    }

    private boolean saveProfilerConfig(Project project, String string, String string2) {
        Element element = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS("http://www.netbeans.org/ns/profiler/1", "data");
        element.setAttribute(PROFILE_VERSION_ATTRIBUTE, VERSION_NUMBER);
        if (string != null) {
            element.setAttribute(PROFILE_TARGET_ATTRIBUTE, string);
        }
        if (string2 != null) {
            element.setAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE, string2);
        }
        ((AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class)).putConfigurationFragment(element, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException iOException) {
            Profiler.getDefault().notifyException(8, (Exception)iOException);
            ProfilerLogger.log((Exception)iOException);
            return false;
        }
        return true;
    }

    private String selectProfilingTarget(Project project, FileObject fileObject, int n, String string) {
        block5: {
            String string2;
            List list = Util.getAntScriptTargets(fileObject);
            List list2 = Util.getAntScriptTargetNames(fileObject);
            if (list2 == null) {
                Profiler.getDefault().displayError(MessageFormat.format(ERROR_PARSING_BUILDFILE_MSG, ProjectUtils.getInformation((Project)project).getName()));
                return null;
            }
            if (!"".equals(string) && list2.contains(string)) {
                return string;
            }
            JButton jButton = new JButton(OK_BUTTON_NAME);
            AntTaskSelectPanel antTaskSelectPanel = new AntTaskSelectPanel(list2, n, jButton);
            block0: while (true) {
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)antTaskSelectPanel, SELECT_PROFILING_TASK_DIALOG_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
                Dialog dialog = ProfilerDialogs.createDialog((DialogDescriptor)dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() != jButton) break block5;
                string2 = antTaskSelectPanel.getTargetName();
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    TargetLister.Target target = (TargetLister.Target)iterator.next();
                    if (!target.getName().equals(string2)) continue;
                    if (this.checkTarget(target.getElement())) {
                        return string2;
                    }
                    if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NO_PROFILER_TASK_MSG, 2, 2)) == NotifyDescriptor.OK_OPTION) break block0;
                }
                break;
            }
            return string2;
        }
        return null;
    }

    private static final class AntTaskSelectPanel
    extends JPanel
    implements HelpCtx.Provider {
        private static final String HELP_CTX_KEY = "FreeFormProjectTypeProfiler.AntTaskSelectPanel.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("FreeFormProjectTypeProfiler.AntTaskSelectPanel.HelpCtx");
        final JComboBox targetBox;
        final JLabel label;
        final NBHTMLLabel descriptionLabel;

        AntTaskSelectPanel(List list, int n, final JButton jButton) {
            list.add(0, SELECT_TARGET_ITEM_STRING);
            this.label = n == 1 ? new JLabel(SELECT_PROJECT_TASK_LABEL_STRING) : new JLabel(SELECT_FILE_TASK_LABEL_STRING);
            this.descriptionLabel = new NBHTMLLabel(CREATE_NEW_TARGET_MSG);
            this.targetBox = new JComboBox<Object>(list.toArray(new Object[list.size()]));
            this.targetBox.setSelectedIndex(0);
            this.targetBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    jButton.setEnabled(AntTaskSelectPanel.this.targetBox.getSelectedIndex() != 0);
                }
            });
            this.setLayout(new GridBagLayout());
            this.label.setLabelFor(this.targetBox);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 12, 12, 12);
            this.add((Component)this.label, gridBagConstraints);
            this.targetBox.getAccessibleContext().setAccessibleName(TARGET_BOX_ACCESS_NAME);
            this.targetBox.getAccessibleContext().setAccessibleDescription(TARGET_BOX_ACCESS_DESCR);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 12, 12);
            this.add((Component)this.targetBox, gridBagConstraints);
            this.descriptionLabel.setFocusable(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(12, 12, 12, 12);
            this.add((Component)this.descriptionLabel, gridBagConstraints);
            jButton.setEnabled(false);
        }

        public String getTargetName() {
            if (this.targetBox.getSelectedIndex() == 0) {
                return null;
            }
            return (String)this.targetBox.getSelectedItem();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }
}

