/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.customizer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.UpdateHelper;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.rubyproject.JavaClassPathUi;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ui.StoreGroup;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsProjectProperties
extends SharedRubyProjectProperties {
    public static final String RAILS_PORT = "rails.port";
    public static final String RAILS_SERVERTYPE = "rails.servertype";
    public static final String RAILS_ENV = "rails.env";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String MAIN_CLASS = "main.file";
    public static final String JAVAC_COMPILER_ARG = "javac.compilerargs";
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String RUN_CLASSPATH = "run.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    public static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    public static final String BUILD_TEST_RESULTS_DIR = "build.test.results.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String DEBUG_TEST_CLASSPATH = "debug.test.classpath";
    public static final String APPLICATION_ARGS = "application.args";
    Document JAVAC_COMPILER_ARG_MODEL;
    Map<String, Map<String, String>> RUN_CONFIGS;
    String activeConfig;
    private Map<String, String> additionalProperties;
    private RailsProject project;
    private HashMap properties;
    private UpdateHelper updateHelper;
    private PropertyEvaluator evaluator;
    private ReferenceHelper refHelper;
    private GeneratedFilesHelper genFileHelper;
    private ProjectPropertyExtender cs;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    private RubyPlatform platform;
    private RubyInstance server;
    private String railsEnvironment;
    public static final String[] WELL_KNOWN_PATHS = new String[]{"${javac.classpath}"};
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";

    RailsProject getProject() {
        return this.project;
    }

    public RailsProjectProperties(RailsProject railsProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        this.project = railsProject;
        this.updateHelper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.genFileHelper = generatedFilesHelper;
        this.cs = new ProjectPropertyExtender(propertyEvaluator, referenceHelper, updateHelper.getRakeProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new HashMap<String, String>();
        this.init();
    }

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new JavaClassPathUi.ClassPathListCellRenderer(this.evaluator);
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        String string = (String)editableProperties.get((Object)"javac.classpath");
        this.JAVAC_CLASSPATH_MODEL = RailsProjectProperties.createListModel(this.cs.itemsIterator(string));
        this.INCLUDE_JAVA_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "ruby.includejava");
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVAC_COMPILER_ARG);
        this.RUN_CONFIGS = this.readRunConfigs();
        this.activeConfig = this.evaluator.getProperty("config");
    }

    public static DefaultListModel createListModel(Iterator iterator) {
        DefaultListModel defaultListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    public static Iterator<ProjectPropertyExtender.Item> getIterator(DefaultListModel defaultListModel) {
        return RailsProjectProperties.getList(defaultListModel).iterator();
    }

    public static List<ProjectPropertyExtender.Item> getList(DefaultListModel defaultListModel) {
        return Collections.list(defaultListModel.elements());
    }

    public void save() {
        try {
            Boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){
                final FileObject projectDir;
                {
                    this.projectDir = RailsProjectProperties.this.updateHelper.getRakeProjectHelper().getProjectDirectory();
                }

                public Boolean run() throws IOException {
                    if ((RailsProjectProperties.this.genFileHelper.getBuildScriptState("nbproject/build-impl.xml", RailsProject.class.getResource("resources/build-impl.xsl")) & 4) == 4) {
                        if (RailsProjectProperties.showModifiedMessage(NbBundle.getMessage(RailsProjectProperties.class, (String)"TXT_ModifiedTitle"))) {
                            FileObject fileObject = this.projectDir.getFileObject("nbproject/build-impl.xml");
                            if (fileObject != null) {
                                fileObject.delete();
                            }
                        } else {
                            return false;
                        }
                    }
                    RailsProjectProperties.this.storeProperties();
                    return true;
                }
            });
            if (bl == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void storeProperties() throws IOException {
        String[] stringArray = this.cs.encodeToStrings(RailsProjectProperties.getIterator(this.JAVAC_CLASSPATH_MODEL));
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.updateHelper.getProperties("nbproject/private/private.properties");
        RailsProjectProperties.storePlatform(editableProperties2, this.getPlatform());
        RailsProjectProperties.storeServer(editableProperties2, this.getServer());
        if (this.getRailsEnvironment() != null) {
            editableProperties2.setProperty(RAILS_ENV, this.getRailsEnvironment());
        }
        this.projectGroup.store(editableProperties);
        this.privateGroup.store(editableProperties2);
        this.storeRunConfigs(this.RUN_CONFIGS, editableProperties, editableProperties2);
        EditableProperties editableProperties3 = this.updateHelper.getProperties("nbproject/private/config.properties");
        if (this.activeConfig == null) {
            editableProperties3.remove((Object)"config");
        } else {
            editableProperties3.setProperty("config", this.activeConfig);
        }
        this.updateHelper.putProperties("nbproject/private/config.properties", editableProperties3);
        editableProperties.setProperty("javac.classpath", stringArray);
        editableProperties.putAll(this.additionalProperties);
        this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        String string = this.additionalProperties.get("source.encoding");
        if (string != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(string));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    public void putAdditionalProperty(String string, String string2) {
        this.additionalProperties.put(string, string2);
    }

    private static boolean showModifiedMessage(String string) {
        String string2 = NbBundle.getMessage(RailsProjectProperties.class, (String)"TXT_Regenerate");
        JButton jButton = new JButton(NbBundle.getMessage(RailsProjectProperties.class, (String)"CTL_RegenerateButton"));
        jButton.setDefaultCapable(true);
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
        message.setTitle(string);
        message.setOptionType(2);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton;
    }

    RubyPlatform getPlatform() {
        if (this.platform == null) {
            this.platform = RubyPlatform.platformFor((Project)this.project);
        }
        return this.platform;
    }

    void setPlatform(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    public static void storePlatform(EditableProperties editableProperties, RubyPlatform rubyPlatform) {
        editableProperties.setProperty(JAVA_PLATFORM, rubyPlatform.getID());
    }

    RubyInstance getServer() {
        return this.server;
    }

    void setServer(RubyInstance rubyInstance) {
        this.server = rubyInstance;
    }

    public static void storeServer(EditableProperties editableProperties, RubyInstance rubyInstance) {
        editableProperties.setProperty(RAILS_SERVERTYPE, rubyInstance.getServerUri());
    }

    String getRailsEnvironment() {
        return this.railsEnvironment;
    }

    void setRailsEnvironment(String string) {
        this.railsEnvironment = string;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string != null ? (string2 != null ? string.compareTo(string2) : 1) : (string2 != null ? -1 : 0);
            }
        });
        TreeMap<String, void> treeMap2 = new TreeMap<String, void>();
        for (String string : new FileObject[]{RAILS_PORT, RAILS_SERVERTYPE, "rake.args", RAILS_ENV, MAIN_CLASS, APPLICATION_ARGS, RUN_JVM_ARGS}) {
            void string2;
            String string3 = this.updateHelper.getProperties("nbproject/private/private.properties").getProperty(string);
            if (string3 == null) {
                String string4 = this.updateHelper.getProperties("nbproject/project.properties").getProperty(string);
            }
            if (string2 == null) continue;
            treeMap2.put(string, string2);
        }
        treeMap.put(null, treeMap2);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.hasExt("properties")) continue;
                treeMap.put(fileObject2.getName(), new TreeMap(this.updateHelper.getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject2))));
            }
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject fileObject3 : fileObject.getChildren()) {
                Map map;
                if (!fileObject3.hasExt("properties") || (map = (Map)treeMap.get(fileObject3.getName())) == null) continue;
                map.putAll(new HashMap(this.updateHelper.getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject3))));
            }
        }
        return treeMap;
    }

    void storeRunConfigs(Map<String, Map<String, String>> map, EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        Object object;
        String string;
        Map<String, String> map2 = map.get(null);
        for (String string2 : new String[]{RAILS_PORT, RAILS_SERVERTYPE, "rake.args", RAILS_ENV, MAIN_CLASS, APPLICATION_ARGS, RUN_JVM_ARGS}) {
            string = map2.get(string2);
            Object object2 = object = string2.equals(RAILS_PORT) || string2.equals("rake.args") || string2.equals(APPLICATION_ARGS) ? editableProperties2 : editableProperties;
            if (Utilities.compareObjects((Object)string, (Object)object.getProperty(string2))) continue;
            if (string != null && string.length() > 0) {
                object.setProperty(string2, string);
                continue;
            }
            object.remove((Object)string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (string3 == null) continue;
            string2 = "nbproject/configs/" + string3 + ".properties";
            string = "nbproject/private/configs/" + string3 + ".properties";
            object = (Map)entry.getValue();
            if (object == null) {
                this.updateHelper.putProperties(string2, null);
                this.updateHelper.putProperties(string, null);
                continue;
            }
            for (Map.Entry entry2 : object.entrySet()) {
                String string4;
                EditableProperties editableProperties3;
                String string5 = (String)entry2.getKey();
                String string6 = (String)entry2.getValue();
                if (Utilities.compareObjects((Object)string6, (Object)(editableProperties3 = this.updateHelper.getProperties(string4 = string5.equals(RAILS_PORT) || string5.equals("rake.args") || string5.equals(RAILS_ENV) || string5.equals(RAILS_SERVERTYPE) || string5.equals(APPLICATION_ARGS) ? string : string2)).getProperty(string5))) continue;
                if (string6 != null && (string6.length() > 0 || map2.get(string5) != null && map2.get(string5).length() > 0)) {
                    editableProperties3.setProperty(string5, string6);
                } else {
                    editableProperties3.remove((Object)string5);
                }
                this.updateHelper.putProperties(string4, editableProperties3);
            }
            this.updateHelper.putProperties(string2, this.updateHelper.getProperties(string2));
        }
    }
}

