/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.RailsJdbcConnection;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class ConfigurableRailsAdapter
implements RailsDatabaseConfiguration {
    private final RailsDatabaseConfiguration delegate;
    private final String userName;
    private final String password;
    private final String database;
    private final boolean jdbc;

    public ConfigurableRailsAdapter(RailsDatabaseConfiguration railsDatabaseConfiguration, String string, String string2, String string3, boolean bl) {
        this.delegate = railsDatabaseConfiguration;
        this.userName = string;
        this.password = string2;
        this.database = string3;
        this.jdbc = bl;
    }

    public String railsGenerationParam() {
        return this.delegate.railsGenerationParam();
    }

    public void editConfig(RailsProject railsProject) {
        this.delegate.editConfig(railsProject);
        this.edit(railsProject.getProjectDirectory());
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (this.jdbc && jdbcInfo != null) {
            RailsJdbcConnection.bundleDrivers(railsProject, jdbcInfo.getDriverClass());
        }
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    private void changeAttribute(Document document, String string, String string2) throws BadLocationException {
        Parameters.notWhitespace((CharSequence)"attributeName", (CharSequence)string);
        if (string2 == null || "".equals(string2.trim())) {
            return;
        }
        String string3 = document.getText(0, document.getLength());
        int n = string3.indexOf(string);
        if (n == -1) {
            return;
        }
        int n2 = n + string.length();
        int n3 = 0;
        for (int i = n2; i < string3.length() && string3.charAt(i) != '\n'; ++i) {
            ++n3;
        }
        document.remove(n2, n3);
        document.insertString(n2, string2 != null ? " " + string2 : "", null);
    }

    private void edit(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    this.setDatabase(styledDocument);
                    this.changeAttribute(styledDocument, "username:", this.userName);
                    this.changeAttribute(styledDocument, "password:", this.password);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void setDatabase(Document document) throws BadLocationException {
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (!this.jdbc || jdbcInfo == null) {
            this.changeAttribute(document, "database:", this.database);
            return;
        }
        String string = !this.isEmpty(this.database) ? this.database : RailsAdapters.getPropertyValue(document, "database:");
        this.changeAttribute(document, "adapter:", "jdbc");
        RailsAdapters.addProperty(document, "url:", jdbcInfo.getURL("localhost", string), "adapter:");
        RailsAdapters.addProperty(document, "driver:", jdbcInfo.getDriverClass(), "adapter:");
        RailsAdapters.removeProperty(document, "database:");
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    public JdbcInfo getJdbcInfo() {
        return this.delegate.getJdbcInfo();
    }
}

