/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.java.merging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Node;
import org.netbeans.modules.uml.codegen.java.merging.ElementDescriptor;
import org.netbeans.modules.uml.codegen.java.merging.ElementMatcher;
import org.netbeans.modules.uml.codegen.java.merging.PositionMapper;
import org.netbeans.modules.uml.core.reverseengineering.reintegration.REIntegrationUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuilder {
    public static final int HEADER_ONLY = 0;
    public static final int HEADER_AND_BODY = 1;
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final int BUFFER_SIZE = 256;
    private String newFile;
    private String oldFile;
    private String targetFile;
    private RandomAccessFile raOldFile;
    private RandomAccessFile raNewFile;
    private PositionMapper posMapper = null;
    ArrayList<ModDesc> mods = new ArrayList();

    public FileBuilder(String string, String string2) {
        this.newFile = string;
        this.oldFile = string2;
        this.targetFile = string2;
    }

    public FileBuilder(String string, String string2, String string3) {
        this.newFile = string;
        this.oldFile = string2;
        this.targetFile = string3;
    }

    public void replace(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
        this.replace(elementDescriptor, elementDescriptor2, 1);
    }

    public void replace(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, int n) {
        if (elementDescriptor == null) {
            return;
        }
        this.mods.add(new ModDesc(2, elementDescriptor, elementDescriptor2, -1L, n));
    }

    public void remove(ElementDescriptor elementDescriptor) {
        this.mods.add(new ModDesc(3, null, elementDescriptor, -1L, 1));
    }

    public void add(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
        this.add(elementDescriptor, elementDescriptor2, 0);
    }

    public void add(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, int n) {
        String string = elementDescriptor.getModelElemType();
        long l = -1L;
        List<ElementDescriptor> list = FileBuilder.getElementsSorted(elementDescriptor2, true);
        ElementDescriptor elementDescriptor3 = elementDescriptor2;
        if ("Attribute".equals(string)) {
            if (list != null && list.size() != 0) {
                elementDescriptor3 = list.get(0);
                this.mods.add(new ModDesc(0, elementDescriptor, elementDescriptor3, l, 1));
            } else {
                l = this.getSrcTopPosition(elementDescriptor2, true);
                this.mods.add(new ModDesc(4, elementDescriptor, elementDescriptor3, l, 1));
            }
        } else if ("EnumerationLiteral".equals(string)) {
            l = this.getSrcTopPosition(elementDescriptor2, false);
            this.mods.add(new ModDesc(4, elementDescriptor, elementDescriptor3, l, 1, -2 + n));
        } else {
            if (list != null && list.size() != 0) {
                elementDescriptor3 = list.get(list.size() - 1);
            } else {
                l = this.getSrcTopPosition(elementDescriptor2, true);
            }
            this.mods.add(new ModDesc(4, elementDescriptor, elementDescriptor3, l, 1));
        }
    }

    public void insert(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, boolean bl) {
        if (bl) {
            this.mods.add(new ModDesc(4, elementDescriptor, elementDescriptor2, -1L, 1));
        } else {
            this.mods.add(new ModDesc(0, elementDescriptor, elementDescriptor2, -1L, 1));
        }
    }

    public void insert(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, boolean bl, int n) {
        if (bl) {
            this.mods.add(new ModDesc(4, elementDescriptor, elementDescriptor2, -1L, 1, n));
        } else {
            this.mods.add(new ModDesc(0, elementDescriptor, elementDescriptor2, -1L, 1, n));
        }
    }

    public void insertLiteralSectionTerminator(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
        long l = this.getSrcTopPosition(elementDescriptor2, true);
        ModDesc modDesc = new ModDesc(4, elementDescriptor.getPosition("Literal Section Terminator"), elementDescriptor.getPosition("Literal Section Terminator"), -1L, -1L, l, 1, -1, ";", true);
        this.mods.add(modDesc);
    }

    public void removeLiteralSectionTerminator(ElementDescriptor elementDescriptor) {
        ModDesc modDesc = new ModDesc(3, -1L, -1L, elementDescriptor.getPosition("Literal Section Terminator"), elementDescriptor.getPosition("Literal Section Terminator") + 1L, elementDescriptor.getPosition("Literal Section Terminator"), 1, -1, null, true);
        this.mods.add(modDesc);
    }

    public void completed() throws IOException {
        this.removeInvalid(this.mods);
        String string = REIntegrationUtil.getEncoding((String)this.newFile);
        this.processNewFile(this.newFile, string);
        string = REIntegrationUtil.getEncoding((String)this.oldFile);
        File file = new File(this.targetFile);
        File file2 = new File(this.oldFile);
        if (file != null && !file.equals(file2)) {
            this.mergeOldFile(this.oldFile, this.targetFile, string);
        } else {
            String string2 = file2.getName();
            String string3 = System.getProperty("java.io.tmpdir");
            File file3 = File.createTempFile(string2, null, new File(new File(string3).getCanonicalPath()));
            this.mergeOldFile(this.oldFile, file3.getCanonicalPath(), string);
            FileBuilder.copyFile(file3, file2);
            file3.delete();
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file == null || !file.exists() || file2 == null) {
            return;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(FileUtil.toFileObject((File)file).getInputStream());
        if (!file2.exists()) {
            FileUtil.createData((File)file2);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(FileUtil.toFileObject((File)file2).getOutputStream());
        byte[] byArray = new byte[8192];
        int n = bufferedInputStream.read(byArray);
        while (n > -1) {
            bufferedOutputStream.write(byArray, 0, n);
            n = bufferedInputStream.read(byArray);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    private long getInsertPosition(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
        String string = elementDescriptor.getModelElemType();
        long l = -1L;
        l = "Attribute".equals(string) ? this.getSrcTopPosition(elementDescriptor2, true) : ("EnumerationLiteral".equals(string) ? this.getSrcTopPosition(elementDescriptor2, false) : elementDescriptor2.getEndPos());
        return l;
    }

    private long getSrcTopPosition(ElementDescriptor elementDescriptor, boolean bl) {
        long l = -1L;
        if (bl) {
            l = elementDescriptor.getPosition("Literal Section Terminator");
            if (l > -1L) {
                return l;
            }
            List<ElementDescriptor> list = FileBuilder.getElementsSorted(elementDescriptor, false);
            if (list != null && list.size() != 0 && (l = list.get(list.size() - 1).getEndPos()) > -1L) {
                return l;
            }
        }
        return elementDescriptor.getPosition("Body Start");
    }

    private static List<ElementDescriptor> getElementsSorted(ElementDescriptor elementDescriptor, boolean bl) {
        ArrayList<ElementDescriptor> arrayList = new ArrayList<ElementDescriptor>();
        List list = elementDescriptor.getOwnedElements(bl);
        if (list == null) {
            return null;
        }
        for (Object e : list) {
            if (!(e instanceof Node)) continue;
            arrayList.add(new ElementDescriptor((Node)e));
        }
        Collections.sort(arrayList, new Comparator<ElementDescriptor>(){

            @Override
            public int compare(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
                long l = FileBuilder.getElemStartPosition(elementDescriptor);
                long l2 = FileBuilder.getElemStartPosition(elementDescriptor2);
                return (int)(l - l2);
            }
        });
        return arrayList;
    }

    private byte[] getIndentation(ElementDescriptor elementDescriptor) {
        String string = "";
        if (elementDescriptor != null) {
            int n = elementDescriptor.getColumn("StartPosition") - 1;
            for (int i = 0; n > 0 && i < n; ++i) {
                string = string + SPACE;
            }
        }
        return string.getBytes();
    }

    private static long getElemStartPosition(ElementDescriptor elementDescriptor) {
        long l;
        long l2 = elementDescriptor.getStartPos();
        long l3 = elementDescriptor.getPosition("Comment");
        if (l3 > -1L && elementDescriptor.getLength("Comment") > 0) {
            l2 = l3;
        }
        if ((l = elementDescriptor.getPosition("Marker-Comment")) > -1L && elementDescriptor.getLength("Marker-Comment") > 0 && l < l2) {
            l2 = l;
        }
        return l2;
    }

    private static long getElemEndPosition(ElementDescriptor elementDescriptor) {
        String string = elementDescriptor.getModelElemType();
        long l = -1L;
        l = elementDescriptor.getEndPos();
        return l;
    }

    private static long getElemHeaderEndPosition(ElementDescriptor elementDescriptor) {
        String string = elementDescriptor.getModelElemType();
        long l = elementDescriptor.getPosition("Body Start") - 1L;
        if (l < 0L) {
            l = elementDescriptor.getEndPos();
        }
        return l;
    }

    private File createTempFile(String string) throws IOException {
        File file = null;
        if (string != null && string.length() > 0) {
            file = File.createTempFile(string, null, null);
        }
        return file;
    }

    private void processNewFile(String string, String string2) throws IOException {
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader((InputStream)new FileInputStream(string), string2) : new InputStreamReader(new FileInputStream(string));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Collections.sort(this.mods, new NewStartModDescComparator());
        long l = -1L;
        block0: for (ModDesc modDesc : this.mods) {
            if (modDesc.type == 3) continue;
            long l2 = -1L;
            if (modDesc.type == 2 && modDesc.newElem != null && modDesc.oldElem != null && modDesc.oldElem.getPosition("Marker-regenbody") > -1L && modDesc.newElem.getPosition("Marker-regenbody") == -1L && ElementMatcher.isMarked(modDesc.newElem.getNode())) {
                l2 = modDesc.newElem.getPosition("Marker-regen") + (long)modDesc.newElem.getLength("Marker-regen");
            }
            StringBuffer stringBuffer = new StringBuffer();
            long l3 = ++l;
            int n = bufferedReader.read();
            long l4 = l;
            long l5 = -1L;
            if (l == 0L) {
                stringBuffer.append(System.getProperty("line.separator"));
                l5 = 0L;
            }
            while (n > -1) {
                if (l < modDesc.newStart) {
                    if (Character.isWhitespace((char)n)) {
                        stringBuffer.append((char)n);
                        if (l5 == -1L && Character.getType((char)n) == 13) {
                            l5 = l;
                        }
                    } else {
                        stringBuffer.setLength(0);
                        l4 = l + 1L;
                        l5 = -1L;
                    }
                } else {
                    if (l > modDesc.newEnd) continue block0;
                    stringBuffer.append((char)n);
                    if (l == modDesc.newEnd) {
                        String string3 = l5 != -1L ? stringBuffer.substring((int)(l5 - l4)) : stringBuffer.substring(0);
                        modDesc.storePatchContent(string3);
                        continue block0;
                    }
                    if (l2 > -1L && l == l2) {
                        stringBuffer.append(",regenBody=yes");
                    }
                }
                ++l;
                n = bufferedReader.read();
            }
        }
        bufferedReader.close();
    }

    private void mergeOldFile(String string, String string2, String string3) throws IOException {
        OutputStreamWriter outputStreamWriter;
        InputStreamReader inputStreamReader;
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(string2));
        if (fileObject == null) {
            throw new IOException();
        }
        OutputStream outputStream = fileObject2 != null ? fileObject2.getOutputStream() : new FileOutputStream(string2);
        if (string3 != null) {
            inputStreamReader = new InputStreamReader(fileObject.getInputStream(), string3);
            outputStreamWriter = new OutputStreamWriter(outputStream, string3);
        } else {
            inputStreamReader = new InputStreamReader(fileObject.getInputStream());
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        Collections.sort(this.mods, new OldEdPointModDescComparator());
        long l = -1L;
        long l2 = -1L;
        int n = -1;
        long l3 = -1L;
        long l4 = -1L;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ModDesc> iterator = this.mods.iterator();
        ModDesc modDesc = null;
        if (iterator.hasNext()) {
            modDesc = iterator.next();
        }
        l2 = ++l;
        n = bufferedReader.read();
        l3 = l;
        l4 = -1L;
        while (n > -1) {
            if (modDesc != null) {
                if (l < modDesc.oldEdPoint) {
                    stringBuffer.append((char)n);
                    if (Character.isWhitespace((char)n) || l >= modDesc.oldStart) {
                        if (l4 == -1L && Character.getType((char)n) == 13) {
                            l4 = l;
                        }
                    } else {
                        bufferedWriter.write(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        l3 = l + 1L;
                        l4 = -1L;
                    }
                } else if (l == modDesc.oldEdPoint) {
                    long l5 = modDesc.oldEdPoint;
                    int n2 = l4 != -1L ? (int)(l4 - l3) : 0;
                    stringBuffer.append((char)n);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    bufferedWriter.write(stringBuffer.substring(0, n2));
                    stringBuffer = new StringBuffer(stringBuffer.substring(n2));
                    do {
                        if (modDesc.type == 0) {
                            bufferedWriter.write(modDesc.getPatchContent());
                            continue;
                        }
                        if (modDesc.type == 4) {
                            stringBuffer2.append(stringBuffer.substring(stringBuffer.length()));
                            bufferedWriter.write(stringBuffer.substring(0, stringBuffer.length()));
                            stringBuffer.setLength(0);
                            bufferedWriter.write(modDesc.getPatchContent());
                            continue;
                        }
                        if (modDesc.type != 2 && modDesc.type != 3) continue;
                        if (modDesc.type == 2) {
                            bufferedWriter.write(modDesc.getPatchContent());
                        }
                        stringBuffer.setLength(0);
                        while (l < modDesc.oldEnd) {
                            ++l;
                            n = bufferedReader.read();
                        }
                    } while ((modDesc = iterator.hasNext() ? iterator.next() : null) != null && (modDesc.oldEdPoint == l5 || modDesc.oldEdPoint == l));
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.write(stringBuffer2.toString());
                    stringBuffer.setLength(0);
                }
            } else {
                bufferedWriter.write((char)n);
            }
            ++l;
            n = bufferedReader.read();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    private void removeInvalid(List<ModDesc> list) {
        if (list == null) {
            return;
        }
        ArrayList<ModDesc> arrayList = new ArrayList<ModDesc>();
        for (ModDesc modDesc : list) {
            boolean bl = true;
            if (modDesc.type != 3 && (modDesc.newStart < 0L || modDesc.newEnd < 0L)) {
                bl = false;
            }
            if (modDesc.oldStart < 0L || modDesc.oldEnd < 0L || modDesc.oldEdPoint < 0L) {
                bl = false;
            }
            if (bl || modDesc.forceValid) continue;
            arrayList.add(modDesc);
        }
        for (ModDesc modDesc : arrayList) {
            list.remove(modDesc);
        }
    }

    public static class ModDesc {
        public static final int INSERT_AFTER = 4;
        public static final int INSERT_BEFORE = 0;
        public static final int REPLACE = 2;
        public static final int REMOVE = 3;
        int type;
        ElementDescriptor newElem;
        ElementDescriptor oldElem;
        long newStart;
        long newEnd;
        long oldStart;
        long oldEnd;
        long oldEdPoint;
        int scope;
        int pr = 0;
        boolean forceValid = false;
        private String patchContent;

        public ModDesc(int n, long l, long l2, long l3, long l4, long l5, int n2, int n3, String string, boolean bl) {
            this.type = n;
            this.newStart = l;
            this.newEnd = l2;
            this.oldStart = l3;
            this.oldEnd = l4;
            this.oldEdPoint = l5;
            this.scope = n2;
            this.pr = n3;
            this.patchContent = string;
            this.forceValid = bl;
        }

        public ModDesc(int n, ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, long l, int n2) {
            this.type = n;
            this.newElem = elementDescriptor;
            this.oldElem = elementDescriptor2;
            this.scope = n2;
            if (n != 3) {
                this.newStart = FileBuilder.getElemStartPosition(elementDescriptor);
                this.newEnd = n2 == 1 ? FileBuilder.getElemEndPosition(elementDescriptor) : FileBuilder.getElemHeaderEndPosition(elementDescriptor);
            } else {
                this.newStart = -1L;
                this.newEnd = -1L;
            }
            this.oldStart = FileBuilder.getElemStartPosition(elementDescriptor2);
            this.oldEnd = n2 == 1 ? FileBuilder.getElemEndPosition(elementDescriptor2) : FileBuilder.getElemHeaderEndPosition(elementDescriptor2);
            this.oldEdPoint = l == -1L ? (n != 4 ? this.oldStart : this.oldEnd) : l;
        }

        public ModDesc(int n, ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2, long l, int n2, int n3) {
            this(n, elementDescriptor, elementDescriptor2, l, n2);
            this.pr = n3;
        }

        String getPatchContent() {
            if (this.patchContent == null) {
                return "";
            }
            return this.patchContent;
        }

        void storePatchContent(String string) {
            this.patchContent = string;
            if (this.newElem != null && this.type != 3) {
                Node node;
                if (this.type == 2 && (node = this.oldElem.getNode()) != null && "EnumerationLiteral".equals(this.oldElem.getModelElemType()) && this.oldElem.getPosition("Literal Separator") < 0L) {
                    return;
                }
                node = this.newElem.getNode();
                if (node != null && "EnumerationLiteral".equals(this.newElem.getModelElemType()) && this.newElem.getPosition("Literal Separator") < 0L) {
                    this.patchContent = this.patchContent + ",";
                }
            }
        }

        public String toString() {
            return "type = " + this.type + "\nnewElem = " + this.newElem + "\nnewStart = " + this.newStart + "\nnewEnd = " + this.newEnd + "\noldElem = " + this.oldElem + "\noldStart = " + this.oldStart + "\noldEnd = " + this.oldEnd + "\noldEdPoint = " + this.oldEdPoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OldEdPointModDescComparator
    implements Comparator<ModDesc> {
        @Override
        public int compare(ModDesc modDesc, ModDesc modDesc2) {
            if (modDesc.oldEdPoint < modDesc2.oldEdPoint) {
                return -1;
            }
            if (modDesc.oldEdPoint > modDesc2.oldEdPoint) {
                return 1;
            }
            if (modDesc.type != modDesc2.type) {
                return modDesc.type - modDesc2.type;
            }
            if (modDesc.pr != modDesc2.pr) {
                return modDesc.pr - modDesc2.pr;
            }
            return new NewStartModDescComparator().compare(modDesc, modDesc2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewStartModDescComparator
    implements Comparator<ModDesc> {
        @Override
        public int compare(ModDesc modDesc, ModDesc modDesc2) {
            if (modDesc.newStart < modDesc2.newStart) {
                return -1;
            }
            if (modDesc.newStart > modDesc2.newStart) {
                return 1;
            }
            return 0;
        }
    }
}

