/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.InstallationSettingsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GemPanel
extends JPanel
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(GemPanel.class.getName());
    private static final String LAST_GEM_DIRECTORY = "lastLocalGemDirectory";
    private static final String LAST_PLATFORM_ID = "gemPanelLastPlatformID";
    private GemManager gemManager;
    private List<Gem> installedGems;
    private List<Gem> availableGems;
    private List<Gem> newGems;
    private List<Gem> updatedGems;
    private boolean gemsModified;
    private boolean fetchingLocal;
    private boolean fetchingRemote;
    private JButton browseGemHome;
    private JLabel gemHome;
    private JTextField gemHomeValue;
    private JTabbedPane gemsTab;
    private JLabel instSearchLbl;
    private JTextField instSearchText;
    private JButton installButton;
    private JButton installLocalButton;
    private JTextPane installedDesc;
    private JList installedList;
    private JPanel installedPanel;
    private JProgressBar installedProgress;
    private JLabel installedProgressLabel;
    private JScrollPane installedSP;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JButton manageButton;
    private JTextPane newDesc;
    private JList newList;
    private JPanel newPanel;
    private JProgressBar newProgress;
    private JLabel newProgressLabel;
    private JScrollPane newSP;
    private JComboBox platforms;
    private JButton proxyButton;
    private JButton reloadInstalledButton;
    private JButton reloadNewButton;
    private JButton reloadReposButton;
    private JLabel rubyPlatformLabel;
    private JLabel searchNewLbl;
    private JTextField searchNewText;
    private JLabel searchUpdatedLbl;
    private JTextField searchUpdatedText;
    private JPanel settingsPanel;
    private JButton uninstallButton;
    private JButton updateAllButton;
    private JButton updateButton;
    private JTextPane updatedDesc;
    private JList updatedList;
    private JPanel updatedPanel;
    private JProgressBar updatedProgress;
    private JLabel updatedProgressLabel;
    private JScrollPane updatedSP;

    public GemPanel(String string) {
        this(string, null);
    }

    public GemPanel(String string, RubyPlatform rubyPlatform) {
        this.initComponents();
        if (rubyPlatform == null) {
            Util.preselectPlatform(this.platforms, LAST_PLATFORM_ID);
        } else {
            this.platforms.setSelectedItem(rubyPlatform);
        }
        RubyPlatform rubyPlatform2 = this.getSelectedPlatform();
        if (rubyPlatform2 != null) {
            this.gemManager = rubyPlatform2.getGemManager();
        }
        this.installedList.setSelectionMode(2);
        this.installedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.installedList, this.installedDesc, this.uninstallButton));
        this.newList.setSelectionMode(2);
        this.newList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.newList, this.newDesc, this.installButton));
        this.updatedList.setSelectionMode(2);
        this.updatedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.updatedList, this.updatedDesc, this.updateButton));
        if (string != null) {
            this.searchNewText.setText(string);
            this.gemsTab.setSelectedIndex(TabIndex.NEW.ordinal());
        }
        PlatformComponentFactory.addPlatformChangeListener(this.platforms, new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                GemPanel.this.gemManager = GemPanel.this.getSelectedPlatform().getGemManager();
                GemPanel.this.updateAsynchronously();
            }
        });
        this.updateAsynchronously();
    }

    private void updateAsynchronously() {
        RequestProcessor.getDefault().post((Runnable)this, 300);
    }

    @Override
    public void removeNotify() {
        Util.getPreferences().put(LAST_PLATFORM_ID, this.getSelectedPlatform().getID());
        super.removeNotify();
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = PlatformComponentFactory.isLoadingPlatforms(GemPanel.this.platforms);
                if (bl || !GemPanel.this.getSelectedPlatform().hasRubyGemsInstalled()) {
                    if (!bl) {
                        GemPanel.this.gemHomeValue.setForeground(PlatformComponentFactory.INVALID_PLAF_COLOR);
                        GemPanel.this.gemHomeValue.setText(GemManager.getNotInstalledMessage());
                    }
                    GemPanel.this.availableGems = Collections.emptyList();
                    GemPanel.this.installedGems = Collections.emptyList();
                    GemPanel.this.newGems = Collections.emptyList();
                    GemPanel.this.fetchingLocal = false;
                    GemPanel.this.fetchingRemote = false;
                    GemPanel.this.notifyGemsUpdated();
                    GemPanel.this.updateList(TabIndex.INSTALLED, true);
                    GemPanel.this.setEnabledGUI(false);
                } else {
                    GemPanel.this.gemHomeValue.setText(GemPanel.this.gemManager.getGemHome());
                    GemPanel.this.gemHomeValue.setForeground(UIManager.getColor("Label.foreground"));
                    GemPanel.this.setEnabledGUI(false);
                    GemPanel.this.refreshUpdated();
                }
            }
        });
    }

    private static void updateGemDescription(JTextPane jTextPane, Gem gem) {
        assert (SwingUtilities.isEventDispatchThread());
        if (gem == null) {
            jTextPane.setText("");
            return;
        }
        String string = "text/html";
        jTextPane.setContentType(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<h2>");
        stringBuilder.append(gem.getName());
        stringBuilder.append("</h2>\n");
        if (gem.getInstalledVersions() != null && gem.getAvailableVersions() != null) {
            stringBuilder.append("<h3>");
            stringBuilder.append(GemPanel.getMessage("InstalledVersion"));
            stringBuilder.append("</h3>");
            stringBuilder.append(gem.getInstalledVersions());
            stringBuilder.append("<h3>");
            stringBuilder.append(GemPanel.getMessage("AvailableVersion"));
            stringBuilder.append("</h3>");
            stringBuilder.append(gem.getAvailableVersions());
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append("<h3>");
            String string2 = gem.getInstalledVersions();
            if (string2 == null) {
                string2 = gem.getAvailableVersions();
            }
            if (string2.indexOf(44) == -1) {
                stringBuilder.append(GemPanel.getMessage("Version"));
            } else {
                stringBuilder.append(GemPanel.getMessage("Versions"));
            }
            stringBuilder.append("</h3>");
            stringBuilder.append(string2);
        }
        if (gem.getDescription() != null) {
            stringBuilder.append("<h3>");
            stringBuilder.append(GemPanel.getMessage("Description"));
            stringBuilder.append("</h3>");
            stringBuilder.append(gem.getDescription());
        }
        stringBuilder.append("</html>");
        jTextPane.setText(stringBuilder.toString());
    }

    private void setEnabledGUI(boolean bl) {
        this.setEnabled(TabIndex.INSTALLED, bl);
        this.setEnabled(TabIndex.NEW, bl);
        this.setEnabled(TabIndex.UPDATED, bl);
    }

    private void setEnabled(TabIndex tabIndex, boolean bl) {
        this.gemsTab.setEnabledAt(tabIndex.ordinal(), bl);
        switch (tabIndex) {
            case NEW: {
                this.reloadNewButton.setEnabled(bl);
                this.installButton.setEnabled(bl);
                this.newPanel.setEnabled(bl);
                this.newList.setEnabled(bl);
                this.newSP.setEnabled(bl);
                break;
            }
            case UPDATED: {
                this.updateButton.setEnabled(bl);
                this.updateAllButton.setEnabled(bl);
                this.reloadReposButton.setEnabled(bl);
                this.updatedPanel.setEnabled(bl);
                this.updatedList.setEnabled(bl);
                this.updatedSP.setEnabled(bl);
                break;
            }
            case INSTALLED: {
                this.reloadInstalledButton.setEnabled(bl);
                this.uninstallButton.setEnabled(bl);
                this.installedPanel.setEnabled(bl);
                this.installedList.setEnabled(bl);
                this.installedSP.setEnabled(bl);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        boolean bl2 = this.newPanel.isEnabled() && this.updatedPanel.isEnabled() && this.installedPanel.isEnabled();
        this.platforms.setEnabled(bl2);
        this.manageButton.setEnabled(bl2);
        this.browseGemHome.setEnabled(bl2);
        this.gemsTab.setEnabledAt(3, bl2);
    }

    private synchronized boolean notifyGemsUpdated() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.fetchingRemote && !this.fetchingLocal) {
            this.updatedProgress.setVisible(false);
            this.updatedProgressLabel.setVisible(false);
        }
        if (!this.fetchingRemote) {
            this.newProgress.setVisible(false);
            this.newProgressLabel.setVisible(false);
        }
        if (!this.fetchingLocal) {
            this.installedProgress.setVisible(false);
            this.installedProgressLabel.setVisible(false);
        }
        if (this.installedGems != null && this.availableGems != null) {
            HashMap<String, Gem> hashMap = new HashMap<String, Gem>();
            for (Gem object : this.installedGems) {
                hashMap.put(object.getName(), object);
            }
            Set set = hashMap.keySet();
            this.updatedGems = new ArrayList<Gem>();
            this.newGems = new ArrayList<Gem>();
            for (Gem gem : this.availableGems) {
                if (set.contains(gem.getName())) {
                    String string = gem.getAvailableVersions();
                    Gem gem2 = (Gem)hashMap.get(gem.getName());
                    String string2 = gem2.getInstalledVersions();
                    int n = string.indexOf(44);
                    if (n == -1 && (n = string.indexOf(41)) == -1) {
                        n = string.length();
                    }
                    if (string2.regionMatches(0, string, 0, n)) continue;
                    Gem gem3 = new Gem(gem.getName(), string2, string.substring(0, n));
                    gem3.setDescription(gem2.getDescription());
                    this.updatedGems.add(gem3);
                    continue;
                }
                this.newGems.add(gem);
            }
            this.updateList(TabIndex.NEW, true);
            this.updateList(TabIndex.UPDATED, true);
        }
        return !this.fetchingRemote && !this.fetchingLocal;
    }

    private void updateList(TabIndex tabIndex, boolean bl) {
        String string;
        Object object;
        JList jList;
        List<Gem> list;
        assert (SwingUtilities.isEventDispatchThread());
        Pattern pattern = null;
        String string2 = this.getGemFilter(tabIndex);
        String string3 = null;
        if (string2 != null && (string2.indexOf(42) != -1 || string2.indexOf(94) != -1 || string2.indexOf(36) != -1)) {
            try {
                pattern = Pattern.compile(string2, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else if (string2 != null) {
            string3 = string2.toLowerCase(Locale.ENGLISH);
        }
        switch (tabIndex) {
            case NEW: {
                list = this.newGems;
                jList = this.newList;
                break;
            }
            case UPDATED: {
                list = this.updatedGems;
                jList = this.updatedList;
                break;
            }
            case INSTALLED: {
                list = this.installedGems;
                jList = this.installedList;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (list == null) {
            return;
        }
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (string2 == null || string2.length() == 0) {
                defaultListModel.addElement(object);
                continue;
            }
            if (pattern == null) {
                if (string3 != null) {
                    String string4 = ((Gem)object).getName().toLowerCase();
                    if (string4.indexOf(string3) != -1) {
                        defaultListModel.addElement(object);
                        continue;
                    }
                    if (((Gem)object).getDescription() == null || (string = ((Gem)object).getDescription().toLowerCase()).indexOf(string3) == -1) continue;
                    defaultListModel.addElement(object);
                    continue;
                }
                defaultListModel.addElement(object);
                continue;
            }
            if (!pattern.matcher(((Gem)object).getName()).find() && (((Gem)object).getDescription() == null || !pattern.matcher(((Gem)object).getDescription()).find())) continue;
            defaultListModel.addElement(object);
        }
        jList.clearSelection();
        jList.setModel(defaultListModel);
        jList.invalidate();
        jList.repaint();
        if (bl) {
            object = object2 = this.gemsTab.getTitleAt(tabIndex.ordinal());
            int n = ((String)object2).lastIndexOf(40);
            if (n != -1) {
                object2 = ((String)object2).substring(0, n);
            }
            string = defaultListModel.size() < list.size() ? defaultListModel.size() + "/" + list.size() : Integer.toString(list.size());
            if (!((String)(object2 = (String)object2 + "(" + string + ")")).equals(object)) {
                this.gemsTab.setTitleAt(tabIndex.ordinal(), (String)object2);
            }
            this.setEnabled(tabIndex, true);
        }
    }

    public boolean isModified() {
        return this.gemsModified;
    }

    private synchronized void refreshInstalled() {
        GemPanel.showProgressBar(this.installedList, this.installedDesc, this.installedProgress, this.installedProgressLabel);
        this.fetchingLocal = true;
        this.setEnabled(TabIndex.INSTALLED, false);
        this.refreshGemList(TabIndex.INSTALLED);
    }

    private synchronized void refreshNew() {
        GemPanel.showProgressBar(this.newList, this.newDesc, this.newProgress, this.newProgressLabel);
        this.fetchingRemote = true;
        this.setEnabled(TabIndex.NEW, false);
        this.refreshGemList(TabIndex.NEW);
    }

    private void refreshUpdated() {
        GemPanel.showProgressBar(this.updatedList, this.updatedDesc, this.updatedProgress, this.updatedProgressLabel);
        this.refreshNew();
        this.refreshInstalled();
        this.refreshGemLists();
    }

    private static void showProgressBar(JList jList, JTextPane jTextPane, JProgressBar jProgressBar, JLabel jLabel) {
        assert (SwingUtilities.isEventDispatchThread());
        if (jList.getSelectedIndex() != -1) {
            GemPanel.updateGemDescription(jTextPane, null);
        }
        jProgressBar.setVisible(true);
        jLabel.setVisible(true);
    }

    private void initComponents() {
        this.gemsTab = new JTabbedPane();
        this.updatedPanel = new JPanel();
        this.searchUpdatedText = new JTextField();
        this.searchUpdatedLbl = new JLabel();
        this.reloadReposButton = new JButton();
        this.updatedSP = new JScrollPane();
        this.updatedList = new JList();
        this.updateButton = new JButton();
        this.updateAllButton = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.updatedDesc = new JTextPane();
        this.updatedProgress = new JProgressBar();
        this.updatedProgressLabel = new JLabel();
        this.installedPanel = new JPanel();
        this.instSearchText = new JTextField();
        this.instSearchLbl = new JLabel();
        this.reloadInstalledButton = new JButton();
        this.uninstallButton = new JButton();
        this.installedSP = new JScrollPane();
        this.installedList = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.installedDesc = new JTextPane();
        this.installedProgress = new JProgressBar();
        this.installedProgressLabel = new JLabel();
        this.newPanel = new JPanel();
        this.searchNewText = new JTextField();
        this.searchNewLbl = new JLabel();
        this.reloadNewButton = new JButton();
        this.installButton = new JButton();
        this.newSP = new JScrollPane();
        this.newList = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.newDesc = new JTextPane();
        this.newProgress = new JProgressBar();
        this.newProgressLabel = new JLabel();
        this.installLocalButton = new JButton();
        this.settingsPanel = new JPanel();
        this.proxyButton = new JButton();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.gemHome = new JLabel();
        this.gemHomeValue = new JTextField();
        this.browseGemHome = new JButton();
        FormListener formListener = new FormListener();
        this.searchUpdatedText.setColumns(14);
        this.searchUpdatedText.addActionListener(formListener);
        this.searchUpdatedLbl.setLabelFor(this.searchUpdatedText);
        Mnemonics.setLocalizedText((JLabel)this.searchUpdatedLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadReposButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadReposButton.text"));
        this.reloadReposButton.addActionListener(formListener);
        this.updatedSP.setViewportView(this.updatedList);
        this.updatedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleName"));
        this.updatedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.text"));
        this.updateAllButton.addActionListener(formListener);
        this.updatedDesc.setEditable(false);
        this.jScrollPane6.setViewportView(this.updatedDesc);
        this.updatedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleName"));
        this.updatedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedDesc.AccessibleContext.accessibleDescription"));
        this.updatedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.updatedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.updatedPanel);
        this.updatedPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.reloadReposButton).addPreferredGap(0, 432, Short.MAX_VALUE).add((Component)this.searchUpdatedLbl).addPreferredGap(0).add((Component)this.searchUpdatedText, -2, 156, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.updateButton).addPreferredGap(0).add((Component)this.updateAllButton).addPreferredGap(0, 358, Short.MAX_VALUE).add((Component)this.updatedProgressLabel).addPreferredGap(0).add((Component)this.updatedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.updatedSP, -1, 457, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane6, -2, 283, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.searchUpdatedLbl).add((Component)this.searchUpdatedText, -2, -1, -2).add((Component)this.reloadReposButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.updatedSP, -1, 279, Short.MAX_VALUE).add((Component)this.jScrollPane6, -1, 279, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.updateButton).add((Component)this.updateAllButton)).add((Component)this.updatedProgress, -2, -1, -2).add((Component)this.updatedProgressLabel)).addContainerGap()));
        this.searchUpdatedText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedText.AccessibleContext.accessibleDescription"));
        this.searchUpdatedLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchUpdatedLbl.AccessibleContext.accessibleDescription"));
        this.reloadReposButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadReposButton.AccessibleContext.accessibleDescription"));
        this.updatedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane3.AccessibleContext.accessibleDescription"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateButton.AccessibleContext.accessibleDescription"));
        this.updateAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updateAllButton.AccessibleContext.accessibleDescription"));
        this.jScrollPane6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane6.AccessibleContext.accessibleDescription"));
        this.updatedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgress.AccessibleContext.accessibleDescription"));
        this.updatedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.updatedPanel.TabConstraints.tabTitle"), this.updatedPanel);
        this.instSearchText.setColumns(14);
        this.instSearchText.addActionListener(formListener);
        this.instSearchLbl.setLabelFor(this.instSearchText);
        Mnemonics.setLocalizedText((JLabel)this.instSearchLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(formListener);
        this.installedSP.setViewportView(this.installedList);
        this.installedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleName"));
        this.installedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedList.AccessibleContext.accessibleDescription"));
        this.installedDesc.setEditable(false);
        this.jScrollPane5.setViewportView(this.installedDesc);
        this.installedDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleName"));
        this.installedDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedDesc.AccessibleContext.accessibleDescription"));
        this.installedProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.installedProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.reloadInstalledButton).addPreferredGap(0, 432, Short.MAX_VALUE).add((Component)this.instSearchLbl).addPreferredGap(0).add((Component)this.instSearchText, -2, 156, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.uninstallButton).addPreferredGap(0, 451, Short.MAX_VALUE).add((Component)this.installedProgressLabel).addPreferredGap(0).add((Component)this.installedProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.installedSP, -1, 457, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane5, -2, 283, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.instSearchLbl).add((Component)this.reloadInstalledButton).add((Component)this.instSearchText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.installedSP, -1, 279, Short.MAX_VALUE).add((Component)this.jScrollPane5, -1, 279, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.uninstallButton).add((Component)this.installedProgress, -2, -1, -2).add((Component)this.installedProgressLabel)).addContainerGap()));
        this.instSearchText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchText.AccessibleContext.accessibleDescription"));
        this.instSearchLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.instSearchLbl.AccessibleContext.accessibleDescription"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadInstalledButton.AccessibleContext.accessibleDescription"));
        this.uninstallButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.uninstallButton.AccessibleContext.accessibleDescription"));
        this.installedSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.jScrollPane5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane5.AccessibleContext.accessibleDescription"));
        this.installedProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgress.AccessibleContext.accessibleDescription"));
        this.installedProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installedPanel.TabConstraints.tabTitle"), this.installedPanel);
        this.searchNewText.setColumns(14);
        this.searchNewText.addActionListener(formListener);
        this.searchNewLbl.setLabelFor(this.searchNewText);
        Mnemonics.setLocalizedText((JLabel)this.searchNewLbl, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadNewButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.text"));
        this.reloadNewButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(formListener);
        this.newSP.setViewportView(this.newList);
        this.newList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleName"));
        this.newList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newList.AccessibleContext.accessibleDescription"));
        this.newDesc.setEditable(false);
        this.jScrollPane4.setViewportView(this.newDesc);
        this.newDesc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleName"));
        this.newDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newDesc.AccessibleContext.accessibleDescription"));
        this.newProgress.setIndeterminate(true);
        Mnemonics.setLocalizedText((JLabel)this.newProgressLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installLocalButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installLocalButton.text"));
        this.installLocalButton.addActionListener(formListener);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.newPanel);
        this.newPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.reloadNewButton).addPreferredGap(0, 432, Short.MAX_VALUE).add((Component)this.searchNewLbl).addPreferredGap(0).add((Component)this.searchNewText, -2, 156, -2)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.installLocalButton).addPreferredGap(0, 344, Short.MAX_VALUE).add((Component)this.newProgressLabel).addPreferredGap(0).add((Component)this.newProgress, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.newSP, -1, 457, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane4, -2, 283, -2))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.searchNewLbl).add((Component)this.reloadNewButton).add((Component)this.searchNewText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.newSP, -1, 279, Short.MAX_VALUE).add((Component)this.jScrollPane4, -1, 279, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.installButton).add((Component)this.installLocalButton)).add((Component)this.newProgress, -2, -1, -2).add((Component)this.newProgressLabel)).addContainerGap()));
        this.searchNewText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewText.AccessibleContext.accessibleDescription"));
        this.searchNewLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.searchNewLbl.AccessibleContext.accessibleDescription"));
        this.reloadNewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.reloadNewButton.AccessibleContext.accessibleDescription"));
        this.installButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.installButton.AccessibleContext.accessibleDescription"));
        this.newSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane2.AccessibleContext.accessibleDescription"));
        this.jScrollPane4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.jScrollPane4.AccessibleContext.accessibleDescription"));
        this.newProgress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgress.AccessibleContext.accessibleDescription"));
        this.newProgressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newProgressLabel.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.newPanel.TabConstraints.tabTitle"), this.newPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.settingsPanel);
        this.settingsPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(616, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(328, Short.MAX_VALUE)));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.gemsTab.addTab(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.settingsPanel.TabConstraints.tabTitle"), this.settingsPanel);
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.rubyPlatformLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.text"));
        this.manageButton.addActionListener(formListener);
        this.gemHome.setLabelFor(this.gemHomeValue);
        Mnemonics.setLocalizedText((JLabel)this.gemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHome.text"));
        this.gemHomeValue.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseGemHome, (String)NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.text"));
        this.browseGemHome.addActionListener(formListener);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.gemsTab, -1, 787, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.rubyPlatformLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add(1, (Component)this.gemHomeValue, -1, 587, Short.MAX_VALUE).add(1, (Component)this.platforms, 0, 587, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.gemHome, -2, 77, Short.MAX_VALUE).add(613, 613, 613))).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.manageButton).add((Component)this.browseGemHome, -2, 80, -2)))).addContainerGap()));
        groupLayout5.linkSize(new Component[]{this.browseGemHome, this.manageButton}, 1);
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.gemHome).add((Component)this.gemHomeValue, -2, -1, -2).add((Component)this.browseGemHome)).addPreferredGap(1).add((Component)this.gemsTab, -1, 392, Short.MAX_VALUE).addContainerGap()));
        this.gemsTab.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleName"));
        this.gemsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemsTab.AccessibleContext.accessibleDescription"));
        this.platforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleName"));
        this.platforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.platforms.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.manageButton.AccessibleContext.accessibleDescription"));
        this.gemHomeValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleName"));
        this.gemHomeValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.gemHomeValue.AccessibleContext.accessibleDescription"));
        this.browseGemHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.browseGemHome.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemPanel.class, (String)"GemPanel.AccessibleContext.accessibleDescription"));
    }

    private void reloadNewButtonActionPerformed(ActionEvent actionEvent) {
        this.gemManager.resetRemote();
        this.refreshNew();
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void searchNewTextActionPerformed(ActionEvent actionEvent) {
        this.updateList(TabIndex.NEW, true);
    }

    private void searchUpdatedTextActionPerformed(ActionEvent actionEvent) {
        this.updateList(TabIndex.UPDATED, true);
    }

    private void reloadReposButtonActionPerformed(ActionEvent actionEvent) {
        this.gemManager.reset();
        this.setEnabledGUI(false);
        this.refreshUpdated();
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        Gem gem;
        Object object;
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.newList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        for (int n : nArray) {
            object = this.newList.getModel().getElementAt(n);
            if (!(object instanceof Gem)) continue;
            gem = (Gem)object;
            arrayList.add(gem);
        }
        if (!arrayList.isEmpty()) {
            Object object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Gem gem2 = (Gem)object2.next();
                InstallationSettingsPanel installationSettingsPanel = new InstallationSettingsPanel(gem2);
                installationSettingsPanel.getAccessibleContext().setAccessibleDescription(GemPanel.getMessage("InstallationSettingsPanel.AccessibleContext.accessibleDescription"));
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installationSettingsPanel, GemPanel.getMessage("ChooseGemSettings"));
                dialogDescriptor.setOptionType(2);
                dialogDescriptor.setModal(true);
                dialogDescriptor.setHelpCtx(new HelpCtx(GemPanel.class));
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (!object.equals(NotifyDescriptor.OK_OPTION)) continue;
                gem = new Gem(installationSettingsPanel.getGemName(), null, null);
                GemListRefresher gemListRefresher = new GemListRefresher(this.newList, TabIndex.INSTALLED);
                this.gemManager.install(new Gem[]{gem}, this, false, false, installationSettingsPanel.getVersion(), installationSettingsPanel.getIncludeDepencies(), true, gemListRefresher);
            }
        }
    }

    private void instSearchTextActionPerformed(ActionEvent actionEvent) {
        this.updateList(TabIndex.INSTALLED, true);
    }

    private void updateAllButtonActionPerformed(ActionEvent actionEvent) {
        GemListRefresher gemListRefresher = new GemListRefresher(this.installedList, TabIndex.INSTALLED);
        this.gemManager.update(null, this, false, false, true, gemListRefresher);
    }

    private void updateButtonActionPerformed(ActionEvent actionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.updatedList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.updatedList.getModel().getElementAt(n);
                if (!(e instanceof Gem)) continue;
                Gem gem = (Gem)e;
                arrayList.add(gem);
            }
        }
        if (!arrayList.isEmpty()) {
            GemListRefresher gemListRefresher = new GemListRefresher(this.updatedList, TabIndex.INSTALLED);
            this.gemManager.update(arrayList.toArray(new Gem[arrayList.size()]), this, false, false, true, gemListRefresher);
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.installedList.getSelectedIndices();
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.installedList.getModel().getElementAt(n);
                if (!(e instanceof Gem)) continue;
                Gem gem = (Gem)e;
                arrayList.add(gem);
            }
        }
        if (!arrayList.isEmpty()) {
            GemListRefresher gemListRefresher = new GemListRefresher(this.installedList, TabIndex.INSTALLED);
            this.gemManager.uninstall(arrayList.toArray(new Gem[arrayList.size()]), this, true, gemListRefresher);
        }
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent actionEvent) {
        this.gemManager.resetLocal();
        this.refreshInstalled();
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage(this.platforms);
    }

    private void browseGemHomeActionPerformed(ActionEvent actionEvent) {
        boolean bl = GemPanel.chooseAndSetGemHome(this, this.getSelectedPlatform());
        if (bl) {
            this.updateAsynchronously();
        }
    }

    private void installLocalButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(Util.getPreferences().get(LAST_GEM_DIRECTORY, ""));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase(Locale.US).endsWith(".gem");
            }

            public String getDescription() {
                return GemPanel.getMessage("GemPanel.rubygems.files.filter");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            Util.getPreferences().put(LAST_GEM_DIRECTORY, file.getParentFile().getAbsolutePath());
            GemListRefresher gemListRefresher = new GemListRefresher(this.newList, TabIndex.INSTALLED);
            this.gemManager.installLocal(file, this, false, false, true, gemListRefresher);
        }
    }

    public static File chooseGemRepository(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            if (GemManager.isValidGemHome(file)) {
                return file;
            }
            if (!file.exists() || file.isDirectory() && file.list().length == 0) {
                if (Util.confirmLocalized(GemPanel.class, "GemPanel.empty.create.gemrepo", file.getAbsolutePath())) {
                    try {
                        GemManager.initializeRepository(file);
                        return file;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                    }
                }
            } else {
                Util.notifyLocalized(GemPanel.class, "GemPanel.invalid.gemHome", file.getAbsolutePath());
            }
        }
        return null;
    }

    public static boolean chooseAndSetGemHome(Component component, RubyPlatform rubyPlatform) {
        if (rubyPlatform == null) {
            return false;
        }
        assert (rubyPlatform.hasRubyGemsInstalled()) : "has RubyGems installed";
        File file = GemPanel.chooseGemRepository(component);
        if (file != null) {
            rubyPlatform.setGemHome(file);
            return true;
        }
        return false;
    }

    private void refreshGemList(final TabIndex tabIndex) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GemPanel gemPanel = GemPanel.this;
                synchronized (gemPanel) {
                    assert (!SwingUtilities.isEventDispatchThread());
                    final ArrayList<String> arrayList = new ArrayList<String>(500);
                    if (tabIndex == TabIndex.INSTALLED) {
                        GemPanel.this.installedGems = GemPanel.this.gemManager.getInstalledGems(arrayList);
                        GemPanel.this.fetchingLocal = false;
                    } else if (tabIndex == TabIndex.NEW) {
                        GemPanel.this.availableGems = (GemPanel.this.newGems = GemPanel.this.gemManager.getRemoteGems(arrayList));
                        GemPanel.this.fetchingRemote = false;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean bl;
                            if (!arrayList.isEmpty()) {
                                GemPanel.this.showGemErrors(arrayList);
                            }
                            if (!(bl = GemPanel.this.notifyGemsUpdated())) {
                                GemPanel.this.updateList(tabIndex, false);
                            } else if (tabIndex == TabIndex.INSTALLED) {
                                GemPanel.this.updateList(tabIndex, true);
                            }
                        }
                    });
                }
            }
        };
        RequestProcessor.getDefault().post(runnable, 50);
    }

    private void showGemErrors(List<String> list) {
        assert (EventQueue.isDispatchThread());
        this.gemManager.reset();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        Util.notifyLocalized(GemPanel.class, "GemPanel.NoNetwork", 0, new Object[]{stringBuilder.toString()});
    }

    private void refreshGemLists() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GemPanel gemPanel = GemPanel.this;
                synchronized (gemPanel) {
                    assert (!SwingUtilities.isEventDispatchThread());
                    final ArrayList<String> arrayList = new ArrayList<String>();
                    GemPanel.this.gemManager.reloadIfNeeded(arrayList);
                    GemPanel.this.installedGems = GemPanel.this.gemManager.getInstalledGems(arrayList);
                    GemPanel.this.availableGems = GemPanel.this.gemManager.getRemoteGems(arrayList);
                    GemPanel.this.newGems = GemPanel.this.availableGems;
                    GemPanel.this.fetchingLocal = false;
                    GemPanel.this.fetchingRemote = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (!arrayList.isEmpty()) {
                                GemPanel.this.showGemErrors(arrayList);
                            }
                            GemPanel.this.notifyGemsUpdated();
                            GemPanel.this.updateList(TabIndex.INSTALLED, true);
                        }
                    });
                }
            }
        };
        RequestProcessor.getDefault().post(runnable, 50);
    }

    private String getGemFilter(TabIndex tabIndex) {
        JTextField jTextField;
        assert (SwingUtilities.isEventDispatchThread());
        String string = null;
        if (tabIndex == TabIndex.INSTALLED) {
            jTextField = this.instSearchText;
        } else if (tabIndex == TabIndex.UPDATED) {
            jTextField = this.searchUpdatedText;
        } else {
            assert (tabIndex == TabIndex.NEW);
            jTextField = this.searchNewText;
        }
        string = jTextField.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    private RubyPlatform getSelectedPlatform() {
        return PlatformComponentFactory.getPlatform(this.platforms);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(GemPanel.class, (String)string);
    }

    private class GemListRefresher
    implements Runnable {
        private final JList list;
        private final TabIndex tab;

        public GemListRefresher(JList jList, TabIndex tabIndex) {
            this.list = jList;
            this.tab = tabIndex;
        }

        public void run() {
            if (!GemPanel.this.gemsModified) {
                GemPanel.this.gemsModified = true;
            }
            GemPanel.this.refreshGemList(this.tab);
        }
    }

    private static class MyListSelectionListener
    implements ListSelectionListener {
        private final JButton button;
        private final JTextPane pane;
        private final JList list;

        private MyListSelectionListener(JList jList, JTextPane jTextPane, JButton jButton) {
            this.list = jList;
            this.pane = jTextPane;
            this.button = jButton;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = this.list.getSelectedIndex();
            if (n != -1) {
                Object e = this.list.getModel().getElementAt(n);
                if (e instanceof Gem) {
                    this.button.setEnabled(true);
                    if (this.pane != null) {
                        GemPanel.updateGemDescription(this.pane, (Gem)e);
                    }
                    return;
                }
            } else if (this.pane != null) {
                this.pane.setText("");
            }
            this.button.setEnabled(n != -1);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GemPanel.this.searchUpdatedText) {
                GemPanel.this.searchUpdatedTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.reloadReposButton) {
                GemPanel.this.reloadReposButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.updateButton) {
                GemPanel.this.updateButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.updateAllButton) {
                GemPanel.this.updateAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.instSearchText) {
                GemPanel.this.instSearchTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.reloadInstalledButton) {
                GemPanel.this.reloadInstalledButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.uninstallButton) {
                GemPanel.this.uninstallButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.searchNewText) {
                GemPanel.this.searchNewTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.reloadNewButton) {
                GemPanel.this.reloadNewButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.installButton) {
                GemPanel.this.installButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.installLocalButton) {
                GemPanel.this.installLocalButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.proxyButton) {
                GemPanel.this.proxyButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.manageButton) {
                GemPanel.this.manageButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == GemPanel.this.browseGemHome) {
                GemPanel.this.browseGemHomeActionPerformed(actionEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TabIndex {
        UPDATED,
        INSTALLED,
        NEW;

    }
}

