/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.openide.ErrorManager;

public class RegexpOutputRecognizer
extends OutputRecognizer {
    private static final String EXT_RE = ".*\\.(rb|rake|mab|rjs|rxml|builder)";
    private final Pattern pattern;
    private final int fileGroup;
    private final int lineGroup;
    private final int columnGroup;
    private final String extRE;

    public RegexpOutputRecognizer(String string) {
        this(string, 1, 2, -1, EXT_RE);
    }

    public RegexpOutputRecognizer(String string, int n, int n2, int n3, String string2) {
        this.pattern = Pattern.compile(string);
        this.fileGroup = n;
        this.lineGroup = n2;
        this.columnGroup = n3;
        this.extRE = string2;
    }

    public RegexpOutputRecognizer(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, null);
    }

    public OutputRecognizer.FileLocation processLine(String string) {
        if (string.length() > 400) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            String string2;
            String string3 = null;
            int n = -1;
            int n2 = -1;
            if (this.fileGroup != -1) {
                string3 = matcher.group(this.fileGroup);
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("./")) {
                    string3 = string3.substring(2);
                }
                if (this.extRE != null && !string3.matches(this.extRE) && !new File(string3).isFile()) {
                    return null;
                }
            }
            if (this.lineGroup != -1) {
                string2 = matcher.group(this.lineGroup);
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().notify((Throwable)numberFormatException);
                    n = 0;
                }
            }
            if (this.columnGroup != -1) {
                string2 = matcher.group(this.columnGroup);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().notify((Throwable)numberFormatException);
                    n2 = 0;
                }
            }
            return new OutputRecognizer.FileLocation(string3, n, n2);
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

