/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionDescriptor {
    File pwd;
    File cmd;
    boolean addBinPath;
    boolean inputVisible;
    private String displayName;
    Runnable postBuildAction;
    private final RubyPlatform platform;
    private FileLocator fileLocator;
    String script;
    private Map<String, String> additionalEnv;
    private String[] additionalArgs;
    private String initialArgs;
    private FileObject fileObject;
    private String classPath;
    boolean showProgress = true;
    boolean showSuspended;
    boolean frontWindow = true;
    boolean debug;
    private boolean fastDebugRequired;
    private boolean appendJdkToPath;
    List<OutputRecognizer> outputRecognizers = new ArrayList<OutputRecognizer>();

    public ExecutionDescriptor(RubyPlatform rubyPlatform) {
        this(rubyPlatform, null, null);
    }

    public ExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file) {
        this(rubyPlatform, string, file, null);
    }

    public ExecutionDescriptor(RubyPlatform rubyPlatform, String string, File file, String string2) {
        HashMap<String, String> hashMap;
        this.platform = rubyPlatform;
        this.displayName = string;
        this.pwd = file;
        this.script = string2;
        assert (file == null || file.isDirectory()) : file + " is a directory";
        if (rubyPlatform.hasRubyGemsInstalled()) {
            hashMap = new HashMap<String, String>();
            GemManager.adjustEnvironment(rubyPlatform, hashMap);
            this.addAdditionalEnv(hashMap);
        }
        if (rubyPlatform.isJRuby()) {
            hashMap = new HashMap();
            String string3 = rubyPlatform.getHome().getAbsolutePath();
            hashMap.put("JRUBY_HOME", string3);
            hashMap.put("JRUBY_BASE", string3);
            hashMap.put("JAVA_HOME", RubyExecution.getJavaHome());
            this.addAdditionalEnv(hashMap);
        }
    }

    public ExecutionDescriptor cmd(File file) {
        this.cmd = file;
        assert (file != null && file.isFile()) : file + " is a file";
        return this;
    }

    public ExecutionDescriptor postBuild(Runnable runnable) {
        this.postBuildAction = runnable;
        return this;
    }

    public ExecutionDescriptor fileLocator(FileLocator fileLocator) {
        this.fileLocator = fileLocator;
        return this;
    }

    public ExecutionDescriptor fileObject(FileObject fileObject) {
        this.fileObject = fileObject;
        return this;
    }

    public ExecutionDescriptor addStandardRecognizers() {
        this.outputRecognizers.addAll(RubyExecution.getStandardRubyRecognizers());
        return this;
    }

    public ExecutionDescriptor addOutputRecognizer(OutputRecognizer outputRecognizer) {
        this.outputRecognizers.add(outputRecognizer);
        return this;
    }

    public ExecutionDescriptor allowInput() {
        this.inputVisible = true;
        return this;
    }

    public ExecutionDescriptor showProgress(boolean bl) {
        this.showProgress = bl;
        return this;
    }

    public ExecutionDescriptor showSuspended(boolean bl) {
        this.showSuspended = bl;
        return this;
    }

    public ExecutionDescriptor additionalArgs(String ... stringArray) {
        this.additionalArgs = stringArray;
        return this;
    }

    public ExecutionDescriptor initialArgs(String string) {
        this.initialArgs = string;
        return this;
    }

    public ExecutionDescriptor addBinPath(boolean bl) {
        this.addBinPath = bl;
        return this;
    }

    public ExecutionDescriptor frontWindow(boolean bl) {
        this.frontWindow = bl;
        return this;
    }

    public ExecutionDescriptor debug(boolean bl) {
        this.debug = bl;
        return this;
    }

    public ExecutionDescriptor fastDebugRequired(boolean bl) {
        this.fastDebugRequired = bl;
        return this;
    }

    public ExecutionDescriptor appendJdkToPath(boolean bl) {
        this.appendJdkToPath = bl;
        return this;
    }

    public ExecutionDescriptor classPath(String string) {
        this.classPath = string;
        return this;
    }

    String getDisplayName() {
        return this.debug ? this.displayName + " (debug)" : this.displayName;
    }

    public RubyPlatform getPlatform() {
        return this.platform;
    }

    public File getCmd() {
        return this.cmd;
    }

    public String getScript() {
        return this.script;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public String[] getInitialArgs() {
        return this.initialArgs == null ? null : Utilities.parseParameters((String)this.initialArgs);
    }

    public File getPwd() {
        return this.pwd;
    }

    public boolean isFastDebugRequired() {
        return this.fastDebugRequired;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public boolean getAppendJdkToPath() {
        return this.appendJdkToPath;
    }

    public void addAdditionalEnv(Map<String, String> map) {
        if (this.additionalEnv == null) {
            this.additionalEnv = new HashMap<String, String>();
        }
        this.additionalEnv.putAll(map);
    }

    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnv;
    }
}

