/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.ruby.platform.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class RubyInstallation {
    private static final Logger LOGGER = Logger.getLogger(RubyInstallation.class.getName());
    private static final String JRUBY_RELEASE = "1.1";
    private static final String JRUBY_RELEASEDIR = "jruby-1.1";
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    public static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    private static final RubyInstallation INSTANCE = new RubyInstallation();
    private String jrubyHome;

    private RubyInstallation() {
    }

    public static RubyInstallation getInstance() {
        return INSTANCE;
    }

    public void setJRubyLoadPaths() {
        String string = this.getJRubyHome();
        if (string != null) {
            System.setProperty("jruby.home", string);
        }
    }

    public String getJRuby() {
        String string = this.getJRubyBin();
        if (string == null) {
            return null;
        }
        String string2 = Utilities.isWindows() ? "jruby.bat" : "jruby";
        String string3 = string + File.separator + string2;
        try {
            string3 = new File(string3).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return string3;
    }

    static void displayRubyOptions() {
        OptionsDisplayer.getDefault().open("RubyOptions");
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            File file = InstalledFileLocator.getDefault().locate(JRUBY_RELEASEDIR, "org.netbeans.modules.ruby.project", false);
            if (file == null || !file.isDirectory()) {
                return null;
            }
            this.jrubyHome = file.getPath();
        }
        return this.jrubyHome;
    }

    private String getJRubyBin() {
        String string = this.getJRubyHome();
        if (string != null) {
            return string + File.separator + "bin";
        }
        return null;
    }

    public void ensureExecutable() {
        if (Utilities.isWindows()) {
            return;
        }
        String string = this.getJRubyBin();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File file2 = new File("/bin/chmod");
        if (!file2.isFile()) {
            file2 = new File("/usr/bin/chmod");
        }
        if (file2.isFile()) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(file2.getAbsolutePath());
                arrayList.add("u+rx");
                String[] stringArray = file.list();
                for (String string2 : stringArray) {
                    arrayList.add(string2);
                }
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.directory(file);
                Util.adjustProxy(processBuilder);
                Process process = processBuilder.start();
                int n = process.waitFor();
                if (n != 0) {
                    throw new IOException("could not run " + arrayList + " : Exit value=" + n);
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Can't chmod+x JRuby bits", throwable);
            }
        }
    }
}

