/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.snippets;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;

public class SnippetsPaletteUtilities {
    public static void insert(String string, JTextComponent jTextComponent) throws BadLocationException {
        SnippetsPaletteUtilities.insert(string, jTextComponent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String string, JTextComponent jTextComponent, boolean bl) throws BadLocationException {
        Document document;
        if (string == null) {
            string = "";
        }
        if ((document = jTextComponent.getDocument()) == null) {
            return;
        }
        Formatter formatter = null;
        if (bl && document instanceof BaseDocument) {
            formatter = ((BaseDocument)document).getFormatter();
            formatter.reformatLock();
        }
        try {
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).atomicLock();
            }
            try {
                int n = SnippetsPaletteUtilities.insert(string, jTextComponent, document);
                if (formatter != null && n >= 0) {
                    int n2 = n + string.length();
                    formatter.reformat((BaseDocument)document, n, n2);
                }
            }
            finally {
                if (document instanceof BaseDocument) {
                    ((BaseDocument)document).atomicUnlock();
                }
            }
        }
        finally {
            if (formatter != null) {
                formatter.reformatUnlock();
            }
        }
    }

    private static int insert(String string, JTextComponent jTextComponent, Document document) throws BadLocationException {
        int n = -1;
        try {
            Caret caret = jTextComponent.getCaret();
            int n2 = Math.min(caret.getDot(), caret.getMark());
            int n3 = Math.max(caret.getDot(), caret.getMark());
            document.remove(n2, n3 - n2);
            n = caret.getDot();
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }
}

