/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.xml.sax.SAXParseException;

public class XMLDisplayer {
    private final String FORMAT = "{0} [{1}] {2}";
    private InputOutput xmlIO;
    private OutputWriter ow = null;

    public XMLDisplayer() {
        this(NbBundle.getMessage(XMLDisplayer.class, (String)"TITLE_XML_check_window"));
    }

    protected XMLDisplayer(String string) {
        this.initInputOutput(string);
    }

    public void display(String string) {
        this.ow.println(string);
    }

    public void display(String string, boolean bl) {
        if (bl) {
            boolean bl2 = this.xmlIO.isFocusTaken();
            this.xmlIO.select();
            this.xmlIO.setFocusTaken(true);
            this.ow.println(string);
            this.xmlIO.setFocusTaken(bl2);
        } else {
            this.ow.println(string);
        }
    }

    public final void moveToFront() {
        boolean bl = this.xmlIO.isFocusTaken();
        this.xmlIO.select();
        this.xmlIO.setFocusTaken(true);
        this.ow.write("\r");
        this.xmlIO.setFocusTaken(bl);
    }

    public void display(DataObject dataObject, SAXParseException sAXParseException) {
        String string;
        DataObject dataObject2 = null;
        try {
            string = URLMapper.findFileObject((URL)new URL(sAXParseException.getSystemId()));
            if (string != null) {
                dataObject2 = DataObject.find((FileObject)string);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        string = "";
        if (dataObject2 == null) {
            string = sAXParseException.getSystemId();
        }
        this.display(dataObject2, sAXParseException.getMessage(), string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()));
    }

    protected void display(DataObject dataObject, String string, String string2, Integer n, Integer n2) {
        Object[] objectArray = new Object[]{string, n, string2};
        String string3 = MessageFormat.format("{0} [{1}] {2}", objectArray);
        try {
            if (dataObject == null) {
                throw new IOException("catchIt");
            }
            IOCtl iOCtl = new IOCtl(dataObject, Math.max(n - 1, 0), Math.max(n2 - 1, 0));
            this.ow.println(string3, (OutputListener)iOCtl);
        }
        catch (IOException iOException) {
            this.ow.println(string3);
        }
    }

    private void initInputOutput(String string) {
        if (this.ow != null) {
            return;
        }
        this.xmlIO = IOProvider.getDefault().getIO(string, false);
        this.xmlIO.setFocusTaken(false);
        this.ow = this.xmlIO.getOut();
        try {
            this.ow.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final class IOCtl
    implements OutputListener {
        Line xline;
        int column;

        public IOCtl(DataObject dataObject, int n, int n2) throws IOException {
            this.column = n2;
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = lineCookie.getLineSet().getOriginal(n);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            try {
                this.xline.markError();
                this.xline.show(0, this.column);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineAction(OutputEvent outputEvent) {
            try {
                this.xline.markError();
                this.xline.show(2, this.column);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            try {
                this.xline.unmarkError();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

