/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Checkbox;
import com.sun.rave.web.ui.renderer.RbCbRendererBase;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CheckboxRenderer
extends RbCbRendererBase {
    private final String MSG_COMPONENT_NOT_CHECKBOX = "CheckboxRenderer only renders Checkbox components.";
    protected String[] styles = new String[]{"Cb", "CbDis", "CbLbl", "CbLblDis", "CbImg", "CbImgDis", "CbSpn", "CbSpnDis"};

    public void decode(FacesContext context, UIComponent component) {
        String[] newValues;
        Map requestParameterValuesMap;
        boolean inGroup;
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        Checkbox checkbox = (Checkbox)component;
        String name = checkbox.getName();
        boolean bl = inGroup = name != null;
        if (name == null) {
            name = component.getClientId(context);
        }
        if ((requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap()).containsKey(name) && ((newValues = (String[])requestParameterValuesMap.get(name)) != null || newValues.length != 0)) {
            String selectedValueAsString = null;
            Object selectedValue = checkbox.getSelectedValue();
            if (inGroup && selectedValue instanceof Boolean) {
                selectedValueAsString = component.getClientId(context);
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{selectedValue.toString()});
                    return;
                }
            } else {
                selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{newValues[i]});
                    return;
                }
            }
            ((UIInput)component).setSubmittedValue((Object)new String[0]);
            return;
        }
        ((UIInput)component).setSubmittedValue((Object)new String[0]);
    }

    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof Checkbox)) {
            throw new IllegalArgumentException(MessageUtil.getMessage(context, "com.sun.rave.web.ui.renderer.Bundle", "CheckboxRenderer only renders Checkbox components."));
        }
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelection(context, component, theme, writer, "checkbox");
    }

    protected boolean isSelected(FacesContext context, UIComponent component) {
        return ((Checkbox)component).isChecked();
    }

    protected String getStyle(Theme theme, int styleCode) {
        String style = null;
        try {
            style = theme.getStyleClass(this.styles[styleCode]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return style;
    }
}

