/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

public class OffsetRange {
    public static final OffsetRange NONE = new OffsetRange(0, 0);
    private final int start;
    private final int end;

    public OffsetRange(int n, int n2) {
        assert (n >= 0);
        assert (n2 >= n);
        this.start = n;
        this.end = n2;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public boolean overlaps(OffsetRange offsetRange) {
        if (offsetRange == NONE) {
            return false;
        }
        if (this == NONE) {
            return false;
        }
        return this.end > offsetRange.start && this.start < offsetRange.end;
    }

    public String toString() {
        if (this == NONE) {
            return "OffsetRange[NONE]";
        }
        return "OffsetRange[" + this.start + "," + this.end + ">";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OffsetRange offsetRange = (OffsetRange)object;
        if (this.getStart() != offsetRange.getStart()) {
            return false;
        }
        return this.getEnd() == offsetRange.getEnd();
    }

    public int hashCode() {
        int n = 7;
        n = 23 * n + this.getStart();
        n = 23 * n + this.getEnd();
        return n;
    }

    public boolean containsInclusive(int n) {
        if (this == NONE) {
            return false;
        }
        return n >= this.getStart() && n <= this.getEnd();
    }
}

