/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.datatype.BinaryBase;
import org.netbeans.modules.xml.axi.datatype.CustomDatatype;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.datatype.DatatypeFactory;
import org.netbeans.modules.xml.axi.datatype.NotationType;
import org.netbeans.modules.xml.axi.datatype.NumberBase;
import org.netbeans.modules.xml.axi.datatype.QNameType;
import org.netbeans.modules.xml.axi.datatype.StringBase;
import org.netbeans.modules.xml.axi.datatype.TimeBase;
import org.netbeans.modules.xml.axi.datatype.UnionType;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Enumeration;
import org.netbeans.modules.xml.schema.model.FractionDigits;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Length;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.MaxExclusive;
import org.netbeans.modules.xml.schema.model.MaxInclusive;
import org.netbeans.modules.xml.schema.model.MaxLength;
import org.netbeans.modules.xml.schema.model.MinExclusive;
import org.netbeans.modules.xml.schema.model.MinInclusive;
import org.netbeans.modules.xml.schema.model.MinLength;
import org.netbeans.modules.xml.schema.model.Pattern;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SimpleRestriction;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.TotalDigits;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.model.Whitespace;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeBuilder
extends DeepSchemaVisitor {
    private Datatype datatype;
    private SimpleRestriction facetParent;
    AXIModelImpl model;

    DatatypeBuilder() {
    }

    public DatatypeBuilder(AXIModel aXIModel) {
        this.model = (AXIModelImpl)aXIModel;
    }

    public void visit(Enumeration enumeration) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ((NumberBase)this.datatype).addEnumeration(NumberBase.toNumber(enumeration.getValue()));
        } else if (this.datatype instanceof BinaryBase) {
            ((BinaryBase)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof NotationType) {
            ((NotationType)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof QNameType) {
            ((QNameType)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof StringBase) {
            ((StringBase)this.datatype).addEnumeration(enumeration.getValue());
        } else if (this.datatype instanceof TimeBase) {
            ((TimeBase)this.datatype).addEnumeration(enumeration.getValue());
        }
    }

    public void visit(FractionDigits fractionDigits) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        List<? extends Number> list = this.datatype.getFractionDigits();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeFractionDigits((Number)arrayList.get(n));
            }
        }
        this.datatype.addFractionDigits(fractionDigits.getValue());
    }

    public void visit(Length length) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        List<? extends Number> list = this.datatype.getLengths();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeLength((Number)arrayList.get(n));
            }
        }
        this.datatype.addLength(length.getValue());
    }

    public void visit(MaxExclusive maxExclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> arrayList = new ArrayList<Number>();
            List<Number> list = ((NumberBase)this.datatype).getMaxExclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((NumberBase)this.datatype).removeMaxExclusive((Number)arrayList.get(n));
                }
            }
            ((NumberBase)this.datatype).addMaxExclusive(NumberBase.toNumber(maxExclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = ((TimeBase)this.datatype).getMaxExclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((TimeBase)this.datatype).removeMaxExclusive((String)arrayList.get(n));
                }
            }
            ((TimeBase)this.datatype).addMaxExclusive(maxExclusive.getValue());
        }
    }

    public void visit(MaxInclusive maxInclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> arrayList = new ArrayList<Number>();
            List<Number> list = ((NumberBase)this.datatype).getMaxInclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((NumberBase)this.datatype).removeMaxInclusive((Number)arrayList.get(n));
                }
            }
            ((NumberBase)this.datatype).addMaxInclusive(NumberBase.toNumber(maxInclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = ((TimeBase)this.datatype).getMaxInclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((TimeBase)this.datatype).removeMaxInclusive((String)arrayList.get(n));
                }
            }
            ((TimeBase)this.datatype).addMaxInclusive(maxInclusive.getValue());
        }
    }

    public void visit(MinExclusive minExclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> arrayList = new ArrayList<Number>();
            List<Number> list = ((NumberBase)this.datatype).getMinExclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((NumberBase)this.datatype).removeMinExclusive((Number)arrayList.get(n));
                }
            }
            ((NumberBase)this.datatype).addMinExclusive(NumberBase.toNumber(minExclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = ((TimeBase)this.datatype).getMinExclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((TimeBase)this.datatype).removeMinExclusive((String)arrayList.get(n));
                }
            }
            ((TimeBase)this.datatype).addMinExclusive(minExclusive.getValue());
        }
    }

    public void visit(MinInclusive minInclusive) {
        assert (this.facetParent instanceof SimpleRestriction);
        if (this.datatype instanceof NumberBase) {
            ArrayList<Number> arrayList = new ArrayList<Number>();
            List<Number> list = ((NumberBase)this.datatype).getMinInclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((NumberBase)this.datatype).removeMinInclusive((Number)arrayList.get(n));
                }
            }
            ((NumberBase)this.datatype).addMinInclusive(NumberBase.toNumber(minInclusive.getValue()));
        } else if (this.datatype instanceof TimeBase) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = ((TimeBase)this.datatype).getMinInclusives();
            if (list != null && list.size() > 0) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    ((TimeBase)this.datatype).removeMinInclusive((String)arrayList.get(n));
                }
            }
            ((TimeBase)this.datatype).addMinInclusive(minInclusive.getValue());
        }
    }

    public void visit(MaxLength maxLength) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        List<? extends Number> list = this.datatype.getMaxLengths();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeMaxLength((Number)arrayList.get(n));
            }
        }
        this.datatype.addMaxLength(maxLength.getValue());
    }

    public void visit(MinLength minLength) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        List<? extends Number> list = this.datatype.getMinLengths();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeMinLength((Number)arrayList.get(n));
            }
        }
        this.datatype.addMinLength(minLength.getValue());
    }

    public void visit(Pattern pattern) {
        assert (this.facetParent instanceof SimpleRestriction);
        this.datatype.addPattern(pattern.getValue());
    }

    public void visit(TotalDigits totalDigits) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        List<? extends Number> list = this.datatype.getTotalDigits();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeTotalDigits((Number)arrayList.get(n));
            }
        }
        this.datatype.addTotalDigits(totalDigits.getValue());
    }

    public void visit(Whitespace whitespace) {
        assert (this.facetParent instanceof SimpleRestriction);
        ArrayList<Whitespace.Treatment> arrayList = new ArrayList<Whitespace.Treatment>();
        List<Whitespace.Treatment> list = this.datatype.getWhiteSpaces();
        if (list != null && list.size() > 0) {
            int n;
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.datatype.removeWhitespace((Whitespace.Treatment)arrayList.get(n));
            }
        }
        this.datatype.addWhitespace(whitespace.getValue());
    }

    Datatype getDatatype(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof LocalAttribute) {
            return this.createDatatype((LocalAttribute)schemaComponent);
        }
        if (schemaComponent instanceof GlobalAttribute) {
            return this.createDatatype((GlobalAttribute)schemaComponent);
        }
        if (schemaComponent instanceof AttributeReference) {
            return this.createDatatype((GlobalAttribute)((AttributeReference)schemaComponent).getRef().get());
        }
        if (schemaComponent instanceof LocalElement) {
            return this.createDatatype((LocalElement)schemaComponent);
        }
        if (schemaComponent instanceof GlobalElement) {
            return this.createDatatype((GlobalElement)schemaComponent);
        }
        if (schemaComponent instanceof ElementReference) {
            return this.createDatatype((GlobalElement)((ElementReference)schemaComponent).getRef().get());
        }
        if (schemaComponent instanceof GlobalSimpleType) {
            return new CustomDatatype(((GlobalSimpleType)schemaComponent).getName(), this.createDatatype((SimpleType)schemaComponent));
        }
        return null;
    }

    Datatype getDatatype(SimpleType simpleType) {
        return this.createDatatype(simpleType);
    }

    Datatype createDatatype(LocalAttribute localAttribute) {
        this.datatype = localAttribute.getType() != null ? this.createDatatype((SimpleType)localAttribute.getType().get()) : this.createDatatype((SimpleType)localAttribute.getInlineType());
        return this.datatype;
    }

    Datatype createDatatype(GlobalAttribute globalAttribute) {
        this.datatype = globalAttribute.getType() != null ? this.createDatatype((SimpleType)globalAttribute.getType().get()) : this.createDatatype((SimpleType)globalAttribute.getInlineType());
        return this.datatype;
    }

    Datatype createDatatype(LocalElement localElement) {
        if (localElement.getType() != null) {
            if (localElement.getType().get() instanceof SimpleType) {
                this.datatype = this.createDatatype((SimpleType)localElement.getType().get());
            }
        } else if (localElement.getInlineType() instanceof SimpleType) {
            this.datatype = this.createDatatype((SimpleType)localElement.getInlineType());
        }
        return this.datatype;
    }

    Datatype createDatatype(GlobalElement globalElement) {
        if (globalElement.getType() != null) {
            if (globalElement.getType().get() instanceof SimpleType) {
                this.datatype = this.createDatatype((SimpleType)globalElement.getType().get());
            }
        } else if (globalElement.getInlineType() instanceof SimpleType) {
            this.datatype = this.createDatatype((SimpleType)globalElement.getInlineType());
        }
        return this.datatype;
    }

    Datatype createDatatype(SimpleType simpleType) {
        this.datatype = null;
        try {
            this.datatype = this.doCreateDatatype(simpleType);
            if (simpleType instanceof GlobalSimpleType && this.model != null) {
                String string = ((GlobalSimpleType)simpleType).getName();
                for (GlobalSimpleType globalSimpleType : this.model.getSchemaModel().getSchema().getSimpleTypes()) {
                    if (!globalSimpleType.getName().equals(string)) continue;
                    return new CustomDatatype(string, this.datatype);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.datatype;
    }

    Datatype doCreateDatatype(SimpleType simpleType) {
        if (simpleType == null) {
            return null;
        }
        if (simpleType instanceof GlobalSimpleType) {
            this.datatype = DatatypeFactory.getDefault().createPrimitive(((GlobalSimpleType)simpleType).getName());
        }
        if (this.datatype == null) {
            SimpleTypeDefinition simpleTypeDefinition = simpleType.getDefinition();
            if (simpleTypeDefinition instanceof SimpleTypeRestriction) {
                GlobalSimpleType globalSimpleType = null;
                if (((SimpleTypeRestriction)simpleTypeDefinition).getBase() != null) {
                    SimpleRestriction simpleRestriction;
                    globalSimpleType = (GlobalSimpleType)((SimpleTypeRestriction)simpleTypeDefinition).getBase().get();
                    this.datatype = this.doCreateDatatype((SimpleType)globalSimpleType);
                    this.facetParent = simpleRestriction = (SimpleRestriction)simpleTypeDefinition;
                    this.findFacets(simpleRestriction);
                } else {
                    this.datatype = this.doCreateDatatype((SimpleType)((SimpleTypeRestriction)simpleTypeDefinition).getInlineType());
                }
            } else if (simpleTypeDefinition instanceof org.netbeans.modules.xml.schema.model.List) {
                org.netbeans.modules.xml.schema.model.List list = (org.netbeans.modules.xml.schema.model.List)simpleTypeDefinition;
                this.datatype = list.getType() != null ? this.doCreateDatatype((SimpleType)list.getType().get()) : this.doCreateDatatype((SimpleType)list.getInlineType());
            } else if (simpleTypeDefinition instanceof Union) {
                Datatype datatype;
                Union union = (Union)simpleTypeDefinition;
                UnionType unionType = new UnionType();
                if (union.getMemberTypes() != null) {
                    for (NamedComponentReference namedComponentReference : union.getMemberTypes()) {
                        datatype = this.doCreateDatatype((SimpleType)namedComponentReference.get());
                        if (datatype == null) continue;
                        unionType.addMemberType(datatype);
                    }
                }
                if (union.getInlineTypes() != null) {
                    for (NamedComponentReference namedComponentReference : union.getInlineTypes()) {
                        this.datatype = null;
                        datatype = this.doCreateDatatype((SimpleType)namedComponentReference);
                        if (datatype == null) continue;
                        unionType.addMemberType(datatype);
                    }
                    if (union.getInlineTypes().size() > 0) {
                        unionType.setHasFacets(true);
                    }
                }
                return unionType;
            }
        }
        return this.datatype;
    }

    void findFacets(SimpleRestriction simpleRestriction) {
        this.findFacets(simpleRestriction.getEnumerations());
        this.findFacets(simpleRestriction.getFractionDigits());
        this.findFacets(simpleRestriction.getLengths());
        this.findFacets(simpleRestriction.getMaxExclusives());
        this.findFacets(simpleRestriction.getMaxInclusives());
        this.findFacets(simpleRestriction.getMaxLengths());
        this.findFacets(simpleRestriction.getMinExclusives());
        this.findFacets(simpleRestriction.getMinInclusives());
        this.findFacets(simpleRestriction.getMinLengths());
        this.findFacets(simpleRestriction.getPatterns());
        this.findFacets(simpleRestriction.getTotalDigits());
        this.findFacets(simpleRestriction.getWhitespaces());
    }

    Datatype findPrimitive(Schema schema, String string) {
        Collection collection = schema.getSimpleTypes();
        for (GlobalSimpleType globalSimpleType : collection) {
            if (!globalSimpleType.getName().equals(string)) continue;
            return this.createDatatype((SimpleType)globalSimpleType);
        }
        return null;
    }

    void findFacets(Collection<? extends SchemaComponent> collection) {
        for (SchemaComponent schemaComponent : collection) {
            schemaComponent.accept((SchemaVisitor)this);
        }
    }

    Datatype getDatatype() {
        return this.datatype;
    }
}

