/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.casa;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceUnitTransferObject {
    private String serviceUnitName;
    private String serviceUnitDescription;
    private String componentName;
    private boolean isBC;
    private Document doc;
    private List<Endpoint> providesList;
    private List<Endpoint> consumesList;

    public JBIServiceUnitTransferObject(String string, String string2, String string3, String string4) {
        this.serviceUnitName = string;
        this.componentName = string2;
        this.serviceUnitDescription = string3;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(new InputSource(new StringReader(string4)));
            Element element = (Element)this.doc.getElementsByTagName("services").item(0);
            this.isBC = element.getAttribute("binding-component").equals("true");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isBindingComponent() {
        return this.isBC;
    }

    public String getServiceUnitName() {
        return this.serviceUnitName;
    }

    public String getServiceUnitDescription() {
        return this.serviceUnitDescription;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public List<Endpoint> getProvidesEndpoints() {
        if (this.providesList == null) {
            this.providesList = new ArrayList<Endpoint>();
            NodeList nodeList = this.doc.getElementsByTagName("provides");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute("endpoint-name");
                QName qName = this.getNSName(element, element.getAttribute("service-name"));
                QName qName2 = this.getNSName(element, element.getAttribute("interface-name"));
                Endpoint endpoint = new Endpoint(string, qName, qName2);
                this.providesList.add(endpoint);
            }
        }
        return this.providesList;
    }

    public List<Endpoint> getConsumesEndpoints() {
        if (this.consumesList == null) {
            this.consumesList = new ArrayList<Endpoint>();
            NodeList nodeList = this.doc.getElementsByTagName("consumes");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute("endpoint-name");
                QName qName = this.getNSName(element, element.getAttribute("service-name"));
                QName qName2 = this.getNSName(element, element.getAttribute("interface-name"));
                Endpoint endpoint = new Endpoint(string, qName, qName2);
                this.consumesList.add(endpoint);
            }
        }
        return this.consumesList;
    }

    private QName getNSName(Element element, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            return new QName(this.getNamespace(element, string3), string2);
        }
        return null;
    }

    public String getNamespace(Element element, String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        try {
            String string2;
            Node node;
            int n;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                node = namedNodeMap.item(n);
                string2 = node.getLocalName();
                if (string2 == null || !node.getLocalName().trim().equals(string.trim())) continue;
                return node.getNodeValue();
            }
            namedNodeMap = element.getOwnerDocument().getDocumentElement().getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                node = namedNodeMap.item(n);
                string2 = node.getLocalName();
                if (string2 == null || !node.getLocalName().trim().equals(string.trim())) continue;
                return node.getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public class Endpoint {
        private String endpointName;
        private QName serviceQName;
        private QName interfaceQName;

        Endpoint(String string, QName qName, QName qName2) {
            this.endpointName = string;
            this.serviceQName = qName;
            this.interfaceQName = qName2;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public QName getServiceQName() {
            return this.serviceQName;
        }

        public QName getInterfaceQName() {
            return this.interfaceQName;
        }
    }
}

