/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaBindingBadges;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetBinding;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.WsitClientConfigAction;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.WsitServerConfigAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CasaBadgeEditAction
extends WidgetAction.Adapter {
    private CasaModelGraphScene mScene;
    private Node mEditNode;

    public CasaBadgeEditAction(CasaModelGraphScene casaModelGraphScene) {
        this.mScene = casaModelGraphScene;
    }

    private boolean inBadge(WidgetAction.WidgetMouseEvent widgetMouseEvent, CasaBindingBadges.Badge badge, CasaNodeWidgetBinding casaNodeWidgetBinding) {
        Rectangle rectangle = casaNodeWidgetBinding.getBadges().getBadgeBoundsForParent(badge, casaNodeWidgetBinding);
        return rectangle.contains(widgetMouseEvent.getPoint());
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        this.mEditNode = null;
        if (widgetMouseEvent.getButton() != 1) {
            return WidgetAction.State.REJECTED;
        }
        CasaNodeWidgetBinding casaNodeWidgetBinding = (CasaNodeWidgetBinding)widget;
        if (this.inBadge(widgetMouseEvent, CasaBindingBadges.Badge.IS_EDITABLE, casaNodeWidgetBinding)) {
            CasaPort casaPort = (CasaPort)this.mScene.findObject(widget);
            if (casaPort == null || !this.mScene.getModel().isEditable(casaPort)) {
                return WidgetAction.State.REJECTED;
            }
            this.mEditNode = this.mScene.getNodeFactory().createNodeFor(casaPort);
            if (this.mEditNode == null) {
                return WidgetAction.State.REJECTED;
            }
            casaNodeWidgetBinding.getBadges().setBadgePressed(CasaBindingBadges.Badge.IS_EDITABLE, true);
            return WidgetAction.State.CONSUMED;
        }
        if (this.inBadge(widgetMouseEvent, CasaBindingBadges.Badge.WS_POLICY, casaNodeWidgetBinding)) {
            CasaPort casaPort = (CasaPort)this.mScene.findObject(widget);
            if (casaPort == null || !this.mScene.getModel().isEditable(casaPort)) {
                return WidgetAction.State.REJECTED;
            }
            this.mEditNode = this.mScene.getNodeFactory().createNodeFor(casaPort);
            if (this.mEditNode == null) {
                return WidgetAction.State.REJECTED;
            }
            casaNodeWidgetBinding.getBadges().setBadgePressed(CasaBindingBadges.Badge.WS_POLICY, true);
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    protected boolean isLocked() {
        return this.mEditNode != null;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        PropertySheet propertySheet = new PropertySheet();
        Node node = this.mEditNode;
        this.mEditNode = null;
        CasaNodeWidgetBinding casaNodeWidgetBinding = (CasaNodeWidgetBinding)widget;
        if (this.inBadge(widgetMouseEvent, CasaBindingBadges.Badge.IS_EDITABLE, casaNodeWidgetBinding)) {
            casaNodeWidgetBinding.getBadges().setBadgePressed(CasaBindingBadges.Badge.IS_EDITABLE, false);
            propertySheet.setNodes(new Node[]{node});
            Object[] objectArray = new Object[]{"Close"};
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertySheet, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"STR_PROPERTIES", (Object)node.getDisplayName()), true, objectArray, null, 0, null, null);
            dialogDescriptor.setClosingOptions(objectArray);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dialog.setVisible(true);
                }
            });
        } else if (this.inBadge(widgetMouseEvent, CasaBindingBadges.Badge.WS_POLICY, casaNodeWidgetBinding)) {
            casaNodeWidgetBinding.getBadges().setBadgePressed(CasaBindingBadges.Badge.WS_POLICY, false);
            CasaPort casaPort = (CasaPort)this.mScene.findObject(widget);
            HashSet<CasaPort> hashSet = new HashSet<CasaPort>();
            hashSet.add(casaPort);
            this.mScene.userSelectionSuggested(hashSet, false);
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem();
            JMenuItem jMenuItem2 = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)SystemAction.get(WsitServerConfigAction.class), (boolean)true);
            Actions.connect((JMenuItem)jMenuItem2, (Action)SystemAction.get(WsitClientConfigAction.class), (boolean)true);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            Point point = this.mScene.convertSceneToView(widget.convertLocalToScene(widgetMouseEvent.getPoint()));
            jPopupMenu.show(this.mScene.getView(), point.x, point.y);
        }
        return WidgetAction.State.CONSUMED;
    }
}

