/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.project.anttasks.AbstractJBIGenerator;
import org.netbeans.modules.xslt.project.anttasks.IDETMapCatalogModel;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEJBIGenerator
extends AbstractJBIGenerator {
    private Logger logger = Logger.getLogger(IDEJBIGenerator.class.getName());

    public IDEJBIGenerator(String srcDir, String buildDir) {
        super(srcDir, buildDir);
    }

    @Override
    protected <T extends ReferenceableWSDLComponent> T resolveReference(NamedComponentReference<T> ref) {
        if (ref == null) {
            return null;
        }
        return (T)((ReferenceableWSDLComponent)ref.get());
    }

    @Override
    protected TMapModel getTMapModel() {
        File transformmapFile = this.getTransformmapFile();
        if (transformmapFile == null) {
            this.logger.log(Level.SEVERE, "Error encountered while processing transformmap file - " + transformmapFile.getAbsolutePath());
            throw new BuildException("Can't find transformation descriptor");
        }
        TMapModel tMapModel = null;
        try {
            tMapModel = IDETMapCatalogModel.getDefault().getTMapModel(transformmapFile);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error while creating Tramsformap Model ", ex);
            throw new RuntimeException("Error while creating Transformmap Model ", ex);
        }
        if (tMapModel == null || !Model.State.VALID.equals((Object)tMapModel.getState())) {
            this.logger.log(Level.SEVERE, "Error while creating Transformmap Model - " + (tMapModel == null ? " is null" : " is not valid"));
            throw new BuildException("Error while creating Transformmap Model ");
        }
        return tMapModel;
    }
}

