/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneData;
import org.netbeans.modules.web.jsf.navigation.graph.XmlScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SceneSerializer {
    private static final String SCENE_ELEMENT = "Scene";
    private static final String SCENE_LAST_USED_SCOPE_ATTR = "Scope";
    private static final String SCENE_SCOPE_ATTR = "Scope";
    private static final String SCENE_SCOPE_ELEMENT = "Scope";
    private static final String VERSION_ATTR = "version";
    private static final String NODE_ELEMENT = "Node";
    private static final String NODE_ID_ATTR = "id";
    private static final String NODE_X_ATTR = "x";
    private static final String NODE_Y_ATTR = "y";
    private static final String NODE_ZOOM_ATTR = "zoom";
    private static final String VERSION_VALUE_1 = "1";
    private static final String VERSION_VALUE_2 = "2";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");

    private SceneSerializer() {
    }

    public static void serialize(PageFlowSceneData pageFlowSceneData, FileObject fileObject) {
        Node node;
        Node node2;
        if (fileObject == null || !fileObject.isValid()) {
            LOG.warning("Can not serialize locations because file is null.");
            return;
        }
        LOG.entering("SceneSerializer", "serialize");
        Document document = XMLUtil.createDocument((String)SCENE_ELEMENT, null, null, null);
        Node node3 = document.getFirstChild();
        SceneSerializer.setAttribute(document, node3, VERSION_ATTR, VERSION_VALUE_2);
        SceneSerializer.setAttribute(document, node3, "Scope", XmlScope.getInstance(pageFlowSceneData.getCurrentScopeStr()).toString());
        Node node4 = SceneSerializer.createScopeElement(document, pageFlowSceneData, XmlScope.SCOPE_FACES);
        if (node4 != null) {
            node3.appendChild(node4);
        }
        if ((node2 = SceneSerializer.createScopeElement(document, pageFlowSceneData, XmlScope.SCOPE_PROJECT)) != null) {
            node3.appendChild(node2);
        }
        if ((node = SceneSerializer.createScopeElement(document, pageFlowSceneData, XmlScope.SCOPE_ALL)) != null) {
            node3.appendChild(node);
        }
        SceneSerializer.writeToFile(document, fileObject);
        LOG.finest("Serializing to the follwoing file: " + fileObject.toString());
        LOG.exiting("SceneSerializer", "serialize");
    }

    private static final Node createScopeElement(Document document, PageFlowSceneData pageFlowSceneData, XmlScope xmlScope) {
        Element element = null;
        Map<String, PageFlowSceneData.PageData> map = pageFlowSceneData.getScopeData(xmlScope.getScope());
        if (map != null) {
            element = document.createElement("Scope");
            SceneSerializer.setAttribute(document, element, "Scope", xmlScope.toString());
            for (String string : map.keySet()) {
                PageFlowSceneData.PageData pageData = map.get(string);
                if (pageData == null) continue;
                Element element2 = document.createElement(NODE_ELEMENT);
                SceneSerializer.setAttribute(document, element2, NODE_ID_ATTR, string);
                SceneSerializer.setAttribute(document, element2, NODE_X_ATTR, Integer.toString(pageData.getPoint().x));
                SceneSerializer.setAttribute(document, element2, NODE_Y_ATTR, Integer.toString(pageData.getPoint().y));
                SceneSerializer.setAttribute(document, element2, NODE_ZOOM_ATTR, Boolean.toString(pageData.isMinimized()));
                element.appendChild(element2);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeToFile(Document document, FileObject fileObject) {
        OutputStream outputStream = null;
        try {
            outputStream = fileObject.getOutputStream();
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public static void deserializeV1(PageFlowSceneData pageFlowSceneData, FileObject fileObject) {
        LOG.entering("SceneSerializer", "deserializeV1(PageFlowSceneData sceneData, File file)");
        Node node = SceneSerializer.getRootNode(fileObject);
        HashMap<String, PageFlowSceneData.PageData> hashMap = new HashMap<String, PageFlowSceneData.PageData>();
        for (Node node2 : SceneSerializer.getChildNode(node)) {
            if (!NODE_ELEMENT.equals(node2.getNodeName())) continue;
            String string = SceneSerializer.getAttributeValue(node2, NODE_ID_ATTR);
            int n = Integer.parseInt(SceneSerializer.getAttributeValue(node2, NODE_X_ATTR));
            int n2 = Integer.parseInt(SceneSerializer.getAttributeValue(node2, NODE_Y_ATTR));
        }
        pageFlowSceneData.setScopeData(XmlScope.SCOPE_PROJECT.getScope(), hashMap);
        LOG.exiting("SceneSerializer", "deserialize");
    }

    public static void deserialize(PageFlowSceneData pageFlowSceneData, FileObject fileObject) {
        LOG.entering("SceneSerializer", "deserialize(PageFlowSceneData sceneData, File file)");
        Node node = SceneSerializer.getRootNode(fileObject);
        if (VERSION_VALUE_1.equals(SceneSerializer.getAttributeValue(node, VERSION_ATTR))) {
            SceneSerializer.deserializeV1(pageFlowSceneData, fileObject);
        } else if (VERSION_VALUE_2.equals(SceneSerializer.getAttributeValue(node, VERSION_ATTR))) {
            String string = SceneSerializer.getAttributeValue(node, "Scope");
            XmlScope xmlScope = XmlScope.getInstance(string);
            pageFlowSceneData.setCurrentScope(xmlScope.getScope());
            LOG.fine("Last Used Scope: " + xmlScope);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("Scope")) continue;
                String string2 = SceneSerializer.getAttributeValue(node2, "Scope");
                NodeList nodeList2 = node2.getChildNodes();
                HashMap<String, PageFlowSceneData.PageData> hashMap = new HashMap<String, PageFlowSceneData.PageData>();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    if (!node3.getNodeName().equals(NODE_ELEMENT)) continue;
                    String string3 = SceneSerializer.getAttributeValue(node3, NODE_ID_ATTR);
                    int n = Integer.parseInt(SceneSerializer.getAttributeValue(node3, NODE_X_ATTR));
                    int n2 = Integer.parseInt(SceneSerializer.getAttributeValue(node3, NODE_Y_ATTR));
                    boolean bl = false;
                    String string4 = SceneSerializer.getAttributeValue(node3, NODE_ZOOM_ATTR);
                    if (string4 != null) {
                        bl = Boolean.parseBoolean(string4);
                    }
                    PageFlowSceneData.PageData pageData = PageFlowSceneData.createPageData(new Point(n, n2), bl);
                    hashMap.put(string3, pageData);
                }
                pageFlowSceneData.setScopeData(XmlScope.getInstance(string2).getScope(), hashMap);
            }
        }
        LOG.exiting("SceneSerializer", "deserialize(PageFlowSceneData sceneData, File file)");
    }

    private static void setAttribute(Document document, Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        namedNodeMap.setNamedItem(attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(FileObject fileObject) {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            Document document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) {
                    Exceptions.printStackTrace((Throwable)sAXParseException);
                }
            }, null);
            Node node = document.getFirstChild();
            return node;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private static String getAttributeValue(Node node, String string) {
        try {
            Node node2;
            NamedNodeMap namedNodeMap;
            if (node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
                return node2.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            Exceptions.printStackTrace((Throwable)dOMException);
        }
        return null;
    }

    private static Node[] getChildNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node[] nodeArray = new Node[nodeList != null ? nodeList.getLength() : 0];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }
}

