/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.action.UseDatabaseGenerator;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.SelectDatabasePanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseDatabaseAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        FileObject fileObject = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
        try {
            ElementHandle<TypeElement> elementHandle = _RetoucheUtil.getJavaClassFromNode(nodeArray[0]);
            this.generate(fileObject, elementHandle);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private boolean generate(FileObject fileObject, ElementHandle<TypeElement> elementHandle) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer enterpriseReferenceContainer = (EnterpriseReferenceContainer)project.getLookup().lookup(EnterpriseReferenceContainer.class);
        ResourcesHolder resourcesHolder = this.getResources(j2eeModuleProvider, fileObject);
        final SelectDatabasePanel selectDatabasePanel = new SelectDatabasePanel(j2eeModuleProvider, enterpriseReferenceContainer.getServiceLocatorName(), resourcesHolder.getReferences(), resourcesHolder.getModuleDataSources(), resourcesHolder.getServerDataSources(), ClasspathInfo.create((FileObject)fileObject));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectDatabasePanel, NbBundle.getMessage(UseDatabaseAction.class, (String)"LBL_ChooseDatabase"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SelectDatabasePanel.class), null);
        dialogDescriptor.setValid(this.checkConnections(selectDatabasePanel));
        selectDatabasePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("SelectDatabasePanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid((Boolean)object != false && UseDatabaseAction.this.checkConnections(selectDatabasePanel));
                }
            }
        });
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == NotifyDescriptor.OK_OPTION) {
            String string = selectDatabasePanel.getDatasourceReference();
            UseDatabaseGenerator useDatabaseGenerator = new UseDatabaseGenerator();
            try {
                useDatabaseGenerator.generate(fileObject, elementHandle, j2eeModuleProvider, string, selectDatabasePanel.getDatasource(), selectDatabasePanel.createServerResources(), selectDatabasePanel.getServiceLocator());
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return false;
    }

    private ResourcesHolder getResources(final J2eeModuleProvider j2eeModuleProvider, final FileObject fileObject) {
        final ResourcesHolder resourcesHolder = new ResourcesHolder();
        ArrayList<2> arrayList = new ArrayList<2>(1);
        arrayList.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                context.progress(string);
                try {
                    UseDatabaseAction.this.populateDataSourceReferences(resourcesHolder, j2eeModuleProvider, fileObject);
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        ProgressSupport.invoke(arrayList);
        return resourcesHolder;
    }

    private void populateDataSourceReferences(final ResourcesHolder resourcesHolder, final J2eeModuleProvider j2eeModuleProvider, FileObject fileObject) throws ConfigurationException, IOException {
        final HashMap<String, Datasource> hashMap = new HashMap<String, Datasource>();
        resourcesHolder.setReferences(hashMap);
        resourcesHolder.setModuleDataSources(j2eeModuleProvider.getModuleDatasources());
        resourcesHolder.setServerDataSources(j2eeModuleProvider.getServerDatasources());
        if (j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    Ejb[] ejbArray;
                    EnterpriseBeans enterpriseBeans = ejbJarMetadata.getRoot().getEnterpriseBeans();
                    if (enterpriseBeans == null) {
                        return null;
                    }
                    for (Ejb ejb : ejbArray = enterpriseBeans.getEjbs()) {
                        ResourceRef[] resourceRefArray;
                        for (ResourceRef resourceRef : resourceRefArray = ejb.getResourceRef()) {
                            String string = resourceRef.getResRefName();
                            Datasource datasource = UseDatabaseAction.this.findDatasourceForReferenceForEjb(resourcesHolder, j2eeModuleProvider, string, ejb.getEjbName());
                            if (datasource == null) continue;
                            hashMap.put(string, datasource);
                        }
                    }
                    return null;
                }
            });
        } else if (j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.WAR)) {
            MetadataModel metadataModel = WebModule.getWebModule((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, Void>(){

                public Void run(WebAppMetadata webAppMetadata) throws Exception {
                    ResourceRef[] resourceRefArray;
                    for (ResourceRef resourceRef : resourceRefArray = webAppMetadata.getRoot().getResourceRef()) {
                        String string = resourceRef.getResRefName();
                        Datasource datasource = UseDatabaseAction.this.findDatasourceForReference(resourcesHolder, j2eeModuleProvider, string);
                        if (datasource == null) continue;
                        hashMap.put(string, datasource);
                    }
                    return null;
                }
            });
        }
    }

    private Datasource findDatasourceForReference(ResourcesHolder resourcesHolder, J2eeModuleProvider j2eeModuleProvider, String string) throws ConfigurationException {
        String string2 = j2eeModuleProvider.getConfigSupport().findDatasourceJndiName(string);
        if (string2 == null) {
            return null;
        }
        return this.findDataSource(resourcesHolder, string2);
    }

    public Datasource findDatasourceForReferenceForEjb(ResourcesHolder resourcesHolder, J2eeModuleProvider j2eeModuleProvider, String string, String string2) throws ConfigurationException {
        String string3 = j2eeModuleProvider.getConfigSupport().findDatasourceJndiNameForEjb(string2, string);
        if (string3 == null) {
            return null;
        }
        return this.findDataSource(resourcesHolder, string3);
    }

    private Datasource findDataSource(ResourcesHolder resourcesHolder, String string) {
        assert (resourcesHolder != null);
        assert (string != null);
        for (Datasource datasource : resourcesHolder.getModuleDataSources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        for (Datasource datasource : resourcesHolder.getServerDataSources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        FileObject fileObject = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] blArray = new boolean[1];
        try {
            final ElementHandle<TypeElement> elementHandle = _RetoucheUtil.getJavaClassFromNode(nodeArray[0]);
            if (elementHandle == null || javaSource == null) {
                return false;
            }
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                    blArray[0] = ElementKind.INTERFACE == typeElement.getKind();
                }
            }, true);
            return elementHandle == null ? false : !blArray[0];
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean checkConnections(SelectDatabasePanel selectDatabasePanel) {
        return selectDatabasePanel.getDatasource() != null;
    }

    public String getName() {
        return NbBundle.getMessage(UseDatabaseAction.class, (String)"LBL_UseDbAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(UseDatabaseAction.class, (String)"HINT_UseDbAction"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourcesHolder {
        private Map<String, Datasource> references;
        private Set<Datasource> moduleDataSources;
        private Set<Datasource> serverDataSources;

        public void setReferences(Map<String, Datasource> map) {
            this.references = map;
        }

        public void setModuleDataSources(Set<Datasource> set) {
            this.moduleDataSources = set;
        }

        public void setServerDataSources(Set<Datasource> set) {
            this.serverDataSources = set;
        }

        public Map<String, Datasource> getReferences() {
            if (this.references == null) {
                this.references = new HashMap<String, Datasource>();
            }
            return this.references;
        }

        public Set<Datasource> getModuleDataSources() {
            if (this.moduleDataSources == null) {
                this.moduleDataSources = new HashSet<Datasource>();
            }
            return this.moduleDataSources;
        }

        public Set<Datasource> getServerDataSources() {
            if (this.moduleDataSources == null) {
                this.moduleDataSources = new HashSet<Datasource>();
            }
            return this.serverDataSources;
        }
    }
}

