/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageDestinationUiSupport {
    public static DestinationsHolder getDestinations(final J2eeModuleProvider j2eeModuleProvider) {
        assert (j2eeModuleProvider != null);
        final DestinationsHolder destinationsHolder = new DestinationsHolder();
        ProgressSupport.BackgroundAction backgroundAction = new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string = NbBundle.getMessage(MessageDestinationUiSupport.class, (String)"MSG_RetrievingDestinations");
                context.progress(string);
                try {
                    destinationsHolder.setModuleDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
                    destinationsHolder.setServerDestinations(j2eeModuleProvider.getConfigSupport().getServerMessageDestinations());
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            }
        };
        Set<1> set = Collections.singleton(backgroundAction);
        ProgressSupport.invoke(set);
        return destinationsHolder;
    }

    public static void populateDestinations(Set<MessageDestination> set, JComboBox jComboBox, MessageDestination messageDestination) {
        assert (set != null);
        assert (jComboBox != null);
        jComboBox.setRenderer(new MessageDestinationListCellRenderer());
        ArrayList<MessageDestination> arrayList = new ArrayList<MessageDestination>(set);
        Collections.sort(arrayList, new MessageDestinationComparator());
        jComboBox.removeAllItems();
        for (MessageDestination messageDestination2 : arrayList) {
            jComboBox.addItem(messageDestination2);
        }
        if (messageDestination != null) {
            jComboBox.setSelectedItem(messageDestination);
        }
    }

    public static MessageDestination createMessageDestination(J2eeModuleProvider j2eeModuleProvider, Set<MessageDestination> set, Set<MessageDestination> set2) {
        MessageDestination messageDestination2;
        assert (j2eeModuleProvider != null);
        assert (set != null);
        assert (set2 != null);
        HashMap<String, MessageDestination.Type> hashMap = new HashMap<String, MessageDestination.Type>();
        for (MessageDestination messageDestination2 : set) {
            hashMap.put(messageDestination2.getName(), messageDestination2.getType());
        }
        for (MessageDestination messageDestination2 : set2) {
            hashMap.put(messageDestination2.getName(), messageDestination2.getType());
        }
        MessageDestinationPanel messageDestinationPanel = MessageDestinationPanel.newInstance(hashMap);
        messageDestination2 = new DialogDescriptor((Object)messageDestinationPanel, NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_AddMessageDestination"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(MessageDestinationPanel.class), null);
        messageDestination2.setValid(false);
        messageDestinationPanel.addPropertyChangeListener(MessageDestinationPanel.IS_VALID, new PropertyChangeListener((DialogDescriptor)messageDestination2){
            final /* synthetic */ DialogDescriptor val$dialogDescriptor;
            {
                this.val$dialogDescriptor = dialogDescriptor;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof Boolean) {
                    this.val$dialogDescriptor.setValid(((Boolean)object).booleanValue());
                }
            }
        });
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)messageDestination2);
        MessageDestination messageDestination3 = null;
        if (object == DialogDescriptor.OK_OPTION) {
            messageDestination3 = MessageDestinationUiSupport.createMessageDestination(j2eeModuleProvider, messageDestinationPanel.getDestinationName(), messageDestinationPanel.getDestinationType());
        }
        return messageDestination3;
    }

    private static MessageDestination createMessageDestination(final J2eeModuleProvider j2eeModuleProvider, final String string, final MessageDestination.Type type) {
        final MessageDestination[] messageDestinationArray = new MessageDestination[1];
        ProgressSupport.BackgroundAction backgroundAction = new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string2 = NbBundle.getMessage(MessageDestinationUiSupport.class, (String)"MSG_CreatingDestination");
                context.progress(string2);
                try {
                    messageDestinationArray[0] = j2eeModuleProvider.getConfigSupport().createMessageDestination(string, type);
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            }
        };
        Set<3> set = Collections.singleton(backgroundAction);
        ProgressSupport.invoke(set);
        return messageDestinationArray[0];
    }

    private static class MessageDestinationListCellRenderer
    extends DefaultListCellRenderer {
        private MessageDestinationListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof MessageDestination) {
                MessageDestination messageDestination = (MessageDestination)object;
                this.setText(messageDestination.getName());
                String string = MessageDestination.Type.QUEUE.equals((Object)messageDestination.getType()) ? "LBL_Queue" : "LBL_Topic";
                StringBuilder stringBuilder = new StringBuilder(messageDestination.getName());
                stringBuilder.append(" [");
                stringBuilder.append(NbBundle.getMessage(MessageDestinationUiSupport.class, (String)string));
                stringBuilder.append("]");
                this.setToolTipText(stringBuilder.toString());
            } else {
                this.setText(object != null ? object.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageDestinationComparator
    implements Comparator<MessageDestination> {
        private MessageDestinationComparator() {
        }

        @Override
        public int compare(MessageDestination messageDestination, MessageDestination messageDestination2) {
            if (messageDestination == null) {
                return messageDestination2 == null ? 0 : -1;
            }
            if (messageDestination2 == null) {
                return 1;
            }
            String string = messageDestination.getName();
            String string2 = messageDestination2.getName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareToIgnoreCase(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DestinationsHolder {
        private Set<MessageDestination> moduleDestinations;
        private Set<MessageDestination> serverDestinations;

        public void setModuleDestinations(Set<MessageDestination> set) {
            this.moduleDestinations = set;
        }

        public void setServerDestinations(Set<MessageDestination> set) {
            this.serverDestinations = set;
        }

        public Set<MessageDestination> getModuleDestinations() {
            if (this.moduleDestinations == null) {
                this.moduleDestinations = new HashSet<MessageDestination>();
            }
            return this.moduleDestinations;
        }

        public Set<MessageDestination> getServerDestinations() {
            if (this.serverDestinations == null) {
                this.serverDestinations = new HashSet<MessageDestination>();
            }
            return this.serverDestinations;
        }
    }
}

