/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;

public final class SessionGenerator {
    public static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/SessionEjbClass.java";
    public static final String EJB21_LOCAL = "Templates/J2EE/EJB21/SessionLocal.java";
    public static final String EJB21_LOCALHOME = "Templates/J2EE/EJB21/SessionLocalHome.java";
    public static final String EJB21_REMOTE = "Templates/J2EE/EJB21/SessionRemote.java";
    public static final String EJB21_REMOTEHOME = "Templates/J2EE/EJB21/SessionRemoteHome.java";
    public static final String EJB30_STATELESS_EJBCLASS = "Templates/J2EE/EJB30/StatelessEjbClass.java";
    public static final String EJB30_STATEFUL_EJBCLASS = "Templates/J2EE/EJB30/StatefulEjbClass.java";
    public static final String EJB30_LOCAL = "Templates/J2EE/EJB30/SessionLocal.java";
    public static final String EJB30_REMOTE = "Templates/J2EE/EJB30/SessionRemote.java";
    private final FileObject pkg;
    private final boolean hasRemote;
    private final boolean hasLocal;
    private final boolean isStateful;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String remoteName;
    private final String remoteHomeName;
    private final String localName;
    private final String localHomeName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, String> templateParameters;

    public static SessionGenerator create(String string, FileObject fileObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return new SessionGenerator(string, fileObject, bl, bl2, bl3, bl4, bl5, bl6, false);
    }

    protected SessionGenerator(String string, FileObject fileObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.pkg = fileObject;
        this.hasRemote = bl;
        this.hasLocal = bl2;
        this.isStateful = bl3;
        this.isSimplified = bl4;
        this.isXmlBased = bl6;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getSessionEjbNamePrefix() + string + this.ejbNameOptions.getSessionEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getSessionEjbClassPrefix() + string + this.ejbNameOptions.getSessionEjbClassSuffix();
        this.remoteName = this.ejbNameOptions.getSessionRemotePrefix() + string + this.ejbNameOptions.getSessionRemoteSuffix();
        this.remoteHomeName = this.ejbNameOptions.getSessionRemoteHomePrefix() + string + this.ejbNameOptions.getSessionRemoteHomeSuffix();
        this.localName = this.ejbNameOptions.getSessionLocalPrefix() + string + this.ejbNameOptions.getSessionLocalSuffix();
        this.localHomeName = this.ejbNameOptions.getSessionLocalHomePrefix() + string + this.ejbNameOptions.getSessionLocalHomeSuffix();
        this.displayName = this.ejbNameOptions.getSessionDisplayNamePrefix() + string + this.ejbNameOptions.getSessionDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(fileObject);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, String>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("localInterface", this.packageNameWithDot + this.localName);
        this.templateParameters.put("remoteInterface", this.packageNameWithDot + this.remoteName);
        if (bl7) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public FileObject generate() throws IOException {
        FileObject fileObject = null;
        if (this.isSimplified) {
            fileObject = this.generateEJB30Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            fileObject = this.generateEJB21Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB21Xml();
            }
        }
        return fileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        FileObject fileObject = GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB21_REMOTE, (FileObject)this.pkg, (String)this.remoteName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_REMOTEHOME, (FileObject)this.pkg, (String)this.remoteHomeName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB21_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_LOCALHOME, (FileObject)this.pkg, (String)this.localHomeName, null, this.templateParameters);
        }
        return fileObject;
    }

    private FileObject generateEJB30Classes() throws IOException {
        String string = this.isStateful ? EJB30_STATEFUL_EJBCLASS : EJB30_STATELESS_EJBCLASS;
        FileObject fileObject = GenerationUtils.createClass((String)string, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB30_REMOTE, (FileObject)this.pkg, (String)this.remoteName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB30_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                ClassTree classTree;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                ClassTree classTree2 = classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (SessionGenerator.this.hasRemote) {
                    classTree2 = generationUtils.addImplementsClause(classTree2, SessionGenerator.this.packageNameWithDot + SessionGenerator.this.remoteName);
                }
                if (SessionGenerator.this.hasLocal) {
                    classTree2 = generationUtils.addImplementsClause(classTree2, SessionGenerator.this.packageNameWithDot + SessionGenerator.this.localName);
                }
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        }).commit();
        return fileObject;
    }

    private void generateEJB21Xml() throws IOException {
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar2 = DDProvider.getDefault().getDDRoot(ejbJar.getDeploymentDescriptor());
        EnterpriseBeans enterpriseBeans = ejbJar2.getEnterpriseBeans();
        Session session = null;
        if (enterpriseBeans == null) {
            enterpriseBeans = ejbJar2.newEnterpriseBeans();
            ejbJar2.setEnterpriseBeans(enterpriseBeans);
        }
        session = enterpriseBeans.newSession();
        session.setEjbName(this.ejbName);
        session.setDisplayName(this.displayName);
        session.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        if (this.hasRemote) {
            session.setRemote(this.packageNameWithDot + this.remoteName);
            session.setHome(this.packageNameWithDot + this.remoteHomeName);
        }
        if (this.hasLocal) {
            session.setLocal(this.packageNameWithDot + this.localName);
            session.setLocalHome(this.packageNameWithDot + this.localHomeName);
        }
        String string = "Stateless";
        if (this.isStateful) {
            string = "Stateful";
        }
        session.setSessionType(string);
        session.setTransactionType("Container");
        enterpriseBeans.addSession(session);
        AssemblyDescriptor assemblyDescriptor = ejbJar2.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ejbJar2.newAssemblyDescriptor();
            ejbJar2.setAssemblyDescriptor(assemblyDescriptor);
        }
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        ejbJar2.write(ejbJar.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }
}

