/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.designer.ColorManager;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.WebForm;

public class Marquee
extends Interaction {
    private WebForm webform = null;
    protected transient Cursor previousCursor = null;
    protected Rectangle marqueeBounds;
    protected Point startPoint;
    protected Point currentPoint;
    protected Point unsnappedStartPoint;
    private boolean snap = false;
    private boolean select = true;
    private boolean insertCursor = false;
    private CssBox gridBox;

    public Marquee(WebForm webForm, CssBox cssBox) {
        this.webform = webForm;
        this.gridBox = cssBox;
    }

    public void cancel(DesignerPane designerPane) {
        this.cleanup(designerPane);
        this.marqueeBounds = null;
    }

    private void cleanup(DesignerPane designerPane) {
        designerPane.setCursor(this.previousCursor);
        Rectangle rectangle = new Rectangle(this.marqueeBounds);
        ++rectangle.width;
        ++rectangle.height;
        designerPane.repaint(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && !mouseEvent.isConsumed() && this.marqueeBounds != null) {
                if (this.select) {
                    if (this.marqueeBounds.width != 0 || this.marqueeBounds.height != 0) {
                        this.webform.getSelection().selectComponentRectangle(this.marqueeBounds, true);
                    } else {
                        this.webform.getManager().getMouseHandler().selectAt(mouseEvent, false);
                    }
                }
                this.cleanup(this.webform.getPane());
                mouseEvent.consume();
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.startPoint != null) {
            this.currentPoint = mouseEvent.getPoint();
            DesignerPane designerPane = this.webform.getPane();
            Rectangle rectangle = this.marqueeBounds;
            if (this.snap) {
                this.currentPoint.x = this.webform.snapX(this.currentPoint.x, this.gridBox);
                this.currentPoint.y = this.webform.snapY(this.currentPoint.y, this.gridBox);
            }
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.marqueeBounds.add(this.currentPoint);
            Rectangle rectangle2 = rectangle != null ? this.marqueeBounds.union(rectangle) : new Rectangle(this.marqueeBounds);
            ++rectangle2.width;
            ++rectangle2.height;
            designerPane.repaint(rectangle2);
            mouseEvent.consume();
            int n = this.marqueeBounds.x;
            int n2 = this.marqueeBounds.y;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            designerPane.scrollRectToVisible(new Rectangle(this.currentPoint));
        }
    }

    public void paint(Graphics graphics) {
        if (this.marqueeBounds != null) {
            ColorManager colorManager = this.webform.getColors();
            graphics.setColor(colorManager.marqueeColor);
            graphics.fillRect(this.marqueeBounds.x + 1, this.marqueeBounds.y + 1, this.marqueeBounds.width - 1, this.marqueeBounds.height - 1);
            graphics.setColor(colorManager.marqueeColorBorder);
            graphics.drawRect(this.marqueeBounds.x, this.marqueeBounds.y, this.marqueeBounds.width, this.marqueeBounds.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            this.startPoint = mouseEvent.getPoint();
            DesignerPane designerPane = this.webform.getPane();
            if (this.snap) {
                this.unsnappedStartPoint = new Point(this.startPoint.x, this.startPoint.y);
                this.startPoint.x = this.webform.snapX(this.startPoint.x, this.gridBox);
                this.startPoint.y = this.webform.snapY(this.startPoint.y, this.gridBox);
            } else {
                this.unsnappedStartPoint = this.startPoint;
            }
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.previousCursor = designerPane.getCursor();
            if (this.insertCursor) {
                designerPane.setCursor(this.webform.getManager().getInsertCursor());
            } else {
                designerPane.setCursor(Cursor.getPredefinedCursor(1));
            }
            ImageIcon imageIcon = new ImageIcon(Marquee.class.getResource("/org/netbeans/modules/visualweb/designer/resources/drag_select.gif"));
            mouseEvent.consume();
        }
    }

    Rectangle getBounds() {
        return this.marqueeBounds;
    }

    Point getUnsnappedPosition() {
        return this.unsnappedStartPoint;
    }

    public void setSnapToGrid(boolean bl) {
        this.snap = bl;
    }

    public void setSelect(boolean bl) {
        this.select = bl;
    }

    public void setInsertCursor(boolean bl) {
        this.insertCursor = true;
    }
}

