/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.DocumentBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.FrameSetBox;
import org.netbeans.modules.visualweb.designer.ColorManager;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.text.DesignerPaneBase;
import org.openide.ErrorManager;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageBox
extends DocumentBox
implements ChangeListener {
    private boolean dark;
    private Color constraintsColor = null;
    private Color constraintsColorLight = null;
    protected boolean isTopLevel = true;
    private int componentVisibleWidth = Integer.MAX_VALUE;
    private int componentVisibleHeight = Integer.MAX_VALUE;
    private CssBox selected;

    private PageBox(DesignerPane designerPane, WebForm webForm, Element element) {
        this(designerPane, webForm, element, BoxType.STATIC, false, false);
    }

    protected PageBox(DesignerPane designerPane, WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        super(designerPane, webForm, element, boxType, bl, bl2);
        this.pane = designerPane;
        this.body = element;
        if (this.bg == null) {
            this.bg = Color.WHITE;
        }
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public static PageBox getPageBox(DesignerPane designerPane, WebForm webForm, Element element) {
        if (element.getTagName().equals(HtmlTag.FRAMESET.name)) {
            return FrameSetBox.getFrameSetBox(designerPane, webForm, element, BoxType.STATIC, HtmlTag.FRAMESET, false);
        }
        return new PageBox(designerPane, webForm, element);
    }

    public void boxAdded() {
    }

    public void boxRemoved() {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this);
        }
    }

    public Color getBackground() {
        return this.bg;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, 0, 0);
    }

    public void removed(Node node, Node node2) {
        super.removed(node, node2);
        this.selected = null;
    }

    public void paint(Graphics graphics, int n, int n2) {
        Element element;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!this.isTopLevel) {
            super.paint(graphics, n, n2);
            return;
        }
        this.layout();
        if (!this.layoutValid) {
            return;
        }
        super.paint(graphics, n, n2);
        if (this.selected != null && this.selected != this) {
            n6 = this.selected.getAbsoluteX();
            n5 = this.selected.getAbsoluteY();
            n4 = this.selected.getWidth();
            n3 = this.selected.getHeight();
            if (Math.abs(n6) < 50000 && Math.abs(n5) < 50000 && Math.abs(n4) < 50000 && Math.abs(n3) < 50000) {
                graphics.setColor(Color.RED);
                graphics.drawRect(n6, n5, n4, n3);
            }
        }
        if (this.webform.getPageSizeWidth() != -1) {
            n6 = this.webform.getPageSizeWidth();
            n5 = this.webform.getPageSizeHeight();
            if (this.constraintsColor == null) {
                this.constraintsColor = new Color(128, 128, 128, 208);
                this.constraintsColorLight = new Color(216, 216, 216, 96);
            }
            n4 = this.width;
            n3 = this.height;
            graphics.setColor(this.constraintsColor);
            if (n4 > n6) {
                graphics.fillRect(n6, 0, n4 - n6, n3);
            }
            graphics.setColor(this.constraintsColorLight);
            if (n3 > n5) {
                graphics.fillRect(0, n5, n6, n3 - n5);
            }
            graphics.setColor(Color.WHITE);
            graphics.drawString("(" + n6 + "," + n5 + ")", n6 + 10, n5 + 10);
        } else if (this.webform.isPaintSizeMask() && (element = this.webform.getHtmlBody()) != null && (n5 = CssUtilities.getCssLength(element, 58)) != 0x7FFFFFFE && (n4 = CssUtilities.getCssLength(element, 31)) != 0x7FFFFFFE) {
            n3 = n5;
            int n7 = n4;
            if (this.constraintsColor == null) {
                this.constraintsColor = new Color(128, 128, 128, 208);
                this.constraintsColorLight = new Color(216, 216, 216, 96);
            }
            graphics.setColor(this.constraintsColorLight);
            if (this.width > n3) {
                graphics.fillRect(n3, 0, this.width - n3, this.height);
            }
            if (this.height > n7) {
                graphics.fillRect(0, n7, n3, this.height - n7);
            }
        }
    }

    protected void paintBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.webform.getColors().sync();
        if (!this.isTopLevel || this.viewport == null) {
            super.paintBox(graphics, n, n2, n3, n4);
            return;
        }
        int n5 = n;
        int n6 = n2;
        Dimension dimension = this.viewport.getExtentSize();
        Point point = this.viewport.getViewPosition();
        n = point.x;
        n2 = point.y;
        n3 = dimension.width;
        n4 = dimension.height;
        if (this.border != null) {
            this.border.paintBorder(graphics, n, n2, n3, n4);
        }
        n += this.leftBorderWidth;
        n2 += this.topBorderWidth;
        n3 -= this.leftBorderWidth;
        n3 -= this.rightBorderWidth;
        n4 -= this.topBorderWidth;
        n4 -= this.bottomBorderWidth;
        if (this.bg != null) {
            graphics.setColor(this.bg);
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this.bgPainter != null) {
            this.bgPainter.paint(graphics, n5, n6, n3 + (n - n5), n4 + (n2 - n6));
        }
        if (this.grid && this.webform.isGridShow()) {
            if (this.hidden && !(this instanceof PageBox)) {
                return;
            }
            this.paintGrid(graphics, n, n2, n3, n4);
        }
    }

    protected void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.isTopLevel || this.viewport == null) {
            return;
        }
        Dimension dimension = this.viewport.getExtentSize();
        Point point = this.viewport.getViewPosition();
        int n5 = point.x;
        int n6 = point.y;
        int n7 = dimension.width;
        int n8 = dimension.height;
        if (DesignerPane.INCREMENTAL_LAYOUT) {
            if (n5 < DesignerPane.clip.x) {
                n7 -= DesignerPane.clip.x - n5;
                n5 = DesignerPane.clip.x;
            }
            if (n6 < DesignerPane.clip.y) {
                n8 -= DesignerPane.clip.y - n6;
                n6 = DesignerPane.clip.y;
            }
            if (n5 + n7 > DesignerPane.clipBr.x) {
                n7 = DesignerPane.clipBr.x - n5;
            }
            if (n6 + n8 > DesignerPane.clipBr.y) {
                n8 = DesignerPane.clipBr.y - n6;
            }
        }
        int n9 = this.webform.getGridWidth();
        int n10 = this.webform.getGridHeight();
        int n11 = n5 % n9;
        int n12 = n6 % n10;
        super.paintGrid(graphics, n5 - n11, n6 - n12, n7 + n11, n8 + n12);
    }

    public void setViewport(JViewport jViewport) {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this);
        }
        this.viewport = jViewport;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.viewport) {
            if (!this.pane.isShowing()) {
                return;
            }
            boolean bl = false;
            Point point = this.viewport.getViewPosition();
            if (point.x != this.viewportX || point.y != this.viewportY) {
                this.viewportX = point.x;
                this.viewportY = point.y;
                bl = true;
                this.webform.getSelection().notifyScrolled();
            }
            if (this.fixedBoxes != null && bl) {
                this.updateFixedPositions();
                this.pane.repaint();
                return;
            }
            if (this.viewport.getParent() instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)this.viewport.getParent();
                Dimension dimension = jScrollPane.getSize();
                if (this.componentVisibleWidth != dimension.width) {
                    this.componentVisibleWidth = dimension.width;
                    this.componentVisibleHeight = dimension.height;
                    if (this.layoutValid) {
                        this.redoLayout(true);
                    }
                    return;
                }
                if (this.componentVisibleHeight != dimension.height) {
                    this.componentVisibleHeight = dimension.height;
                    if (this.layoutValid) {
                        this.redoLayout(true);
                    }
                    return;
                }
            } else {
                ErrorManager.getDefault().log("Unexpected viewport parent");
            }
        }
    }

    private void updateFixedPositions() {
        int n = this.fixedBoxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.fixedBoxes.get(i);
            cssBox.setLocation(cssBox.left + this.viewportX, cssBox.top + this.viewportY);
        }
    }

    public void layout() {
        int n;
        Serializable serializable;
        if (this.layoutValid) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.viewport != null) {
            Serializable serializable2;
            if (this.viewport.getParent() instanceof JScrollPane) {
                serializable2 = (JScrollPane)this.viewport.getParent();
                serializable = ((Component)serializable2).getSize();
                n2 = ((Dimension)serializable).width;
                this.componentVisibleWidth = ((Dimension)serializable).width;
                this.componentVisibleHeight = ((Dimension)serializable).height;
                n3 = ((Dimension)serializable).height;
                Insets insets = ((JComponent)serializable2).getInsets();
                n2 -= insets.left;
                n2 -= insets.right;
                n3 -= insets.top;
                n3 -= insets.bottom;
                --n2;
                --n3;
            } else {
                serializable2 = this.viewport.getExtentSize();
                n2 = ((Dimension)serializable2).width;
                n3 = ((Dimension)serializable2).height;
                this.componentVisibleWidth = n2;
                this.componentVisibleHeight = n3;
            }
        } else {
            n2 = this.maxWidth;
        }
        if (n2 <= 0) {
            return;
        }
        int n4 = n2;
        if (this.webform.getPageSizeWidth() != -1 && (n = this.webform.getPageSizeWidth()) < n4) {
            n4 = n;
        }
        this.relayout(this.viewport, n2, n3, n4);
        if (!(this.webform.isGridMode() || (serializable = this.webform.getPane()) == null || ((DesignerPaneBase)serializable).hasCaret() && ((DesignerPaneBase)serializable).getCaretDot() != DomProvider.DomPosition.NONE)) {
            ((DesignerPane)serializable).showCaretAtBeginning();
        }
    }

    protected void updateSizeInfo() {
        super.updateSizeInfo();
        if (this.viewport != null) {
            Point point = this.viewport.getViewPosition();
            Dimension dimension = this.viewport.getViewSize();
            this.viewport.removeChangeListener(this);
            this.viewport.setViewSize(new Dimension(this.width, this.height));
            if (point.x > 0 || point.y > 0) {
                point.x = dimension.width > 0 ? point.x * this.width / dimension.width : 0;
                point.y = dimension.height > 0 ? point.y * this.height / dimension.height : 0;
                this.viewport.setViewPosition(point);
            }
            this.viewport.addChangeListener(this);
        }
    }

    public void setSize(int n, int n2) {
        if (!this.layoutValid) {
            this.maxWidth = n;
        }
    }

    public void relayout(FormatContext formatContext) {
        this.layout();
    }

    public void redoLayout(boolean bl) {
        this.initializeInvariants();
        super.redoLayout(bl);
        if (this.pane != null) {
            this.pane.repaint();
        }
    }

    public float getPreferredSpan(int n) {
        if (!this.layoutValid) {
            if (this.context != null) {
                if (this.viewport != null) {
                    return n == 0 ? (float)Math.max(this.layoutWidth, this.viewport.getExtentSize().width) : (float)Math.max(this.layoutHeight, this.viewport.getExtentSize().height);
                }
                return n == 0 ? (float)this.layoutWidth : (float)this.layoutHeight;
            }
            return 1.0f;
        }
        if (this.layoutValid && this.context != null) {
            if (this.viewport != null) {
                return n == 0 ? (float)Math.max(this.layoutWidth, this.viewport.getExtentSize().width) : (float)Math.max(this.layoutHeight, this.viewport.getExtentSize().height);
            }
            return n == 0 ? (float)this.layoutWidth : (float)this.layoutHeight;
        }
        return n == 0 ? (float)this.getWidth() : (float)this.getHeight();
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    protected String paramString() {
        return "PageBox[" + super.paramString() + "]-element=" + this.getElement();
    }

    public void setSelected(CssBox cssBox) {
        if (cssBox != this.selected) {
            this.selected = cssBox;
            this.pane.repaint();
        }
    }

    public CssBox getSelected() {
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createPreviewImage(int n, int n2) {
        if (!this.layoutValid) {
            this.maxWidth = 1024;
        }
        try {
            this.layout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (!this.layoutValid) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        try {
            graphics2D.setClip(0, 0, n, n2);
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n, n2);
            if (this.width > 0) {
                graphics2D.setClip(0, 0, this.width, this.width * n2 / n);
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = (double)n / (double)this.width;
                graphics2D.scale(d, d);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.getClipBounds(DesignerPane.clip);
                DesignerPane.clipBr.x = DesignerPane.clip.x + DesignerPane.clip.width;
                DesignerPane.clipBr.y = DesignerPane.clip.y + DesignerPane.clip.height;
                this.paint(graphics2D);
                graphics2D.setTransform(affineTransform);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage paintCssPreview(Graphics2D graphics2D, String string, Element element, DocumentFragment documentFragment, Element element2, int n, int n2) {
        BufferedImage bufferedImage;
        block22: {
            Rectangle rectangle;
            int n3;
            Object object;
            this.setGrid(false);
            if (!this.layoutValid) {
                this.maxWidth = 1024;
            }
            try {
                object = new CreateContext();
                ((CreateContext)object).pushPage(this.webform);
                ((CreateContext)object).metrics = CssUtilities.getDesignerFontMetricsForElement(this.body, null, this.webform.getDefaultFontSize());
                if (documentFragment != null) {
                    NodeList nodeList = documentFragment.getChildNodes();
                    int n4 = nodeList.getLength();
                    this.setProbableChildCount(n4);
                    n3 = n4;
                    for (int i = 0; i < n3; ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() == 3 && DesignerUtils.onlyWhitespace(node.getNodeValue())) continue;
                        this.addNode((CreateContext)object, node, element2, null, null);
                    }
                } else {
                    this.addNode((CreateContext)object, element2, element2, null, null);
                }
                int n5 = n;
                this.relayout(null, n, n2, n5);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return null;
            }
            if (!this.layoutValid) {
                return null;
            }
            object = this.findCssBoxForComponentRootElement(element);
            if (object == null) {
                rectangle = this.computeBounds(element, null);
                if (rectangle == null) {
                    return null;
                }
                this.width = rectangle.width;
                this.height = rectangle.height;
                object = this;
            } else {
                this.width = ((CssBox)object).getWidth();
                this.height = ((CssBox)object).getHeight();
                rectangle = new Rectangle(0, 0, this.width, this.height);
            }
            if (this.width <= 0 || this.width >= 3000) {
                return null;
            }
            if (this.height <= 0 || this.height >= 3000) {
                return null;
            }
            bufferedImage = null;
            if (graphics2D != null) {
                GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
                bufferedImage = graphicsConfiguration.createCompatibleImage(this.width, this.height);
            } else {
                bufferedImage = new BufferedImage(this.width, this.height, 1);
            }
            if (bufferedImage != null) {
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                try {
                    graphics2D2.setClip(0, 0, this.width, this.height);
                    graphics2D2.setColor(this.getBackground());
                    graphics2D2.fillRect(0, 0, this.width, this.height);
                    if (this.width <= 0) break block22;
                    n3 = DesignerPane.INCREMENTAL_LAYOUT ? 1 : 0;
                    DesignerPane.INCREMENTAL_LAYOUT = false;
                    int n6 = ((CssBox)object).getX();
                    int n7 = ((CssBox)object).getY();
                    int n8 = ((CssBox)object).getLeftMargin();
                    int n9 = ((CssBox)object).getEffectiveTopMargin();
                    ((CssBox)object).setLocation(0, 0);
                    ((CssBox)object).setMargins(0, 0);
                    if (object == this) {
                        this.context.initialCB.x = -rectangle.x;
                        this.context.initialCB.y = -rectangle.y;
                    }
                    try {
                        ((CssBox)object).paint(graphics2D2, -rectangle.x, -rectangle.y);
                    }
                    finally {
                        DesignerPane.INCREMENTAL_LAYOUT = n3;
                        ((CssBox)object).setLocation(n6, n7);
                        ((CssBox)object).setMargins(n8, n9);
                    }
                }
                finally {
                    graphics2D2.dispose();
                }
            }
        }
        return bufferedImage;
    }

    public CssBox findCssBox(int n, int n2) {
        CssBox cssBox = this.findCssBox(n, n2, this.leftMargin, this.effectiveTopMargin, 0);
        if (cssBox == null) {
            cssBox = this;
        }
        return cssBox;
    }

    protected void initializeGrid() {
        if (this.webform.isGridMode()) {
            this.setGrid(true);
        }
    }

    protected void initializeBackground() {
        super.initializeBackground();
        if (this.bg == null) {
            this.bg = Color.white;
        }
        this.dark = ColorManager.isDark(this.bg);
    }

    public boolean isDarkBackground() {
        return this.dark;
    }
}

