/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.api.designer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.util.EventListener;
import javax.swing.JComponent;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProviderService;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.netbeans.spi.palette.PaletteController;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public interface DomProvider {
    public static final int DROP_DENIED = 0;
    public static final int DROP_PARENTED = 1;
    public static final int DROP_LINKED = 2;

    public Document getHtmlDom();

    public Element getHtmlBody();

    public PaletteController getPaletteController();

    public boolean canImport(JComponent var1, DataFlavor[] var2, Transferable var3);

    public int computeActions(Element var1, Transferable var2);

    public int processLinks(Element var1, Element var2);

    public boolean isGridMode();

    public URL getBaseUrl();

    public URL resolveUrl(String var1);

    public boolean canDropComponentsAtNode(Element[] var1, Node var2);

    public boolean isFormComponent(Element var1);

    public int getDropType(Element var1, Element var2, Transferable var3, boolean var4);

    public int getDropTypeForComponent(Element var1, Element var2, Element var3, boolean var4);

    public Element getComponentRootElementEquivalentTo(Element var1);

    public boolean canHighlightComponentRootElmenet(Element var1);

    public boolean moveComponent(Element var1, Node var2, Node var3);

    public InlineEditorSupport createInlineEditorSupport(Element var1, String var2, String var3);

    public void importString(Designer var1, String var2, Point var3, Node var4, int var5, Dimension var6, boolean var7, Element var8, Element var9);

    public boolean importData(Designer var1, JComponent var2, Transferable var3, Point var4, Node var5, int var6, Dimension var7, boolean var8, Element var9, Element var10, int var11);

    public Designer[] getExternalDesigners(URL var1);

    public boolean hasCachedExternalFrames();

    public DomDocument getDomDocument();

    public int compareBoundaryPoints(Node var1, int var2, Node var3, int var4);

    public DomPosition createDomPosition(Node var1, int var2, DomPosition.Bias var3);

    public DomPosition createDomPosition(Node var1, boolean var2);

    public DomRange createDomRange(Node var1, int var2, Node var3, int var4);

    public DomPosition first(DomPosition var1, DomPosition var2);

    public DomPosition last(DomPosition var1, DomPosition var2);

    public boolean isRenderedNode(Node var1);

    public void paintDesignerDecorations(Graphics2D var1, Designer var2);

    public Decoration getDecoration(Element var1);

    public DomProviderService getDomProviderService();

    public static interface DomDocumentEvent {
        public DomDocument getDomDocument();

        public DomPosition getDomPosition();
    }

    public static interface DomDocumentListener
    extends EventListener {
        public void insertUpdate(DomDocumentEvent var1);

        public void componentMoved(DomDocumentEvent var1);

        public void componentsMoved(DomDocumentEvent var1);

        public void componentMovedTo(DomDocumentEvent var1);
    }

    public static interface DomRange {
        public static final DomRange NONE = new NoneDomRange();

        public DomPosition getDot();

        public DomPosition getMark();

        public void setDot(Node var1, int var2, DomPosition.Bias var3);

        public void setMark(Node var1, int var2, DomPosition.Bias var3);

        public void setRange(Node var1, int var2, Node var3, int var4);

        public void detach();

        public DomPosition getFirstPosition();

        public DomPosition getLastPosition();

        public boolean isDot(DomPosition var1);

        public boolean isEmpty();

        public boolean isReadOnlyRegion();

        public static class NoneDomRange
        implements DomRange {
            public DomPosition getDot() {
                return DomPosition.NONE;
            }

            public DomPosition getMark() {
                return DomPosition.NONE;
            }

            public void setDot(Node node, int n, DomPosition.Bias bias) {
            }

            public void setMark(Node node, int n, DomPosition.Bias bias) {
            }

            public void setRange(Node node, int n, Node node2, int n2) {
            }

            public void detach() {
            }

            public DomPosition getFirstPosition() {
                return DomPosition.NONE;
            }

            public DomPosition getLastPosition() {
                return DomPosition.NONE;
            }

            public boolean isDot(DomPosition domPosition) {
                return domPosition == DomPosition.NONE;
            }

            public boolean isEmpty() {
                return true;
            }

            public boolean isReadOnlyRegion() {
                return true;
            }
        }
    }

    public static interface DomPosition {
        public static final DomPosition NONE = new NoneDomPosition();

        public Node getNode();

        public int getOffset();

        public Bias getBias();

        public boolean isEarlierThan(DomPosition var1);

        public boolean isLaterThan(DomPosition var1);

        public boolean isStrictlyEarlierThan(DomPosition var1);

        public Element getTargetElement();

        public boolean isInside(Element var1);

        public boolean isRenderedPosition();

        public DomPosition getRenderedPosition();

        public boolean isSourcePosition();

        public DomPosition getSourcePosition();

        public static class NoneDomPosition
        implements DomPosition {
            private NoneDomPosition() {
            }

            public Node getNode() {
                return null;
            }

            public int getOffset() {
                return -1;
            }

            public Bias getBias() {
                return Bias.FORWARD;
            }

            public boolean isEarlierThan(DomPosition domPosition) {
                return false;
            }

            public boolean isLaterThan(DomPosition domPosition) {
                return false;
            }

            public boolean isStrictlyEarlierThan(DomPosition domPosition) {
                return false;
            }

            public Element getTargetElement() {
                return null;
            }

            public boolean isInside(Element element) {
                return false;
            }

            public boolean isRenderedPosition() {
                return false;
            }

            public DomPosition getRenderedPosition() {
                return this;
            }

            public boolean isSourcePosition() {
                return false;
            }

            public DomPosition getSourcePosition() {
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Bias {
            FORWARD,
            BACKWARD;

        }
    }

    public static interface DomDocument {
        public void addDomDocumentListener(DomDocumentListener var1);

        public void removeDomDocumentListener(DomDocumentListener var1);

        public boolean insertString(Designer var1, DomRange var2, String var3);

        public boolean deleteRangeContents(DomRange var1);

        public boolean deleteNextChar(Designer var1, DomRange var2);

        public boolean deletePreviousChar(Designer var1, DomRange var2);

        public void deleteComponents(Element[] var1);

        public String getRangeText(DomRange var1);

        public void moveComponents(Designer var1, Designer.Box[] var2, Point[] var3, DomPosition var4, int var5, int var6, boolean var7);

        public void resizeComponent(Designer var1, Element var2, int var3, boolean var4, int var5, boolean var6, int var7, boolean var8, int var9, boolean var10, Designer.Box var11, boolean var12);

        public void frontComponents(Designer.Box[] var1);

        public void backComponents(Designer.Box[] var1);
    }

    public static interface InlineEditorSupport {
        public String getValueSource();

        public boolean isEditingAllowed();

        public void unset();

        public void setValue(String var1);

        public String getName();

        public String expandHtmlEntities(String var1, boolean var2);

        public Element getRenderedElement();

        public DomPosition getBeginPosition();

        public DomPosition getEndPosition();

        public DocumentFragment getFragment();

        public Node getText();

        public boolean prepareAttributeInlineEditor(boolean var1);

        public void cleanAttributeInlineEditor(boolean var1);

        public String getSpecialInitValue();

        public boolean isEscaped();

        public Node findXPathNodeForComponentRootElement(Element var1);
    }
}

