/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.marking.HierarchicalMark;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public class DrillDown
implements IDrillDown,
CCTResultsFilter.Evaluator {
    private final List ddPath = new ArrayList(5);
    private final Map netTimeMap = new HashMap();
    private final Map timeMap = new HashMap();
    private final ProfilerClient client;
    private final Set listeners = Collections.synchronizedSet(new HashSet());
    private final boolean secondTime;
    private final boolean validFlag;
    private HierarchicalMark currentMark;
    private HierarchicalMark root;
    private boolean isSelf = false;

    public DrillDown(ProfilerClient profilerClient, HierarchicalMark hierarchicalMark, boolean bl) {
        this.root = hierarchicalMark;
        this.secondTime = bl;
        this.client = profilerClient;
        this.reset();
        this.validFlag = !hierarchicalMark.getChildren().isEmpty();
    }

    public DrillDown(ProfilerClient profilerClient, HierarchicalMark hierarchicalMark) {
        this(profilerClient, hierarchicalMark, false);
    }

    public boolean isCurrent(Mark mark) {
        return this.getCurrentMark().equals((Object)mark);
    }

    public Mark getCurrentMark() {
        return this.currentMark != null ? this.currentMark : Mark.DEFAULT;
    }

    public long getCurrentTime(boolean bl) {
        return this.getMarkTime((Mark)this.currentMark, bl);
    }

    public List getDrillDownPath() {
        ArrayList<Mark> arrayList = new ArrayList<Mark>(this.ddPath);
        if (this.isSelf) {
            arrayList.add(new Mark("SELF", "Self"));
        }
        return arrayList;
    }

    public boolean isInSelf() {
        return this.isSelf;
    }

    public long getMarkTime(Mark mark, boolean bl) {
        TimeTouple timeTouple = (TimeTouple)(bl ? this.netTimeMap : this.timeMap).get(mark);
        return timeTouple != null ? (this.secondTime ? timeTouple.time1 : timeTouple.time0) : 0L;
    }

    public List getSubmarks() {
        if (this.isSelf) {
            return Arrays.asList(this.currentMark);
        }
        ArrayList<HierarchicalMark> arrayList = new ArrayList<HierarchicalMark>(this.currentMark.getChildren());
        arrayList.add(this.currentMark);
        return arrayList;
    }

    public Mark getTopMark() {
        return this.root;
    }

    public long getTopTime(boolean bl) {
        return this.getMarkTime((Mark)this.root, bl);
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void addListener(DrillDownListener drillDownListener) {
        this.listeners.add(drillDownListener);
    }

    public boolean canDrilldown(Mark mark) {
        if (mark == null) {
            return false;
        }
        if (this.isSelf) {
            return false;
        }
        if (this.isCurrent(mark) && mark instanceof HierarchicalMark) {
            return ((HierarchicalMark)mark).getChildren().size() > 1;
        }
        return true;
    }

    public void drilldown(Mark mark) {
        if (!this.canDrilldown(mark)) {
            return;
        }
        if (mark.equals((Object)this.currentMark)) {
            this.isSelf = true;
            this.fireDrillDownChange();
        } else {
            this.isSelf = false;
            for (HierarchicalMark hierarchicalMark : this.currentMark.getChildren()) {
                if (!hierarchicalMark.equals((Object)mark)) continue;
                if (!this.canDrilldown(mark)) break;
                this.currentMark = hierarchicalMark;
                this.ddPath.add(this.currentMark);
                this.fireDrillDownChange();
                break;
            }
        }
    }

    public void drillup() {
        if (this.ddPath.size() == 1) {
            return;
        }
        this.ddPath.remove(this.ddPath.size() - 1);
        this.currentMark = (HierarchicalMark)this.ddPath.get(this.ddPath.size() - 1);
        this.fireDrillDownChange();
    }

    public void drillup(Mark mark) {
        if (!this.ddPath.contains(mark)) {
            return;
        }
        this.isSelf = false;
        for (int i = this.ddPath.size() - 1; i >= 0; --i) {
            if (this.ddPath.get(i).equals(mark)) {
                this.currentMark = (HierarchicalMark)this.ddPath.get(i);
                this.fireDrillDownChange();
                break;
            }
            this.ddPath.remove(this.ddPath.size() - 1);
        }
    }

    public boolean evaluate(Mark mark) {
        if (this.currentMark == null || this.currentMark.isRoot() && !this.isSelf) {
            return true;
        }
        if (this.currentMark.isDefault && mark.isDefault) {
            return true;
        }
        return this.isSelf ? mark.equals((Object)this.currentMark) : mark.getLabels().contains(this.currentMark.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.client.getTimeCollector() == null) {
            return;
        }
        this.clearTimeMaps();
        this.client.getTimeCollector().beginTrans(false);
        try {
            this.getTime(this.root);
        }
        finally {
            this.client.getTimeCollector().endTrans();
        }
        this.fireDataChange();
    }

    public void removeListener(DrillDownListener drillDownListener) {
        this.listeners.remove(drillDownListener);
    }

    public void reset() {
        this.ddPath.clear();
        this.ddPath.add(this.root);
        this.currentMark = this.root;
        this.isSelf = false;
        this.fireDrillDownChange();
    }

    private TimeTouple getTime(HierarchicalMark hierarchicalMark) {
        TimeTouple timeTouple;
        int n = MarkingEngine.getDefault().getMarkId((Mark)hierarchicalMark);
        if (n == -1) {
            this.netTimeMap.put(hierarchicalMark, TimeTouple.ZERO);
            this.timeMap.put(hierarchicalMark, TimeTouple.ZERO);
            return TimeTouple.ZERO;
        }
        long l = this.client.getTimeCollector().getNetTime0((Mark)hierarchicalMark);
        long l2 = this.client.getTimeCollector().getNetTime1((Mark)hierarchicalMark);
        long l3 = l;
        long l4 = l2;
        Object object = hierarchicalMark.getChildren().iterator();
        while (object.hasNext()) {
            timeTouple = this.getTime((HierarchicalMark)object.next());
            l += timeTouple.time0;
            l2 += timeTouple.time1;
        }
        object = new TimeTouple(l3, l4);
        timeTouple = new TimeTouple(l, l2);
        this.netTimeMap.put(hierarchicalMark, object);
        this.timeMap.put(hierarchicalMark, timeTouple);
        return timeTouple;
    }

    private void clearTimeMaps() {
        this.netTimeMap.clear();
        this.timeMap.clear();
    }

    private void fireDataChange() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((DrillDownListener)iterator.next()).dataChanged();
        }
    }

    private void fireDrillDownChange() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((DrillDownListener)iterator.next()).drillDownPathChanged(this.getDrillDownPath());
        }
    }

    private static class TimeTouple {
        public static final TimeTouple ZERO = new TimeTouple(0L, 0L);
        final long time0;
        final long time1;

        public TimeTouple(long l, long l2) {
            this.time0 = l;
            this.time1 = l2;
        }
    }
}

