/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.ClassPresenterPanel;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesListController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.ReferencesBrowserController;
import org.netbeans.modules.profiler.heapwalk.ui.InstancesControllerUI;

public class InstancesController
extends AbstractTopLevelController
implements FieldsBrowserController.Handler,
ReferencesBrowserController.Handler,
NavigationHistoryManager.NavigationHistoryCapable {
    private ClassPresenterPanel classPresenter;
    private FieldsBrowserController fieldsBrowserController;
    private HeapFragmentWalker heapFragmentWalker;
    private InstancesListController instancesListController;
    private JavaClass selectedClass;
    private ReferencesBrowserController referencesBrowserController;

    public InstancesController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.classPresenter = new ClassPresenterPanel();
        this.instancesListController = new InstancesListController(this);
        this.fieldsBrowserController = new FieldsBrowserController(this, 0);
        this.referencesBrowserController = new ReferencesBrowserController(this);
    }

    public void setClass(JavaClass javaClass) {
        if (javaClass == this.selectedClass) {
            return;
        }
        this.selectedClass = javaClass;
        ((InstancesControllerUI)this.getPanel()).update();
        this.updateClientPresentersEnabling(this.getClientPresenters());
        this.classPresenter.setJavaClass(javaClass);
        if (!this.instancesListController.getPanel().isVisible()) {
            this.instancesListController.getPanel().setVisible(true);
        }
        this.instancesListController.scheduleFirstInstanceSelection();
        this.instancesListController.setClass(javaClass);
    }

    public ClassPresenterPanel getClassPresenterPanel() {
        return this.classPresenter;
    }

    public Configuration getCurrentConfiguration() {
        long l = -1L;
        Instance instance = this.getSelectedInstance();
        if (instance != null) {
            l = instance.getInstanceId();
        }
        return new Configuration(l);
    }

    public FieldsBrowserController getFieldsBrowserController() {
        return this.fieldsBrowserController;
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public InstancesListController getInstancesListController() {
        return this.instancesListController;
    }

    public ReferencesBrowserController getReferencesBrowserController() {
        return this.referencesBrowserController;
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public Instance getSelectedInstance() {
        return this.instancesListController.getSelectedInstance();
    }

    public void configure(NavigationHistoryManager.Configuration configuration) {
        if (configuration instanceof Configuration) {
            Configuration configuration2 = (Configuration)configuration;
            Instance instance = null;
            long l = configuration2.getInstanceID();
            if (l != -1L) {
                instance = this.heapFragmentWalker.getHeapFragment().getInstanceByID(l);
            }
            if (instance != null) {
                JavaClass javaClass;
                this.selectedClass = javaClass = instance.getJavaClass();
                ((InstancesControllerUI)this.getPanel()).update();
                this.updateClientPresentersEnabling(this.getClientPresenters());
                this.heapFragmentWalker.switchToHistoryInstancesView();
                this.classPresenter.setJavaClass(javaClass);
                this.instancesListController.showInstance(instance);
            } else {
                this.heapFragmentWalker.switchToHistoryInstancesView();
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration: " + configuration);
        }
    }

    public void instanceSelected() {
        Instance instance = this.getSelectedInstance();
        this.fieldsBrowserController.setInstance(instance);
        this.referencesBrowserController.setInstance(instance);
    }

    public void showClass(JavaClass javaClass) {
        this.heapFragmentWalker.getClassesController().showClass(javaClass);
    }

    public void showInstance(Instance instance) {
        JavaClass javaClass;
        this.selectedClass = javaClass = instance.getJavaClass();
        ((InstancesControllerUI)this.getPanel()).update();
        this.updateClientPresentersEnabling(this.getClientPresenters());
        this.heapFragmentWalker.switchToInstancesView();
        this.classPresenter.setJavaClass(javaClass);
        this.instancesListController.showInstance(instance);
    }

    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.instancesListController.getPresenter(), this.fieldsBrowserController.getPresenter(), this.referencesBrowserController.getPresenter()};
    }

    protected AbstractButton createControllerPresenter() {
        return ((InstancesControllerUI)this.getPanel()).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new InstancesControllerUI(this);
    }

    protected void updateClientPresentersEnabling(AbstractButton[] abstractButtonArray) {
        if (this.selectedClass == null) {
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                abstractButtonArray[i].setVisible(false);
            }
        } else {
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                abstractButtonArray[i].setVisible(true);
            }
            super.updateClientPresentersEnabling(abstractButtonArray);
        }
    }

    public static class Configuration
    extends NavigationHistoryManager.Configuration {
        private long instanceID;

        public Configuration(long l) {
            this.instanceID = l;
        }

        public long getInstanceID() {
            return this.instanceID;
        }
    }
}

