/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.FragmentSnapshotPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemorySnapshotPanel;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SnapshotResultsWindow
extends TopComponent
implements SnapshotsListener {
    private static final String SAVE_SNAPSHOT_DIALOG_MSG = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_SaveSnapshotDialogMsg");
    private static final String CPU_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_CpuSnapshotAccessDescr");
    private static final String FRAGMENT_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_FragmentSnapshotAccessDescr");
    private static final String MEMORY_SNAPSHOT_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotResultsWindow_MemorySnapshotAccessDescr");
    private static final Image WINDOW_ICON_CPU = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpu.png");
    private static final Image WINDOWS_ICON_FRAGMENT = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/fragment.png");
    private static final Image WINDOWS_ICON_MEMORY = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png");
    private static final HashMap windowsList = new HashMap();
    private Component lastFocusOwner;
    private LoadedSnapshot snapshot;
    private SaveNode saveSupport = new SaveNode();
    private SavePerformer savePerformer = new SavePerformer();
    private SnapshotPanel displayedPanel;
    private String tabName = "";
    private boolean forcedClose = false;

    public SnapshotResultsWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotResultsWindow(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        this.snapshot = loadedSnapshot;
        ResultsManager.getDefault().addSnapshotsListener(this);
        this.updateSaveState();
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        switch (loadedSnapshot.getType()) {
            case 1: {
                this.getAccessibleContext().setAccessibleDescription(CPU_SNAPSHOT_ACCESS_DESCR);
                this.displayCPUResults(loadedSnapshot, n, bl);
                break;
            }
            case 2: {
                this.getAccessibleContext().setAccessibleDescription(FRAGMENT_SNAPSHOT_ACCESS_DESCR);
                this.displayCodeRegionResults(loadedSnapshot);
                break;
            }
            case 4: 
            case 8: {
                this.getAccessibleContext().setAccessibleDescription(MEMORY_SNAPSHOT_ACCESS_DESCR);
                this.displayMemoryResults(loadedSnapshot, n, bl);
            }
        }
    }

    public static synchronized void closeAllWindows() {
        Collection collection = windowsList.values();
        if (!collection.isEmpty()) {
            SnapshotResultsWindow[] snapshotResultsWindowArray = new SnapshotResultsWindow[collection.size()];
            collection.toArray(snapshotResultsWindowArray);
            for (int i = 0; i < snapshotResultsWindowArray.length; ++i) {
                SnapshotResultsWindow snapshotResultsWindow = snapshotResultsWindowArray[i];
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot loadedSnapshot) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)windowsList.get(loadedSnapshot);
        if (snapshotResultsWindow != null) {
            snapshotResultsWindow.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot) {
        return SnapshotResultsWindow.get(loadedSnapshot, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)windowsList.get(loadedSnapshot);
        if (snapshotResultsWindow == null) {
            snapshotResultsWindow = new SnapshotResultsWindow(loadedSnapshot, n, bl);
            windowsList.put(loadedSnapshot, snapshotResultsWindow);
        }
        return snapshotResultsWindow;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot loadedSnapshot) {
        return windowsList.get(loadedSnapshot) != null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public boolean canClose() {
        if (this.forcedClose) {
            this.setActivatedNodes(new Node[0]);
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        ProfilerDialogs.DNSAConfirmation dNSAConfirmation = new ProfilerDialogs.DNSAConfirmation("org.netbeans.modules.profiler.SnapshotResultsWindow.canClose", (Object)SAVE_SNAPSHOT_DIALOG_MSG, 1);
        dNSAConfirmation.setDNSADefault(false);
        Object object = ProfilerDialogs.notify((NotifyDescriptor)dNSAConfirmation);
        if (object.equals(DialogDescriptor.CANCEL_OPTION) || object.equals(DialogDescriptor.CLOSED_OPTION)) {
            return false;
        }
        if (object.equals(DialogDescriptor.YES_OPTION)) {
            ResultsManager.getDefault().saveSnapshot(this.snapshot);
            this.setActivatedNodes(new Node[0]);
            return true;
        }
        this.setActivatedNodes(new Node[0]);
        return true;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.displayedPanel != null) {
            this.displayedPanel.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public void displayStacksForClass(int n, int n2, boolean bl) {
        if (this.displayedPanel instanceof MemorySnapshotPanel) {
            ((MemorySnapshotPanel)this.displayedPanel).displayStacksForClass(n, n2, bl);
        }
    }

    public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
    }

    public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
    }

    public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
        this.updateSaveState();
    }

    public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            ResultsManager.getDefault().removeSnapshotsListener(this);
            this.snapshot = null;
            return;
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private void setTabName(String string) {
        this.tabName = string;
        this.updateTitle();
    }

    private void displayCPUResults(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        CPUSnapshotPanel cPUSnapshotPanel = new CPUSnapshotPanel(loadedSnapshot, n, bl);
        this.displayedPanel = cPUSnapshotPanel;
        this.updateFind(true, cPUSnapshotPanel);
        this.add(cPUSnapshotPanel, "Center");
        this.setTabName(cPUSnapshotPanel.getTitle());
        this.setIcon(WINDOW_ICON_CPU);
    }

    private void displayCodeRegionResults(LoadedSnapshot loadedSnapshot) {
        this.updateFind(false, null);
        FragmentSnapshotPanel fragmentSnapshotPanel = new FragmentSnapshotPanel(loadedSnapshot);
        this.displayedPanel = fragmentSnapshotPanel;
        this.add(fragmentSnapshotPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setTabName(fragmentSnapshotPanel.getTitle());
        this.setIcon(WINDOWS_ICON_FRAGMENT);
    }

    private void displayMemoryResults(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        MemorySnapshotPanel memorySnapshotPanel = new MemorySnapshotPanel(loadedSnapshot, n, bl);
        this.displayedPanel = memorySnapshotPanel;
        this.updateFind(true, memorySnapshotPanel);
        this.add(memorySnapshotPanel, "Center");
        this.setTabName(memorySnapshotPanel.getTitle());
        this.setIcon(WINDOWS_ICON_MEMORY);
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void updateFind(boolean bl, final FindPerformer findPerformer) {
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        if (bl) {
            this.getActionMap().put(object, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    findPerformer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(object);
        }
    }

    private void updateSaveState() {
        this.saveSupport.setSaveEnabled(!this.snapshot.isSaved());
        this.setActivatedNodes(new Node[]{this.saveSupport});
        if (this.displayedPanel != null) {
            this.displayedPanel.updateSavedState();
        }
    }

    private class SavePerformer
    implements SaveCookie {
        private SavePerformer() {
        }

        public void save() throws IOException {
            ResultsManager.getDefault().saveSnapshot(SnapshotResultsWindow.this.snapshot);
        }
    }

    private class SaveNode
    extends AbstractNode {
        public SaveNode() {
            super(Children.LEAF);
        }

        public void setSaveEnabled(boolean bl) {
            if (bl) {
                if (this.getCookie(SaveCookie.class) == null) {
                    this.getCookieSet().add((Node.Cookie)SnapshotResultsWindow.this.savePerformer);
                }
            } else if (this.getCookie(SaveCookie.class) != null) {
                this.getCookieSet().remove((Node.Cookie)SnapshotResultsWindow.this.savePerformer);
            }
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }
}

