/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class SnapshotDataObject
extends MultiDataObject
implements CookieSet.Factory,
OpenCookie {
    static final long serialVersionUID = -6037463545669336965L;
    private static final String SNAPSHOT_ICON_BASE_CPU = "org/netbeans/modules/profiler/resources/snapshotDataObjectCPU.png";
    private static final String SNAPSHOT_ICON_BASE_MEMORY = "org/netbeans/modules/profiler/resources/snapshotDataObjectMemory.png";
    private static final String SNAPSHOT_ICON_BASE_FRAGMENT = "org/netbeans/modules/profiler/resources/snapshotDataObjectFragment.png";

    public SnapshotDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add(OpenCookie.class, (CookieSet.Factory)this);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(OpenCookie.class)) {
            return this;
        }
        return null;
    }

    public void open() {
        LoadedSnapshot[] loadedSnapshotArray = ResultsManager.getDefault().loadSnapshots(new FileObject[]{this.getPrimaryFile()});
        ResultsManager.getDefault().openSnapshots(loadedSnapshotArray);
    }

    protected Node createNodeDelegate() {
        return new SnapshotNode(this);
    }

    private static final class SnapshotNode
    extends DataNode {
        public SnapshotNode(SnapshotDataObject snapshotDataObject) {
            super((DataObject)snapshotDataObject, Children.LEAF);
            int n = ResultsManager.getDefault().getSnapshotType(snapshotDataObject.getPrimaryFile());
            switch (n) {
                case 1: {
                    this.setIconBaseWithExtension(SnapshotDataObject.SNAPSHOT_ICON_BASE_CPU);
                    break;
                }
                case 2: {
                    this.setIconBaseWithExtension(SnapshotDataObject.SNAPSHOT_ICON_BASE_FRAGMENT);
                    break;
                }
                case 4: 
                case 8: {
                    this.setIconBaseWithExtension(SnapshotDataObject.SNAPSHOT_ICON_BASE_MEMORY);
                }
            }
        }

        public Image getIcon(int n) {
            return super.getIcon(n);
        }

        public Action getPreferredAction() {
            return SystemAction.get(OpenAction.class);
        }
    }
}

