/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.xml.bind.api.RawAccessor;
import com.sun.xml.ws.client.sei.ValueGetter;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

abstract class AsyncBuilder {
    public static AsyncBuilder NONE = new None();

    AsyncBuilder() {
    }

    abstract Object fillAsyncBean(Object[] var1, Object var2, Object var3);

    static final class DocLit
    extends Wrapped {
        private final RawAccessor[] accessors;
        private final Class wrapper;

        DocLit(Class wrapper, WrapperParameter wp) {
            super(wp);
            this.wrapper = wrapper;
            List<ParameterImpl> children = wp.getWrapperChildren();
            this.accessors = new RawAccessor[children.size()];
            for (int i = 0; i < this.accessors.length; ++i) {
                ParameterImpl p = children.get(i);
                QName name = p.getName();
                try {
                    this.accessors[i] = p.getOwner().getJAXBContext().getElementPropertyAccessor(wrapper, name.getNamespaceURI(), name.getLocalPart());
                    continue;
                }
                catch (JAXBException e) {
                    throw new WebServiceException(wrapper + " do not have a property of the name " + name, (Throwable)e);
                }
            }
        }

        Object fillAsyncBean(Object[] methodArgs, Object returnValue, Object bean) {
            try {
                for (int i = this.indices.length - 1; i >= 0; --i) {
                    Object obj = this.indices[i] == -1 ? returnValue : methodArgs[this.indices[i]];
                    this.accessors[i].set(bean, this.getters[i].get(obj));
                }
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
            return bean;
        }
    }

    static abstract class Wrapped
    extends AsyncBuilder {
        protected final int[] indices;
        protected final ValueGetter[] getters;

        protected Wrapped(WrapperParameter wp) {
            List<ParameterImpl> children = wp.getWrapperChildren();
            this.indices = new int[children.size()];
            this.getters = new ValueGetter[children.size()];
            for (int i = 0; i < this.indices.length; ++i) {
                ParameterImpl p = children.get(i);
                this.indices[i] = p.getIndex();
                this.getters[i] = ValueGetter.get(p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Composite
    extends AsyncBuilder {
        private final AsyncBuilder[] builders;
        private final Class beanClass;

        public Composite(AsyncBuilder[] builders, Class beanClass) {
            this.builders = builders;
            this.beanClass = beanClass;
        }

        public Composite(Collection<? extends AsyncBuilder> builders, Class beanClass) {
            this(builders.toArray(new AsyncBuilder[builders.size()]), beanClass);
        }

        @Override
        Object fillAsyncBean(Object[] methodArgs, Object returnValue, Object bean) {
            try {
                bean = this.beanClass.newInstance();
            }
            catch (Exception ex) {
                throw new WebServiceException((Throwable)ex);
            }
            for (AsyncBuilder builder : this.builders) {
                builder.fillAsyncBean(methodArgs, returnValue, bean);
            }
            return bean;
        }
    }

    static final class None
    extends AsyncBuilder {
        None() {
        }

        Object fillAsyncBean(Object[] methodArgs, Object returnValue, Object bean) {
            return bean;
        }
    }

    static final class Filler
    extends AsyncBuilder {
        private final int methodPos;
        private final ValueGetter getter;

        Filler(ParameterImpl p) {
            this.methodPos = p.getIndex();
            this.getter = ValueGetter.get(p);
        }

        Object fillAsyncBean(Object[] methodArgs, Object returnValue, Object bean) {
            return this.methodPos == -1 ? returnValue : this.getter.get(methodArgs[this.methodPos]);
        }
    }

    static final class Bare
    extends AsyncBuilder {
        private final int methodPos;
        private final ValueGetter getter;
        private final RawAccessor accessor;

        Bare(Class wrapper, ParameterImpl p) {
            this.methodPos = p.getIndex();
            this.getter = ValueGetter.get(p);
            QName name = p.getName();
            try {
                this.accessor = p.getOwner().getJAXBContext().getElementPropertyAccessor(wrapper, name.getNamespaceURI(), name.getLocalPart());
            }
            catch (JAXBException e) {
                throw new WebServiceException(wrapper + " do not have a property of the name " + name, (Throwable)e);
            }
        }

        Object fillAsyncBean(Object[] methodArgs, Object returnValue, Object bean) {
            Object obj = this.methodPos == -1 ? returnValue : this.getter.get(methodArgs[this.methodPos]);
            try {
                this.accessor.set(bean, obj);
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
            return bean;
        }
    }
}

